/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.service.creditlimit;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.creditm.business.service.creditlimit.CreditLimitService;
import kd.tmc.creditm.common.bean.CreditLimitRpcResultBean;
import kd.tmc.creditm.common.bean.CreditVarietyBean;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;

public class CreditLimitRpcServiceImpl {
    private static Log logger = LogFactory.getLog(CreditLimitRpcServiceImpl.class);
    private CreditLimitService service = new CreditLimitService();

    public String getCreditLimitAvaAmt(String param) {
        return this.invokeCreditService(param, CreditLimitUseBean.class, bean -> this.service.getCreditLimitAvaAmt((CreditLimitUseBean)bean));
    }

    public String checkCreditLimitAmt(String param) {
        return this.invokeCreditService(param, CreditLimitUseBean.class, bean -> this.service.checkCreditLimitAmt((CreditLimitUseBean)bean));
    }

    public String autoUseCreditLimit(String param) {
        return this.invokeCreditService(param, CreditLimitUseBean.class, bean -> this.service.autoUseCreditLimit((CreditLimitUseBean)bean));
    }

    public String confirmCreditLimit(String param) {
        return this.invokeCreditService(param, CreditLimitInfo.class, bean -> this.service.confirmCreditLimit((CreditLimitInfo)bean));
    }

    public String cancelCreditLimit(String param) {
        return this.invokeCreditService(param, CreditLimitInfo.class, bean -> this.service.cancelCreditLimit((CreditLimitInfo)bean));
    }

    public String returnCreditLimit(String param) {
        return this.invokeCreditService(param, ReturnCreditLimitInfo.class, bean -> this.service.returnCreditLimit((ReturnCreditLimitInfo)bean));
    }

    public String batchReturnCreditLimit(String param) {
        return this.invokeBatchCreditService(param, ReturnCreditLimitInfo.class, bean -> this.service.batchReturnCreditLimit(bean));
    }

    public String cancelReturnCreditLimit(String param) {
        return this.invokeCreditService(param, ReturnCreditLimitInfo.class, bean -> this.service.cancelReturnCreditLimit((ReturnCreditLimitInfo)bean));
    }

    public String batchCancelReturnCreditLimit(String param) {
        return this.invokeBatchCreditService(param, ReturnCreditLimitInfo.class, bean -> this.service.batchCancelReturnCreditLimit(bean));
    }

    public String updateCreditLimitUse(String param) {
        return this.invokeCreditService(param, CreditLimitUseBean.class, bean -> this.service.updateCreditLimitUse((CreditLimitUseBean)bean));
    }

    public String deleteCreditLimitUse(String param) {
        return this.invokeCreditService(param, Map.class, map -> {
            this.service.deleteCreditLimitUse((Map<Long, Object>)map);
            return null;
        });
    }

    public String addCreditVariety(String addVarietyJson) {
        return this.invokeCreditService(addVarietyJson, CreditVarietyBean.class, bean -> {
            this.service.addCreditVariety(bean.getCreditTypeId(), bean.getBizBaseId(), bean.getFormId());
            return null;
        });
    }

    public String deleteCreditVariety(String deleteVarietyJson) {
        return this.invokeCreditService(deleteVarietyJson, CreditVarietyBean.class, bean -> {
            this.service.deleteCreditVariety(bean.getCreditTypeId(), bean.getBizBaseId(), bean.getFormId());
            return null;
        });
    }

    private <T> String invokeCreditService(String json, Class<T> clz, InvokeCreditService<T> invokeService) {
        Object bean;
        logger.info("creditservice start, params:{}", (Object)json);
        long startTime = System.currentTimeMillis();
        try {
            bean = SerializationUtils.fromJsonString((String)json, clz);
        }
        catch (Exception e) {
            return SerializationUtils.toJsonString((Object)new CreditLimitRpcResultBean(Boolean.FALSE, ResManager.loadKDString((String)"JSON\u89e3\u6790\u5f02\u5e38, \u8bf7\u68c0\u67e5\u53c2\u6570\u3002", (String)"CreditLimitRpcServiceImpl_0", (String)"tmc-creditm-business", (Object[])new Object[0])));
        }
        Object result = invokeService.invoke(bean);
        logger.info("creditservice end, use time:{}ms", (Object)(System.currentTimeMillis() - startTime));
        if (result != null) {
            return SerializationUtils.toJsonString((Object)result);
        }
        return SerializationUtils.toJsonString((Object)new CreditLimitRpcResultBean(Boolean.TRUE, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"CreditLimitRpcServiceImpl_2", (String)"tmc-creditm-business", (Object[])new Object[0])));
    }

    private <T> String invokeBatchCreditService(String json, Class<T> clz, InvokeBatchCreditService<T> invokeService) {
        List bean;
        logger.info("batch creditservice start, params:{}", (Object)json);
        long startTime = System.currentTimeMillis();
        try {
            bean = SerializationUtils.fromJsonStringToList((String)json, clz);
        }
        catch (Exception e) {
            return SerializationUtils.toJsonString((Object)new CreditLimitRpcResultBean(Boolean.FALSE, ResManager.loadKDString((String)"JSON\u89e3\u6790\u5f02\u5e38, \u8bf7\u68c0\u67e5\u53c2\u6570\u3002", (String)"CreditLimitRpcServiceImpl_0", (String)"tmc-creditm-business", (Object[])new Object[0])));
        }
        Object result = invokeService.invoke(bean);
        logger.info("batch creditservice end, use time:{}ms", (Object)(System.currentTimeMillis() - startTime));
        if (result != null) {
            return SerializationUtils.toJsonString((Object)result);
        }
        return SerializationUtils.toJsonString((Object)new CreditLimitRpcResultBean(Boolean.TRUE, ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"CreditLimitRpcServiceImpl_2", (String)"tmc-creditm-business", (Object[])new Object[0])));
    }

    private static interface InvokeBatchCreditService<T> {
        public Object invoke(List<T> var1);
    }

    private static interface InvokeCreditService<T> {
        public Object invoke(T var1);
    }
}

