/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.service.creditlimit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.creditm.business.helper.CreditlimitHelper;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.enums.CreditPropEnum;
import kd.tmc.creditm.common.helper.CreditLimitAmtHelper;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.creditm.common.helper.RateHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CreditLimitService {
    private static final Log logger = LogFactory.getLog(CreditLimitService.class);

    public BigDecimal getCreditLimitAvaAmt(CreditLimitUseBean useBean) {
        Date endDate = useBean.getEndDate();
        Date startDate = useBean.getStartDate();
        DynamicObject creditLimit = this.getRealCreditLimitById(useBean.getCreditLimitId());
        String msg = CreditLimitHelper.checkStatus((DynamicObject)creditLimit);
        if (EmptyUtil.isNoEmpty((String)msg)) {
            return BigDecimal.ZERO;
        }
        if (EmptyUtil.isNoEmpty((Object)endDate) && creditLimit.getDate("enddate").compareTo(endDate) < 0) {
            return BigDecimal.ZERO;
        }
        if (EmptyUtil.isNoEmpty((Object)startDate) && creditLimit.getDate("startdate").compareTo(startDate) > 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal creditLimitAvarAmt = CreditLimitHelper.getCreditLimitAvarAmt((DynamicObject)creditLimit, (Long)useBean.getCreditTypeId(), (Long)useBean.getOrgId(), null);
        return creditLimitAvarAmt;
    }

    public CreditLimitF7ResBean checkCreditLimitAmt(CreditLimitUseBean useBean) {
        DynamicObject creditUseBill;
        String msg = CreditLimitHelper.checkBean((CreditLimitUseBean)useBean);
        if (EmptyUtil.isNoEmpty((String)msg)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u8d4b\u503c[%s]", (String)"CreditLimitService_23", (String)"tmc-creditm-business", (Object[])new Object[]{msg}));
        }
        Long billId = useBean.getPkId();
        DynamicObject creditLimit = this.getRealCreditLimitById(useBean.getCreditLimitId());
        BigDecimal creditRatio = useBean.getCreditRatio();
        if (EmptyUtil.isEmpty((BigDecimal)creditRatio) && EmptyUtil.isNoEmpty((Long)billId) && EmptyUtil.isNoEmpty((DynamicObject)(creditUseBill = CreditLimitHelper.getCreditUseBill((Long)billId, (String)useBean.getSourceType(), (Long)billId)))) {
            creditRatio = creditUseBill.getBigDecimal("creditratio");
        }
        HashMap<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>();
        DynamicObject creditUseSourceBill = CreditLimitHelper.getCreditUseBill((Long)useBean.getSourceBillId(), null, (Long)useBean.getSourceBillEntryId());
        if (EmptyUtil.isNoEmpty((DynamicObject)creditUseSourceBill)) {
            if (EmptyUtil.isEmpty((BigDecimal)creditRatio)) {
                creditRatio = creditUseSourceBill.getBigDecimal("creditratio");
            }
            DynamicObject creditBill = creditUseSourceBill.getDynamicObject("creditlimit");
            long creditLimitUseId = creditBill.getLong("id");
            DynamicObject org = creditUseSourceBill.getDynamicObject("org");
            DynamicObject creditType = creditUseSourceBill.getDynamicObject("credittype");
            String typeIds = creditType != null ? creditType.getString("id") : "";
            amtMap.put(org.getString("id") + creditLimitUseId + typeIds, creditUseSourceBill.getBigDecimal("realamt"));
        }
        DynamicObject currency = RateHelper.getCurrency((Long)useBean.getCurrencyId());
        DynamicObject creditCurr = creditLimit.getDynamicObject("currency");
        BigDecimal rate = RateHelper.getMdTate((DynamicObject)creditLimit.getDynamicObject("forexquote"), (DynamicObject)currency, (DynamicObject)creditCurr, (Long)creditLimit.getDynamicObject("org").getLong("id"), (Date)new Date());
        if (rate == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5e01\u79cd[%1$s]\u6298\u6388\u4fe1\u5e01\u79cd[%2$s]\u7684\u6c47\u7387\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387", (String)"CreditLimitService_19", (String)"tmc-creditm-business", (Object[])new Object[0]), currency.getString("number"), creditCurr.getString("number")));
        }
        BigDecimal creditLimitAvarAmt = CreditLimitHelper.getCreditLimitAvarAmt((DynamicObject)creditLimit, (Long)useBean.getCreditTypeId(), (Long)useBean.getOrgId(), amtMap);
        BigDecimal bizUseAmt = useBean.getBizAmt().multiply(creditRatio.divide(Constants.ONE_HUNDRED)).multiply(rate);
        CreditLimitF7ResBean res = new CreditLimitF7ResBean();
        res.setCreditLimitId(Long.valueOf(creditLimit.getLong("id")));
        res.setTransScale(rate);
        BigDecimal realAmt = useBean.getBizAmt().multiply(creditRatio.divide(Constants.ONE_HUNDRED));
        res.setRealBizAmt(realAmt);
        boolean isAmtOver = bizUseAmt.compareTo(creditLimitAvarAmt) > 0;
        res.setSuccess(Boolean.valueOf(!isAmtOver));
        int amtPrecision = creditCurr.getInt("amtprecision");
        res.setMsg(isAmtOver ? String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u5360\u6bd4[%1$s]\uff0c\u6c47\u7387\u4e3a[%2$s]\uff0c\u5b9e\u9645\u5360\u7528\u989d\u5ea6[%3$s]\uff0c\u6388\u4fe1\u989d\u5ea6\u5355[%4$s]\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\uff0c\u5269\u4f59\u989d\u5ea6\u4e3a[%5$s]\u3002", (String)"CreditLimitHelper_3", (String)"tmc-creditm-common", (Object[])new Object[0]), creditRatio + "%", rate, currency.getString("sign") + realAmt.setScale(amtPrecision, RoundingMode.HALF_UP), creditLimit.getString("number"), creditCurr.getString("sign") + creditLimitAvarAmt.setScale(amtPrecision, RoundingMode.HALF_UP)) : "");
        return res;
    }

    public CreditLimitF7ResBean autoUseCreditLimit(CreditLimitUseBean useBean) {
        CreditLimitF7ResBean returnDataBean = new CreditLimitF7ResBean();
        returnDataBean.setSuccess(Boolean.TRUE);
        returnDataBean.setMsg(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"CreditLimitService_3", (String)"tmc-creditm-business", (Object[])new Object[0]));
        if (EmptyUtil.isEmpty((BigDecimal)useBean.getBizAmt())) {
            logger.info("bizamt is null, bizid:{}", (Object)useBean.getPkId());
            return returnDataBean;
        }
        String creditLimitNo = useBean.getCreditLimitNo();
        QFilter creditLimitNoFilter = new QFilter("number", "=", (Object)creditLimitNo);
        DynamicObject creditLimit = TmcDataServiceHelper.loadSingle((String)"cfm_creditlimit", (String)"id,ismergesrc", (QFilter[])new QFilter[]{creditLimitNoFilter});
        if (creditLimit != null) {
            if (creditLimit.getBoolean("ismergesrc")) {
                creditLimit = this.getRealCreditLimitById(creditLimit.getPkValue());
                CreditLimitHelper.checkCreditLimitStatus((String)creditLimitNo, (DynamicObject)creditLimit, (boolean)true);
            } else {
                creditLimit = TmcDataServiceHelper.loadSingle((Object)creditLimit.getPkValue(), (String)"cfm_creditlimit");
                CreditLimitHelper.checkCreditLimitStatus((String)creditLimitNo, (DynamicObject)creditLimit, (boolean)false);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355\u4e0d\u5b58\u5728", (String)"CreditLimitService_0", (String)"tmc-creditm-business", (Object[])new Object[0]));
        }
        useBean.setPreOccupy(Boolean.valueOf(useBean.getPreOccupy() != null ? useBean.getPreOccupy() : false));
        Map preAmountMap = CreditLimitHelper.getPreAmountByCreditType((CreditLimitUseBean)useBean);
        BigDecimal totalAvaAmt = CreditLimitHelper.getCanUseCreditLimitAmt((CreditLimitUseBean)useBean, (DynamicObject)creditLimit, (Map)preAmountMap);
        if (totalAvaAmt.compareTo(BigDecimal.ZERO) <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u4e3a0\u3002", (String)"CreditLimitService_1", (String)"tmc-creditm-business", (Object[])new Object[0]));
        }
        DynamicObject currency = RateHelper.getCurrency((Long)useBean.getCurrencyId());
        DynamicObject creditCurr = creditLimit.getDynamicObject("currency");
        BigDecimal rate = RateHelper.getMdTate((DynamicObject)creditLimit.getDynamicObject("forexquote"), (DynamicObject)currency, (DynamicObject)creditCurr, (Long)creditLimit.getDynamicObject("org").getLong("id"), (Date)new Date());
        if (rate == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5e01\u79cd[%1$s]\u6298\u6388\u4fe1\u5e01\u79cd[%2$s]\u7684\u6c47\u7387\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387", (String)"CreditLimitService_19", (String)"tmc-creditm-business", (Object[])new Object[0]), currency.getString("number"), creditCurr.getString("number")));
        }
        BigDecimal realAmt = useBean.getBizAmt();
        BigDecimal creditRatio = useBean.getCreditRatio();
        if (EmptyUtil.isEmpty((BigDecimal)creditRatio)) {
            creditRatio = EmptyUtil.isEmpty((BigDecimal)useBean.getMaxAmt()) ? Constants.ONE_HUNDRED : useBean.getBizAmt().multiply(Constants.ONE_HUNDRED).divide(useBean.getMaxAmt(), 6, RoundingMode.DOWN);
            useBean.setCreditRatio(creditRatio);
        } else {
            realAmt = useBean.getBizAmt().multiply(creditRatio.divide(Constants.ONE_HUNDRED));
        }
        BigDecimal bizAmtTrans = realAmt.multiply(rate);
        int amtPrecision = creditCurr.getInt("amtprecision");
        if (totalAvaAmt.compareTo(bizAmtTrans) < 0) {
            if (useBean.isPart()) {
                CreditLimitHelper.creditPartUse((CreditLimitUseBean)useBean, (BigDecimal)totalAvaAmt, (BigDecimal)rate, (DynamicObject)currency);
                if (EmptyUtil.isEmpty((BigDecimal)useBean.getCreditRatio())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6388\u4fe1\u5360\u6bd4\u6bd4\u4f8b\u4e3a0, %s\u5931\u8d25\u3002", (String)"CreditLimitService_24", (String)"tmc-creditm-business", (Object[])new Object[]{CreditLimitHelper.getMsg((Boolean)useBean.getPreOccupy())}));
                }
            } else {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355[%1$s]\u53ef\u7528\u989d\u5ea6[%2$s]\u4e0d\u8db3, %3$s\u5931\u8d25\u3002", (String)"CreditLimitService_2", (String)"tmc-creditm-business", (Object[])new Object[0]), creditLimit.getString("number"), creditCurr.getString("sign") + totalAvaAmt.setScale(amtPrecision, RoundingMode.HALF_DOWN), CreditLimitHelper.getMsg((Boolean)useBean.getPreOccupy())));
            }
        }
        ArrayList<Map<String, Object>> useDetailList = new ArrayList<Map<String, Object>>();
        HashMap<String, Number> useMap = new HashMap<String, Number>();
        useMap.put("et_credittype", useBean.getCreditTypeId());
        useMap.put("et_useamt", bizAmtTrans.setScale(CreditLimitHelper.getAmtPrecision((DynamicObject)creditLimit.getDynamicObject("currency")), RoundingMode.DOWN));
        useMap.put("amount", realAmt);
        useMap.put("creditratio", useBean.getCreditRatio());
        useMap.put("exchangerate", rate);
        useMap.put("bizamount", useBean.getMaxAmt());
        useDetailList.add(useMap);
        this.useCreditLimit(useBean, creditLimit, useDetailList);
        returnDataBean.setCreditLimitId((Long)creditLimit.getPkValue());
        returnDataBean.setTransScale(rate);
        returnDataBean.setRealBizAmt(useBean.getBizAmt());
        return returnDataBean;
    }

    public void useCreditLimit(CreditLimitUseBean useBean, DynamicObject creditLimit, List<Map<String, Object>> useDetailList) {
        if (EmptyUtil.isEmpty((String)useBean.getCreditFinType())) {
            useBean.setCreditFinType(CreditFinTypeEnum.FINORG.getValue());
        }
        CreditLimitHelper.checkCreditLimitLegal((CreditLimitUseBean)useBean, (DynamicObject)creditLimit);
        ArrayList<DynamicObject> useObjList = new ArrayList<DynamicObject>(useDetailList.size());
        Long sourceBillEntryId = useBean.getSourceBillEntryId();
        sourceBillEntryId = EmptyUtil.isEmpty((Long)sourceBillEntryId) ? useBean.getPkId() : sourceBillEntryId;
        useBean.setPreOccupy(Boolean.valueOf(useBean.getPreOccupy() != null ? useBean.getPreOccupy() : false));
        for (Map<String, Object> useDetail : useDetailList) {
            Object ratio;
            Object creditTypeId = useDetail.get("et_credittype");
            String ctrlType = (String)useDetail.get("et_ctrltype");
            BigDecimal amt = (BigDecimal)useDetail.get("et_useamt");
            DynamicObject useObj = TmcDataServiceHelper.newDynamicObject((String)"cfm_credituse");
            String entityName = useBean.getEntityName();
            MainEntityType sourceEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            useObj.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            useObj.set("currency", (Object)creditLimit.getDynamicObject("currency"));
            useObj.set("org", (Object)useBean.getOrgId());
            useObj.set("creditlimit", creditLimit.getPkValue());
            useObj.set("sourcetype", (Object)entityName);
            useObj.set("sourcename", (Object)sourceEntityType.getDisplayName().getLocaleValue());
            useObj.set("sourcebillid", (Object)useBean.getPkId());
            useObj.set("sourcebillentryid", (Object)sourceBillEntryId);
            useObj.set("creditvariety", (Object)useBean.getCreditVariety());
            useObj.set("startdate", (Object)useBean.getStartDate());
            useObj.set("enddate", (Object)useBean.getEndDate());
            useObj.set("amount", (Object)(useBean.getPreOccupy() != false ? BigDecimal.ZERO : amt));
            useObj.set("realamt", (Object)amt);
            useObj.set("preamount", (Object)(useBean.getPreOccupy() != false ? amt : BigDecimal.ZERO));
            useObj.set("returnamt", (Object)BigDecimal.ZERO);
            useObj.set("ctrltype", (Object)ctrlType);
            useObj.set("bizcurrency", (Object)useBean.getCurrencyId());
            Object bizAmount = useDetail.get("bizamount");
            if (EmptyUtil.isEmpty((Object)bizAmount)) {
                bizAmount = useBean.getMaxAmt();
            }
            if (EmptyUtil.isEmpty((Object)(ratio = useDetail.get("creditratio")))) {
                ratio = useBean.getCreditRatio();
            }
            useObj.set("bizamount", bizAmount);
            useObj.set("creditratio", ratio);
            useObj.set("bizcreditamount", useDetail.get("amount"));
            useObj.set("creditrate", useDetail.get("exchangerate"));
            useObj.set("createtime", (Object)new Date());
            useObj.set("creator", (Object)RequestContext.get().getCurrUserId());
            useObj.set("totalamt", (Object)creditLimit.getBigDecimal("totalamt"));
            useObj.set("avaramt", (Object)creditLimit.getBigDecimal("avaramt"));
            useObj.set("credittype", creditTypeId);
            useObjList.add(useObj);
        }
        QFilter filter = new QFilter("sourcetype", "=", (Object)useBean.getEntityName()).and(new QFilter("sourcebillid", "=", (Object)useBean.getPkId())).and(new QFilter("sourcebillentryid", "=", (Object)sourceBillEntryId)).and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()));
        DeleteServiceHelper.delete((String)"cfm_credituse", (QFilter[])new QFilter[]{filter});
        TmcDataServiceHelper.save((DynamicObject[])useObjList.toArray(new DynamicObject[0]));
    }

    public CreditLimitInfo confirmCreditLimit(CreditLimitInfo param) {
        logger.info("creditlimit\u6388\u4fe1\u5360\u7528\u5f00\u59cb\uff1a\u4e1a\u52a1\u5355\u636eID:{}", (Object)param.getId());
        if (EmptyUtil.isNoEmpty((Long)param.getPreId())) {
            ReturnCreditLimitInfo info = new ReturnCreditLimitInfo();
            info.setId(param.getPreId());
            info.setEntityName(param.getPreEntityName());
            info.setReturnBillId(param.getId());
            info.setPreOccupy(true);
            info.setPreEntityName(param.getEntityName());
            info.setReturnTime(param.getCreatetime());
            DynamicObject creditUse = this.getCurrentCreditLimitUse(param.getId(), BillStatusEnum.SAVE.getValue());
            if (EmptyUtil.isNoEmpty((DynamicObject)creditUse)) {
                DynamicObject buzCurrency = creditUse.getDynamicObject("bizcurrency");
                info.setBizCurreny(buzCurrency != null ? Long.valueOf(buzCurrency.getLong("id")) : null);
                DynamicObject creditPreUse = this.getCurrentCreditLimitUse(param.getPreId(), BillStatusEnum.AUDIT.getValue());
                if (creditPreUse != null) {
                    BigDecimal returnAmt = creditUse.getBigDecimal("bizcreditamount").multiply(Constants.ONE_HUNDRED).divide(creditUse.getBigDecimal("creditratio"), 12, RoundingMode.HALF_UP);
                    DynamicObject preBizCurrency = creditPreUse.getDynamicObject("bizcurrency");
                    DynamicObject org = creditPreUse.getDynamicObject("org");
                    if (creditPreUse != null && buzCurrency != null && preBizCurrency != null && org != null && buzCurrency.getLong("id") != preBizCurrency.getLong("id")) {
                        BigDecimal rate = RateHelper.getMdTate(null, (DynamicObject)buzCurrency, (DynamicObject)preBizCurrency, (Long)org.getLong("id"), (Date)(EmptyUtil.isNoEmpty((Object)param.getCreatetime()) ? param.getCreatetime() : DateUtils.getCurrentDate()));
                        returnAmt = returnAmt.multiply(EmptyUtil.isEmpty((BigDecimal)rate) ? BigDecimal.ONE : rate).setScale(preBizCurrency.getInt("amtprecision"), RoundingMode.HALF_UP);
                    }
                    info.setReturnAmt(returnAmt);
                }
            } else {
                info.setLast(true);
            }
            logger.info("creditlimit\u6388\u4fe1\u5360\u7528,\u5148\u8fd4\u8fd8\u9884\u5360\u6388\u4fe1\uff1a\u4e1a\u52a1\u5355\u636eID:{}", (Object)info.getId());
            this.returnCreditLimit(info);
        }
        this.confirmCreditLimit(param.getEntityName(), param.getId(), param.getBillno(), param.isPreOccupy(), false, param.getCreatetime());
        logger.info("creditlimit\u6388\u4fe1\u5360\u7528\u7ed3\u675f,\u4e1a\u52a1\u5355\u636eID:{}", (Object)param.getId());
        return param;
    }

    public CreditLimitInfo cancelCreditLimit(CreditLimitInfo param) {
        logger.info("creditlimit\u6388\u4fe1\u53d6\u6d88\u5360\u7528\u5f00\u59cb,\u4e1a\u52a1\u5355\u636eID:{}", (Object)param.getId());
        this.confirmCreditLimit(param.getEntityName(), param.getId(), param.getBillno(), param.isPreOccupy(), true, null);
        if (EmptyUtil.isNoEmpty((Long)param.getPreId())) {
            ReturnCreditLimitInfo info = new ReturnCreditLimitInfo();
            info.setId(param.getPreId());
            info.setEntityName(param.getPreEntityName());
            info.setReturnBillId(param.getId());
            info.setBizBillId(param.getId());
            info.setPreOccupy(true);
            DynamicObject creditUse = this.getCurrentCreditLimitUse(param.getId(), BillStatusEnum.SAVE.getValue());
            if (EmptyUtil.isNoEmpty((DynamicObject)creditUse)) {
                info.setReturnAmt(creditUse.getBigDecimal("bizcreditamount").multiply(Constants.ONE_HUNDRED).divide(creditUse.getBigDecimal("creditratio"), 12, RoundingMode.HALF_UP));
            }
            ReturnCreditLimitInfo returnCreditLimitInfo = this.cancelReturnCreditLimit(info);
            param.setMessage(returnCreditLimitInfo.getMessage());
        }
        logger.info("creditlimit\u6388\u4fe1\u53d6\u6d88\u5360\u7528\u7ed3\u675f,\u4e1a\u52a1\u5355\u636eID:{}", (Object)param.getId());
        return param;
    }

    public ReturnCreditLimitInfo batchReturnCreditLimit(List<ReturnCreditLimitInfo> paramList) {
        logger.info("creditlimit\u6388\u4fe1\u6279\u91cf\u8fd4\u8fd8\u5f00\u59cb");
        HashMap<Long, ReturnCreditLimitInfo> returnInfoMap = new HashMap<Long, ReturnCreditLimitInfo>(paramList.size());
        for (ReturnCreditLimitInfo info : paramList) {
            returnInfoMap.put(info.getId(), info);
        }
        Set<String> entityNames = paramList.stream().map(o -> o.getEntityName()).collect(Collectors.toSet());
        Set<Long> pkIds = paramList.stream().map(o -> o.getId()).collect(Collectors.toSet());
        QFilter[] filters = this.getBatchCreditUseFilter(entityNames, pkIds, BillStatusEnum.AUDIT.getValue());
        this.handleCreditLimit(filters, creditPairs -> this.returnAmtByCreditUse(creditPairs, returnInfoMap));
        logger.info("creditlimit\u6388\u4fe1\u6279\u91cf\u8fd4\u8fd8\u7ed3\u675f");
        return null;
    }

    public ReturnCreditLimitInfo returnCreditLimit(ReturnCreditLimitInfo param) {
        logger.info("creditlimit\u6388\u4fe1\u8fd4\u8fd8\u5f00\u59cb,\u4e1a\u52a1\u5355\u636eID:{}", (Object)param.getId());
        QFilter[] filters = this.getCreditUseFilter(param.getEntityName(), param.getId(), BillStatusEnum.AUDIT.getValue());
        HashMap<Long, ReturnCreditLimitInfo> returnInfoMap = new HashMap<Long, ReturnCreditLimitInfo>();
        returnInfoMap.put(param.getId(), param);
        this.handleCreditLimit(filters, creditPairs -> this.returnAmtByCreditUse(creditPairs, returnInfoMap));
        logger.info("creditlimit\u6388\u4fe1\u8fd4\u8fd8\u7ed3\u675f,\u4e1a\u52a1\u5355\u636eID:{}", (Object)param.getId());
        return param;
    }

    public ReturnCreditLimitInfo batchCancelReturnCreditLimit(List<ReturnCreditLimitInfo> paramList) {
        logger.info("creditlimit\u6388\u4fe1\u6279\u91cf\u53d6\u6d88\u8fd4\u8fd8\u5f00\u59cb");
        HashMap<Long, ReturnCreditLimitInfo> returnInfoMap = new HashMap<Long, ReturnCreditLimitInfo>(paramList.size());
        for (ReturnCreditLimitInfo info : paramList) {
            returnInfoMap.put(info.getReturnBillId(), info);
        }
        Set<String> entityNames = paramList.stream().map(o -> o.getEntityName()).collect(Collectors.toSet());
        Set<Long> pkIds = paramList.stream().map(o -> o.getId()).collect(Collectors.toSet());
        QFilter[] filters = this.getBatchCreditUseFilter(entityNames, pkIds, BillStatusEnum.AUDIT.getValue());
        this.handleCreditLimit(filters, creditPairs -> this.cancelReturnAmtByCreditUse(creditPairs, returnInfoMap));
        logger.info("creditlimit\u6388\u4fe1\u6279\u91cf\u53d6\u6d88\u8fd4\u8fd8\u7ed3\u675f");
        return null;
    }

    public ReturnCreditLimitInfo cancelReturnCreditLimit(ReturnCreditLimitInfo param) {
        logger.info("creditlimit\u6388\u4fe1\u53d6\u6d88\u8fd4\u8fd8\u5f00\u59cb,\u4e1a\u52a1\u5355\u636eID:{}", (Object)param.getId());
        QFilter[] filters = this.getCreditUseFilter(param.getEntityName(), param.getId(), BillStatusEnum.AUDIT.getValue());
        HashMap<Long, ReturnCreditLimitInfo> returnInfoMap = new HashMap<Long, ReturnCreditLimitInfo>();
        Long useBizId = param.getId();
        returnInfoMap.put(useBizId, param);
        this.handleCreditLimit(filters, creditPairs -> this.cancelReturnAmtByCreditUse(creditPairs, returnInfoMap));
        logger.info("creditlimit\u6388\u4fe1\u53d6\u6d88\u8fd4\u8fd8\u7ed3\u7b97,\u4e1a\u52a1\u5355\u636eID:{}", (Object)param.getId());
        return param;
    }

    public void addCreditVariety(Long creditTypeId, Long bizBillId, String formId) {
        CreditLimitService.updateCreditVariety(creditTypeId, creditType -> {
            DynamicObjectCollection entrys = creditType.getDynamicObjectCollection("entryentity");
            Set entryIds = entrys.stream().filter(o -> o.getDynamicObject("basedata") != null).map(t -> t.getDynamicObject("basedata").getLong("id")).collect(Collectors.toSet());
            if (!entryIds.contains(bizBillId)) {
                DynamicObject entry = entrys.addNew();
                entry.set("basetype", (Object)formId);
                entry.set("basedata", (Object)bizBillId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{creditType});
                return true;
            }
            return false;
        });
    }

    public void deleteCreditVariety(Long creditTypeId, Long bizBillId, String formId) {
        CreditLimitService.updateCreditVariety(creditTypeId, creditType -> {
            DynamicObjectCollection entrys = creditType.getDynamicObjectCollection("entryentity");
            Iterator iterator = entrys.iterator();
            while (iterator.hasNext()) {
                DynamicObject ite = (DynamicObject)iterator.next();
                if (ite.getDynamicObject("basedata") == null || !bizBillId.equals(ite.getDynamicObject("basedata").getLong("id")) || !formId.equals(ite.getString("basetype"))) continue;
                iterator.remove();
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{creditType});
                return true;
            }
            return false;
        });
    }

    private DynamicObject getCurrentCreditLimitUse(Long id, String billStatus) {
        QFilter filter = new QFilter("sourcebillid", "=", (Object)id);
        filter.and(new QFilter("billstatus", "=", (Object)billStatus));
        return TmcDataServiceHelper.loadSingle((String)"cfm_credituse", (String)"realamt,bizcreditamount,bizcurrency,creditratio,org,createtime", (QFilter[])filter.toArray());
    }

    private void returnAmtByCreditUse(List<Pair<DynamicObject, List<DynamicObject>>> creditPairs, Map<Long, ReturnCreditLimitInfo> returnInfoMap) {
        ArrayList<DynamicObject> creditUses = new ArrayList<DynamicObject>(creditPairs.size());
        ArrayList<DynamicObject> creditLImits = new ArrayList<DynamicObject>(creditPairs.size());
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        ArrayList<Object[]> paramListUse = new ArrayList<Object[]>();
        for (Pair<DynamicObject, List<DynamicObject>> creditPair : creditPairs) {
            DynamicObject creditLimit = (DynamicObject)creditPair.getLeft();
            if (EmptyUtil.isEmpty((DynamicObject)creditLimit)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u989d\u5ea6\u5360\u7528\u5355\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u901a\u8fc7\u6388\u4fe1\u989d\u5ea6\u5355\u3010\u67e5\u770b\u4f7f\u7528\u60c5\u51b5\u3011\u68c0\u67e5", (String)"CreditLimitService_8", (String)"tmc-creditm-business", (Object[])new Object[0]));
            }
            List creditUseArr = (List)creditPair.getRight();
            boolean isPre = false;
            Set creditUseIds = creditUseArr.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            Long bizBillId = CreditLimitHelper.checkBillHasReturn(returnInfoMap, (Long)creditLimit.getLong("id"), creditUseIds);
            if (EmptyUtil.isNoEmpty((Long)bizBillId)) {
                logger.error("creditlimit\u5df2\u8fd4\u8fd8\u6210\u529f\uff0cbizbillid\uff1a{}", (Object)bizBillId);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8fd4\u8fd8ID:[%s]\u5df2\u7ecf\u8fd4\u8fd8\u6210\u529f, \u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4", (String)"CreditLimitService_5", (String)"tmc-creditm-business", (Object[])new Object[0]), String.valueOf(bizBillId)));
            }
            BigDecimal creditRate = (BigDecimal)((DynamicObject)creditUseArr.get(0)).get("creditrate");
            DynamicObject bizCurr = ((DynamicObject)creditUseArr.get(0)).getDynamicObject("bizcurrency");
            DynamicObject creditCurr = creditLimit.getDynamicObject("currency");
            Map<Long, BigDecimal> returnAmtMap = this.getReturnAmtMap(returnInfoMap, creditUseArr, creditCurr);
            if (EmptyUtil.isEmpty(returnAmtMap)) {
                logger.info("creditlimit\u8fd4\u8fd8\u91d1\u989d\u4e3a\u7a7a\uff0ccreditlimitid\uff1a{}", creditLimit.getPkValue());
                return;
            }
            boolean isCircle = CreditPropEnum.CIRCLE.getValue().equals(creditLimit.get("creditprop"));
            BigDecimal totalReturnAmt = BigDecimal.ZERO;
            for (DynamicObject useRec : creditUseArr) {
                if (useRec.getBoolean("isrelease")) continue;
                ReturnCreditLimitInfo param = returnInfoMap.get(useRec.getLong("sourcebillid"));
                isPre = param.isPreOccupy();
                BigDecimal returnAmt = returnAmtMap.get(useRec.getLong("sourcebillentryid"));
                if (EmptyUtil.isEmpty((BigDecimal)returnAmt)) {
                    logger.info("creditlimit\u8fd4\u8fd8\u91d1\u989d\u4e3a0\uff0c\u5360\u7528\u5355\u6e90\u5355ID\uff1a{}\uff0ccreditlimitid:{}", (Object)useRec.getLong("sourcebillentryid"));
                    continue;
                }
                BigDecimal realAmt = useRec.getBigDecimal("realamt");
                BigDecimal useAmt = returnAmt.min(realAmt);
                if (useAmt.compareTo(BigDecimal.ZERO) == 0) {
                    logger.info("useAmt\u4e3a0");
                    continue;
                }
                BigDecimal hasReturnAmt = useRec.getBigDecimal("returnamt");
                if (isCircle || isPre) {
                    paramListUse.add(new Object[]{hasReturnAmt, useRec.getLong("id"), hasReturnAmt, realAmt});
                }
                if ("cfm_credituse".equals(param.getPreEntityName())) {
                    useRec.set("isrelease", (Object)"1");
                }
                useRec.set("modifytime", (Object)DateUtils.getCurrentTime());
                useRec.set("modifier", (Object)RequestContext.get().getCurrUserId());
                Long bizId = EmptyUtil.isNoEmpty((Long)param.getBizBillId()) ? param.getBizBillId() : param.getReturnBillId();
                DynamicObjectCollection entrys = useRec.getDynamicObjectCollection("returnentry");
                List notCancelEntrys = entrys.stream().filter(o -> EmptyUtil.isEmpty((Long)o.getLong("e_returnid")) && o.getLong("e_bizbillid") == bizId.longValue()).collect(Collectors.toList());
                BigDecimal notCancelAmt = BigDecimal.ZERO;
                if (EmptyUtil.isNoEmpty(notCancelEntrys)) {
                    entrys.removeAll(notCancelEntrys);
                    notCancelAmt = notCancelEntrys.stream().map(o -> o.getBigDecimal("e_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                DynamicObject returnObj = entrys.addNew();
                Long returnId = EmptyUtil.isNoEmpty((Long)param.getReturnBillId()) ? param.getReturnBillId() : param.getBizBillId();
                returnObj.set("e_returnid", (Object)returnId);
                BigDecimal returnEntryAmt = useAmt.add(notCancelAmt);
                returnObj.set("e_bizbillid", (Object)bizId);
                returnObj.set("e_amount", (Object)returnEntryAmt);
                returnObj.set("e_bizamount", (Object)returnEntryAmt.divide(creditRate, CreditLimitHelper.getAmtPrecision((DynamicObject)bizCurr), RoundingMode.HALF_UP));
                returnObj.set("e_creator", (Object)RequestContext.get().getCurrUserId());
                returnObj.set("e_billtype", (Object)param.getPreEntityName());
                returnObj.set("e_returntime", (Object)(EmptyUtil.isEmpty((Object)param.getReturnTime()) ? DateUtils.getCurrentDate() : param.getReturnTime()));
                returnObj.set("e_bizreturnamt", (Object)param.getReturnAmt());
                returnObj.set("e_operatetime", (Object)DateUtils.getCurrentTime());
                logger.info("creditlimit\u66f4\u65b0\u8fd4\u8fd8\u5206\u5f55\u5b8c\u6210\uff0c bizId\uff1a{}, useAmt\uff1a{}", (Object)bizId, (Object)useAmt);
                totalReturnAmt = totalReturnAmt.add(useAmt);
                if (isCircle || isPre) {
                    BigDecimal returnAllAmt = entrys.parallelStream().map(o -> o.getBigDecimal("e_amount")).reduce(BigDecimal::add).get();
                    realAmt = useRec.getBigDecimal("amount").add(useRec.getBigDecimal("preamount").subtract(returnAllAmt));
                    useRec.set("returnamt", (Object)returnAllAmt);
                    useRec.set("realamt", (Object)realAmt);
                    useRec.set("creditratio", (Object)CreditlimitHelper.getCreditRatioBySuretyAppend(useRec, isPre, param.getPreEntityName()));
                    long orgId = useRec.getDynamicObject("org").getLong("id");
                    DynamicObject creditType = useRec.getDynamicObject("credittype");
                    long creditTypeId = creditType != null ? creditType.getLong("id") : 0L;
                    CreditLimitAmtHelper.dealOrgEntryAmt((DynamicObject)creditLimit, (Long)orgId, (boolean)isPre, (BigDecimal)useAmt.negate());
                    CreditLimitAmtHelper.dealTypeEntryAmt((DynamicObject)creditLimit, (Long)creditTypeId, (boolean)isPre, (BigDecimal)useAmt.negate());
                    CreditLimitAmtHelper.dealMultEntryAmt((DynamicObject)creditLimit, (Long)creditTypeId, (Long)orgId, (boolean)isPre, (BigDecimal)useAmt.negate());
                    logger.info("creditlimit\u66f4\u65b0\u989d\u5ea6\u5355\u5206\u5f55\u5b8c\u6210\uff0c bizId\uff1a{}, useAmt\uff1a{}", (Object)bizId, (Object)useAmt);
                }
                creditUses.add(useRec);
            }
            logger.info("creditlimit\u6388\u4fe1\u6027\u8d28\uff1a{}", (Object)isCircle);
            if (!isCircle && !isPre) continue;
            logger.info("creditlimit\u66f4\u65b0\u8fd4\u8fd8\u5206\u5f55\u5b8c\u6210\uff0c creditLimitid:{}\uff0ctotalReturnAmt\uff1a{}", creditLimit.getPkValue(), (Object)totalReturnAmt);
            BigDecimal oldAvaamt = creditLimit.getBigDecimal("avaramt");
            CreditLimitAmtHelper.dealHeadAmt((DynamicObject)creditLimit, (boolean)isPre, (BigDecimal)totalReturnAmt.negate());
            paramList.add(new Object[]{creditLimit.getBigDecimal("avaramt"), creditLimit.getLong("id"), oldAvaamt});
            String checkMsg = CreditLimitHelper.checkCreditLimitAmt((DynamicObject)creditLimit);
            if (EmptyUtil.isNoEmpty((String)checkMsg)) {
                logger.info("creditlimit\u66f4\u65b0\u5f02\u5e38\uff0ccreditlimitid:{}", creditLimit.getPkValue());
                throw new KDBizException(checkMsg);
            }
            creditLImits.add(creditLimit);
        }
        try (TXHandle tx = TX.required((String)"credit_return");){
            try {
                CreditLimitAmtHelper.batchUpdateHeadAmt(paramList, paramListUse);
                TmcDataServiceHelper.save((DynamicObject[])creditLImits.toArray(new DynamicObject[0]));
                TmcDataServiceHelper.save((DynamicObject[])creditUses.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        if (creditLImits.size() > 0) {
            ThreadPools.executeOnceIncludeRequestContext((String)"credit_return_check", () -> {
                String checkMsg = CreditLimitHelper.checkCreditUseTotal(creditLImits.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
                if (EmptyUtil.isNoEmpty((String)checkMsg)) {
                    logger.info("creditlimit_return\u989d\u5ea6\u660e\u7ec6\u6c47\u603b\u548c\u989d\u5ea6\u5355\u4e0d\u4e00\u81f4,msg:{}", (Object)checkMsg);
                    TmcOperateServiceHelper.execOperate((String)"credituseamtupdate", (String)"cfm_creditlimit", (Object[])creditLImits.stream().map(o -> o.getLong("id")).toArray(), (OperateOption)OperateOption.create());
                }
            });
        }
    }

    private Map<Long, BigDecimal> getReturnAmtMap(Map<Long, ReturnCreditLimitInfo> returnInfoMap, List<DynamicObject> creditUseArr, DynamicObject creditCurr) {
        HashMap<Long, BigDecimal> returnAmtMap = new HashMap<Long, BigDecimal>();
        for (Map.Entry<Long, ReturnCreditLimitInfo> infos : returnInfoMap.entrySet()) {
            BigDecimal creditRate;
            BigDecimal ratio;
            DynamicObject creditUse2;
            ReturnCreditLimitInfo param = infos.getValue();
            int amtPrecision = CreditLimitHelper.getAmtPrecision((DynamicObject)creditCurr);
            Map entryReturnAmtMap = param.getEntryReturnAmtMap();
            if (EmptyUtil.isNoEmpty((Object)entryReturnAmtMap)) {
                for (DynamicObject creditUse2 : creditUseArr) {
                    ratio = creditUse2.getBigDecimal("creditratio");
                    creditRate = (BigDecimal)creditUse2.get("creditrate");
                    long souceBillEntryId = creditUse2.getLong("sourcebillentryid");
                    BigDecimal amt = (BigDecimal)entryReturnAmtMap.get(souceBillEntryId);
                    if (EmptyUtil.isEmpty((BigDecimal)amt)) continue;
                    BigDecimal returnAmt = this.getReturnAmt(param, creditUse2, amt, ratio, creditRate, amtPrecision);
                    returnAmtMap.put(souceBillEntryId, returnAmt);
                }
                continue;
            }
            Set creditUses = creditUseArr.stream().filter(o -> EmptyUtil.isNoEmpty((Long)param.getId()) && param.getId().equals(o.getLong("sourcebillentryid"))).collect(Collectors.toSet());
            if (!EmptyUtil.isNoEmpty(creditUses) || creditUses.size() <= 0) continue;
            creditUse2 = (DynamicObject)creditUses.iterator().next();
            ratio = creditUse2.getBigDecimal("creditratio");
            creditRate = (BigDecimal)creditUse2.get("creditrate");
            BigDecimal returnAmt = this.getReturnAmt(param, creditUse2, param.getReturnAmt(), ratio, creditRate, amtPrecision);
            returnAmtMap.put(param.getId(), returnAmt);
        }
        return returnAmtMap;
    }

    private BigDecimal getReturnAmt(ReturnCreditLimitInfo param, DynamicObject creditUse, BigDecimal returnAmt, BigDecimal ratio, BigDecimal creditRate, int amtPrecision) {
        BigDecimal totalAmt;
        boolean isLast = param.isLast();
        if (isLast) {
            return this.getLastReturnAmount(creditUse);
        }
        ratio = EmptyUtil.isEmpty((BigDecimal)ratio) ? Constants.ONE_HUNDRED : ratio;
        BigDecimal bigDecimal = creditRate = EmptyUtil.isEmpty((BigDecimal)creditRate) ? Constants.ONE : creditRate;
        if (!"fbd_surety_append".equals(param.getEntityName()) && !"fbd_surety_append".equals(param.getPreEntityName())) {
            returnAmt = returnAmt.multiply(ratio).divide(Constants.ONE_HUNDRED).multiply(creditRate).setScale(amtPrecision, RoundingMode.HALF_UP);
        }
        if ((totalAmt = creditUse.getBigDecimal("realamt")).compareTo(BigDecimal.ZERO) == 0) {
            returnAmt = BigDecimal.ZERO;
        } else if (returnAmt != null && returnAmt.compareTo(totalAmt) > 0) {
            returnAmt = totalAmt;
        }
        return returnAmt;
    }

    private BigDecimal getLastReturnAmount(DynamicObject creditUse) {
        BigDecimal totalAmt = creditUse.getBigDecimal("realamt");
        DynamicObject limit = creditUse.getDynamicObject("creditlimit");
        if (EmptyUtil.isEmpty((DynamicObject)limit) || CreditPropEnum.isCircle((String)limit.getString("creditprop"))) {
            return totalAmt;
        }
        DynamicObjectCollection returnEntrys = creditUse.getDynamicObjectCollection("returnentry");
        BigDecimal hasReturnAmount = returnEntrys.stream().map(o -> o.getBigDecimal("e_amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal returnAmount = totalAmt.subtract(hasReturnAmount);
        return returnAmount.compareTo(BigDecimal.ZERO) > 0 ? returnAmount : BigDecimal.ZERO;
    }

    private void cancelReturnAmtByCreditUse(List<Pair<DynamicObject, List<DynamicObject>>> creditPairs, Map<Long, ReturnCreditLimitInfo> returnInfoMap) {
        ArrayList<DynamicObject> creditUses = new ArrayList<DynamicObject>(creditPairs.size());
        ArrayList<DynamicObject> creditLImits = new ArrayList<DynamicObject>(creditPairs.size());
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        ArrayList<Object[]> paramListUse = new ArrayList<Object[]>();
        for (Pair<DynamicObject, List<DynamicObject>> creditPair : creditPairs) {
            DynamicObject creditLimit = (DynamicObject)creditPair.getLeft();
            List creditUseList = (List)creditPair.getRight();
            Object creditProp = creditLimit.get("creditprop");
            boolean isCircle = CreditPropEnum.CIRCLE.getValue().equals(creditProp);
            BigDecimal totalReturnAmt = BigDecimal.ZERO;
            boolean isPre = false;
            for (DynamicObject useRec : creditUseList) {
                long sourceBillId = useRec.getLong("sourcebillid");
                ReturnCreditLimitInfo param = returnInfoMap.get(sourceBillId);
                Long returnId = EmptyUtil.isEmpty((Long)param.getReturnBillId()) ? param.getBizBillId() : param.getReturnBillId();
                Long bizId = EmptyUtil.isEmpty((Long)param.getBizBillId()) ? param.getReturnBillId() : param.getBizBillId();
                isPre = param.isPreOccupy();
                DynamicObjectCollection returnEntrys = useRec.getDynamicObjectCollection("returnentry");
                List returnObjs = returnEntrys.stream().filter(o -> o.getLong("e_returnid") == returnId.longValue() && o.getLong("e_bizbillid") == bizId.longValue()).collect(Collectors.toList());
                if (EmptyUtil.isEmpty(returnObjs)) {
                    logger.info("\u4e0d\u5b58\u5728\u8fd4\u8fd8\u6570\u636e\uff0creturnid={}, billbizid={}", (Object)returnId, (Object)bizId);
                    continue;
                }
                DynamicObject returnObj = (DynamicObject)returnObjs.get(0);
                if (EmptyUtil.isEmpty((String)param.getPreEntityName())) {
                    param.setPreEntityName(returnObj.getString("e_billtype"));
                }
                returnEntrys.remove((Object)returnObj);
                BigDecimal returnAmt = returnObj.getBigDecimal("e_amount");
                BigDecimal realAmtOld = useRec.getBigDecimal("realamt");
                BigDecimal hasReturnAmt = useRec.getBigDecimal("returnamt");
                if (isCircle || isPre) {
                    long orgId = useRec.getDynamicObject("org").getLong("id");
                    DynamicObject creditType = useRec.getDynamicObject("credittype");
                    long creditTypeId = creditType != null ? creditType.getLong("id") : 0L;
                    useRec.set("returnamt", (Object)hasReturnAmt.add(returnAmt.negate()));
                    BigDecimal realAmt = useRec.getBigDecimal("amount").add(useRec.getBigDecimal("preamount").subtract(useRec.getBigDecimal("returnamt")));
                    useRec.set("realamt", (Object)realAmt);
                    useRec.set("creditratio", (Object)CreditlimitHelper.getCreditRatioBySuretyAppend(useRec, isPre, param.getPreEntityName()));
                    paramListUse.add(new Object[]{hasReturnAmt, useRec.getLong("id"), hasReturnAmt, realAmtOld});
                    logger.info("creditlimit\u989d\u5ea6\u5355\u66f4\u65b0\u5206\u5f55\uff0creturnId:{}, \u8fd4\u8fd8\u989d\u5ea6\uff1a{}", (Object)returnId, (Object)returnAmt);
                    CreditLimitAmtHelper.dealOrgEntryAmt((DynamicObject)creditLimit, (Long)orgId, (boolean)isPre, (BigDecimal)returnAmt);
                    CreditLimitAmtHelper.dealTypeEntryAmt((DynamicObject)creditLimit, (Long)creditTypeId, (boolean)isPre, (BigDecimal)returnAmt);
                    CreditLimitAmtHelper.dealMultEntryAmt((DynamicObject)creditLimit, (Long)creditTypeId, (Long)orgId, (boolean)isPre, (BigDecimal)returnAmt);
                }
                totalReturnAmt = totalReturnAmt.add(returnAmt);
                creditUses.add(useRec);
            }
            logger.info("creditlimit\u989d\u5ea6\u5355\u6027\u8d28\uff1a{}", (Object)isCircle);
            if (!isCircle && !isPre) continue;
            logger.info("creditlimit\u66f4\u65b0\u989d\u5ea6\u5355\u5355\u5934\u91d1\u989d\uff1aid:{}\uff0ctotalReturnAmt\uff1a{}", creditLimit.getPkValue(), (Object)totalReturnAmt);
            BigDecimal oldAvaamt = creditLimit.getBigDecimal("avaramt");
            CreditLimitAmtHelper.dealHeadAmt((DynamicObject)creditLimit, (boolean)isPre, (BigDecimal)totalReturnAmt);
            paramList.add(new Object[]{creditLimit.getBigDecimal("avaramt"), creditLimit.getLong("id"), oldAvaamt});
            String checkMsg = CreditLimitHelper.checkCreditLimitAmt((DynamicObject)creditLimit);
            if (EmptyUtil.isNoEmpty((String)checkMsg)) {
                logger.info("creditlimit\u989d\u5ea6\u5355\u66f4\u65b0\u5f02\u5e38\uff1aid:{}, error:{}", creditLimit.getPkValue(), (Object)checkMsg);
                throw new KDBizException(checkMsg);
            }
            creditLImits.add(creditLimit);
        }
        try (TXHandle tx = TX.required((String)"credit_cancel_return");){
            try {
                CreditLimitAmtHelper.batchUpdateHeadAmt(paramList, paramListUse);
                TmcDataServiceHelper.save((DynamicObject[])creditLImits.toArray(new DynamicObject[0]));
                TmcDataServiceHelper.save((DynamicObject[])creditUses.toArray(new DynamicObject[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        if (creditLImits.size() > 0) {
            ThreadPools.executeOnceIncludeRequestContext((String)"credit_cancel_return_check", () -> {
                String checkMsg = CreditLimitHelper.checkCreditUseTotal(creditLImits.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
                if (EmptyUtil.isNoEmpty((String)checkMsg)) {
                    logger.info("creditlimit_cancelreturn\u989d\u5ea6\u660e\u7ec6\u6c47\u603b\u548c\u989d\u5ea6\u5355\u4e0d\u4e00\u81f4, msg:{}", (Object)checkMsg);
                    TmcOperateServiceHelper.execOperate((String)"credituseamtupdate", (String)"cfm_creditlimit", (Object[])creditLImits.stream().map(o -> o.getLong("id")).toArray(), (OperateOption)OperateOption.create());
                }
            });
        }
        logger.info("creditlimit\u5360\u7528\u5355\u3001\u989d\u5ea6\u5355\u66f4\u65b0\u6210\u529f");
    }

    private void confirmCreditLimit(String entityName, Long pkId, String billno, boolean isPreOccupy, boolean isCancel, Date createTime) {
        QFilter[] filters = this.getCreditUseFilter(entityName, pkId, isCancel ? BillStatusEnum.AUDIT.getValue() : BillStatusEnum.SAVE.getValue());
        this.handleCreditLimit(filters, creditPairs -> {
            ArrayList<DynamicObject> creditUses = new ArrayList<DynamicObject>(creditPairs.size());
            ArrayList<DynamicObject> creditLimits = new ArrayList<DynamicObject>(creditPairs.size());
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(creditPairs.size());
            for (Pair creditPair : creditPairs) {
                DynamicObject creditLimit = (DynamicObject)creditPair.getLeft();
                List creditLimitUses = (List)creditPair.getRight();
                logger.info("creditlimit\u989d\u5ea6\u5360\u7528\u5355\u6570\uff1a{}", (Object)creditLimitUses.size());
                if (creditLimit.getBoolean("isclose") && !isCancel) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6388\u4fe1\u989d\u5ea6\u5355[%s]\u5df2\u5173\u95ed, \u8bf7\u91cd\u65b0\u9009\u62e9", (String)"CreditLimitService_12", (String)"tmc-creditm-business", (Object[])new Object[]{creditLimit.getString("number")}));
                }
                Long orgId = null;
                if (creditLimitUses.size() > 0) {
                    orgId = ((DynamicObject)creditLimitUses.get(0)).getDynamicObject("org").getLong("id");
                }
                Map preAmountMap = CreditLimitHelper.getPreAmountByBill(orgId, (Long)pkId, (String)entityName);
                BigDecimal totalAmt = BigDecimal.ZERO;
                for (DynamicObject useRecord : creditLimitUses) {
                    long creditTypeId;
                    if (!isCancel && useRecord.getBoolean("isrelease")) continue;
                    DynamicObjectCollection returnEntrys = useRecord.getDynamicObjectCollection("returnentry");
                    BigDecimal hasReturnAmt = returnEntrys.parallelStream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getLong("e_returnid")) && !"cfm_credituse".equals(o.getString("e_billtype"))).map(o -> o.getBigDecimal("e_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (isCancel && hasReturnAmt.compareTo(BigDecimal.ZERO) > 0) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u5360\u7528\u989d\u5ea6\u5df2\u53d1\u751f\u8fd4\u8fd8\uff0c\u4e0d\u80fd\u53d6\u6d88\u5360\u7528\u3002", (String)"CreditLimitService_13", (String)"tmc-creditm-business", (Object[])new Object[0]), creditLimit.getString("number")));
                    }
                    useRecord.set("billstatus", (Object)(isCancel ? BillStatusEnum.SAVE.getValue() : BillStatusEnum.AUDIT.getValue()));
                    useRecord.set("operatetime", (Object)(isCancel ? null : DateUtils.getCurrentTime()));
                    DynamicObject creditType = useRecord.getDynamicObject("credittype");
                    DynamicObject org = useRecord.getDynamicObject("org");
                    BigDecimal useAmt = useRecord.getBigDecimal(isPreOccupy ? "preamount" : "amount");
                    useRecord.set("realamt", (Object)useRecord.getBigDecimal("amount").add(useRecord.getBigDecimal("preamount")));
                    useRecord.set("returnamt", (Object)BigDecimal.ZERO);
                    BigDecimal notCancelReturnAmt = returnEntrys.parallelStream().filter(o -> EmptyUtil.isEmpty((Long)o.getLong("e_returnid"))).map(o -> o.getBigDecimal("e_amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    returnEntrys.clear();
                    if (useAmt.compareTo(BigDecimal.ZERO) <= 0) {
                        useRecord.set(isPreOccupy ? "preamount" : "amount", (Object)useRecord.getBigDecimal("realamt"));
                        useRecord.set(isPreOccupy ? "amount" : "preamount", (Object)BigDecimal.ZERO);
                    }
                    if ((useAmt = useRecord.getBigDecimal("realamt").subtract(notCancelReturnAmt)).compareTo(BigDecimal.ZERO) <= 0) {
                        useAmt = useRecord.getBigDecimal(isPreOccupy ? "amount" : "preamount");
                        useRecord.set(isPreOccupy ? "preamount" : "amount", (Object)useAmt);
                        useRecord.set(isPreOccupy ? "amount" : "preamount", (Object)BigDecimal.ZERO);
                    }
                    long l = creditTypeId = creditType != null ? creditType.getLong("id") : 0L;
                    if (!isCancel) {
                        BigDecimal creditLimitAvarAmt = CreditLimitHelper.getCreditLimitAvarAmt((DynamicObject)creditLimit, (Long)creditTypeId, (Long)org.getLong("id"), (Map)preAmountMap);
                        if (creditLimitAvarAmt.compareTo(useAmt) < 0) {
                            int amtPrecision = CreditLimitHelper.getAmtPrecision((DynamicObject)creditLimit.getDynamicObject("currency"));
                            throw new KDBizException(CreditmBusResourceEnum.CreditLimitService_13.loadKDString(billno, creditLimit.getString("number"), creditLimitAvarAmt.setScale(amtPrecision)));
                        }
                        boolean isExistBillCredituse = CreditlimitHelper.isExistBillCredituse(creditLimit.getLong("id"), useRecord.getLong("sourcebillid"), useRecord.getLong("sourcebillentryid"), BillStatusEnum.AUDIT.getValue());
                        if (isExistBillCredituse) {
                            logger.info("billid:{},entryid:{}", (Object)useRecord.getLong("sourcebillid"), (Object)useRecord.getLong("sourcebillentryid"));
                            throw new KDBizException(CreditmBusResourceEnum.CreditLimitService_21.loadKDString(billno));
                        }
                    }
                    BigDecimal bigDecimal = useAmt = isCancel ? useAmt.negate() : useAmt;
                    if (useRecord.getBoolean("isrelease")) {
                        useAmt = BigDecimal.ZERO;
                    }
                    CreditLimitAmtHelper.dealOrgEntryAmt((DynamicObject)creditLimit, (Long)org.getLong("id"), (boolean)isPreOccupy, (BigDecimal)useAmt);
                    CreditLimitAmtHelper.dealTypeEntryAmt((DynamicObject)creditLimit, (Long)creditTypeId, (boolean)isPreOccupy, (BigDecimal)useAmt);
                    CreditLimitAmtHelper.dealMultEntryAmt((DynamicObject)creditLimit, (Long)creditTypeId, (Long)org.getLong("id"), (boolean)isPreOccupy, (BigDecimal)useAmt);
                    useRecord.set("sourcebillno", (Object)billno);
                    useRecord.set("billno", (Object)billno);
                    logger.info("creditlimit\u66f4\u65b0\u989d\u5ea6\u5360\u7528\u5206\u5f55\uff0cbillno\uff1a{}, creditlimitid:{}", (Object)billno, creditLimit.getPkValue());
                    if (!isCancel) {
                        useRecord.set("createtime", (Object)(EmptyUtil.isEmpty((Object)createTime) ? DateUtils.getCurrentDate() : createTime));
                    }
                    if (isCancel) {
                        useRecord.set("isrelease", (Object)false);
                    }
                    creditUses.add(useRecord);
                    totalAmt = totalAmt.add(useAmt);
                }
                if (EmptyUtil.isEmpty((BigDecimal)totalAmt)) continue;
                BigDecimal oldAvaamt = creditLimit.getBigDecimal("avaramt");
                CreditLimitAmtHelper.dealHeadAmt((DynamicObject)creditLimit, (boolean)isPreOccupy, (BigDecimal)totalAmt);
                paramList.add(new Object[]{creditLimit.getBigDecimal("avaramt"), creditLimit.getLong("id"), oldAvaamt});
                logger.info("creditlimit\u66f4\u65b0\u5360\u7528\u603b\u989d\u5ea6\uff1a{}\uff0ccreditlimitid:{}", (Object)totalAmt, creditLimit.getPkValue());
                String checkMsg = CreditLimitHelper.checkCreditLimitAmt((DynamicObject)creditLimit);
                if (EmptyUtil.isNoEmpty((String)checkMsg)) {
                    logger.error("creditlimit\u989d\u5ea6\u66f4\u65b0\u5f02\u5e38\uff1a{}", (Object)checkMsg);
                    throw new KDBizException(checkMsg);
                }
                creditLimits.add(creditLimit);
            }
            try (TXHandle tx = TX.required((String)"credit_confirm");){
                try {
                    CreditLimitAmtHelper.batchUpdateHeadAmt(paramList, null);
                    TmcDataServiceHelper.save((DynamicObject[])creditLimits.toArray(new DynamicObject[0]));
                    TmcDataServiceHelper.save((DynamicObject[])creditUses.toArray(new DynamicObject[0]));
                    if (!isCancel) {
                        QFilter sourceIdFilter = CreditLimitHelper.getFilter((String)entityName, (Long)pkId).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()));
                        DeleteServiceHelper.delete((String)"cfm_credituse", (QFilter[])new QFilter[]{sourceIdFilter});
                    }
                    if (isCancel) {
                        CreditLimitHelper.delOldCreditUse(creditUses);
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
            if (creditLimits.size() > 0) {
                ThreadPools.executeOnceIncludeRequestContext((String)"credit_confirm_check", () -> {
                    String checkMsg = CreditLimitHelper.checkCreditUseTotal(creditLimits.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
                    if (EmptyUtil.isNoEmpty((String)checkMsg)) {
                        logger.info("creditlimit\u989d\u5ea6\u660e\u7ec6\u6c47\u603b\u548c\u989d\u5ea6\u5355\u4e0d\u4e00\u81f4\uff0cmsg:{}", (Object)checkMsg);
                        TmcOperateServiceHelper.execOperate((String)"credituseamtupdate", (String)"cfm_creditlimit", (Object[])creditLimits.stream().map(o -> o.getLong("id")).toArray(), (OperateOption)OperateOption.create());
                    }
                });
            }
        });
    }

    public void deleteCreditLimitUse(Map<Long, Object> map) {
        if (map == null || map.size() == 0) {
            return;
        }
        for (Map.Entry<Long, Object> entry : map.entrySet()) {
            Long billId = Long.parseLong(String.valueOf(entry.getKey()));
            Object entryIds = entry.getValue();
            QFilter filter = new QFilter("sourcebillid", "=", (Object)billId).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()));
            if (EmptyUtil.isNoEmpty((Object)entryIds)) {
                filter.and(new QFilter("sourcebillentryid", "not in", entryIds));
            } else {
                filter.and(new QFilter("sourcebillentryid", "!=", (Object)billId));
            }
            DeleteServiceHelper.delete((String)"cfm_credituse", (QFilter[])new QFilter[]{filter});
        }
    }

    private void handleCreditLimit(QFilter[] filters, CreditLimitOperation operation) {
        DynamicObject[] creditUseArr = TmcDataServiceHelper.load((String)"cfm_credituse", (String)String.join((CharSequence)",", "id", "creditlimit", "credittype", "billno", "avaramt", "sourcebillid", "sourcebillentryid", "sourcebillno", "sourcetype", "sourcename", "billstatus", "createtime", "amount", "preamount", "currency", "bizcurrency", "realamt", "org", "creditrate", "creditratio", "bizcreditamount", "returnentry.e_amount", "returnentry.e_bizamount", "returnentry.e_creator", "returnentry.e_returnid", "returnentry.e_bizbillid", "returnentry.e_billtype", "returnentry.e_returntime", "returnentry.e_operatetime", "returnentry.e_bizreturnamt", "returnamt", "iscopy", "totalamt", "totalamt", "modifytime", "modifier", "isrelease", "bizamount", "operatetime"), (QFilter[])filters);
        if (creditUseArr.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u672a\u5173\u8054\u989d\u5ea6\u5360\u7528\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6388\u4fe1\u989d\u5ea6\u5355\u3002", (String)"CreditLimitService_14", (String)"tmc-creditm-business", (Object[])new Object[0]));
        }
        HashMap<String, Pair> creditPairMap = new HashMap<String, Pair>(creditUseArr.length);
        HashMap<String, String> creditIdsMap = new HashMap<String, String>(creditUseArr.length);
        for (DynamicObject creditUse : creditUseArr) {
            DynamicObject useCreditLimit = creditUse.getDynamicObject("creditlimit");
            DynamicObject creditLimit = null;
            creditLimit = creditPairMap.containsKey(useCreditLimit.getString("id")) ? (DynamicObject)((Pair)creditPairMap.get(useCreditLimit.getString("id"))).getLeft() : this.getRealCreditLimitById(useCreditLimit.getPkValue());
            if (creditLimit == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6388\u4fe1\u989d\u5ea6\u5355", (String)"CreditLimitService_15", (String)"tmc-creditm-business", (Object[])new Object[0]));
            }
            if (!BillStatusEnum.AUDIT.getValue().equals(creditLimit.get("status"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355[%s]\u975e\u5df2\u5ba1\u6838\u72b6\u6001", (String)"CreditLimitService_18", (String)"tmc-creditm-business", (Object[])new Object[0]), creditLimit.getString("number")));
            }
            boolean ismergeNew = creditLimit.getBoolean("ismergenew");
            if (ismergeNew && useCreditLimit.getLong("id") != creditLimit.getLong("id")) continue;
            if (creditPairMap.containsKey(creditLimit.getString("id"))) {
                ((List)((Pair)creditPairMap.get(creditLimit.getString("id"))).getRight()).add(creditUse);
            } else {
                ArrayList<DynamicObject> creditUseList = new ArrayList<DynamicObject>();
                creditUseList.add(creditUse);
                creditPairMap.put(creditLimit.getString("id"), Pair.of((Object)creditLimit, creditUseList));
            }
            creditIdsMap.put(creditLimit.getString("id"), creditLimit.getString("number"));
        }
        List ids = creditIdsMap.keySet().stream().collect(Collectors.toList());
        Map LimitMap = MutexServiceHelper.batchRequest(ids, (String)"cfm_creditlimit", (String)"creditLimit");
        try {
            for (Map.Entry credit : creditIdsMap.entrySet()) {
                if (LimitMap.containsKey(credit.getKey()) && ((Boolean)LimitMap.get(credit.getKey())).booleanValue()) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355%s\u6b63\u5728\u88ab\u66f4\u65b0, \u8bf7\u7a0d\u540e\u91cd\u8bd5", (String)"CreditLimitService_16", (String)"tmc-creditm-business", (Object[])new Object[0]), credit.getValue()));
            }
            List creditPair = creditPairMap.values().stream().collect(Collectors.toList());
            if ((creditPair = CreditLimitHelper.checkRepeatCreditUses(creditPair)).size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u672a\u5173\u8054\u989d\u5ea6\u5360\u7528\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6388\u4fe1\u989d\u5ea6\u5355\u3002", (String)"CreditLimitService_14", (String)"tmc-creditm-business", (Object[])new Object[0]));
            }
            operation.doOperation(creditPair);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            List limitIds = LimitMap.entrySet().stream().filter(o -> (Boolean)o.getValue()).map(o -> (String)o.getKey()).collect(Collectors.toList());
            MutexServiceHelper.batchRelease(limitIds, (String)"cfm_creditlimit", (String)"creditLimit");
        }
    }

    public CreditLimitUseBean updateCreditLimitUse(CreditLimitUseBean useBean) {
        QFilter[] filters = this.getCreditUseFilter(useBean.getEntityName(), useBean.getPkId(), BillStatusEnum.AUDIT.getValue());
        this.handleCreditLimit(filters, creditPairs -> {
            for (Pair creditPair : creditPairs) {
                DynamicObject creditLimit = (DynamicObject)creditPair.getLeft();
                List creditLimitUses = (List)creditPair.getRight();
                BigDecimal rate = ((DynamicObject)creditLimitUses.get(0)).getBigDecimal("creditrate");
                BigDecimal newAmount = useBean.getBizAmt();
                BigDecimal useAmt = newAmount.multiply(((DynamicObject)creditLimitUses.get(0)).getBigDecimal("creditratio")).multiply(rate).divide(Constants.ONE_HUNDRED, 12, RoundingMode.HALF_UP);
                BigDecimal allReturnAmt = creditLimitUses.stream().map(o -> o.getBigDecimal("returnamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal alluseAmt = creditLimitUses.stream().map(o -> o.getBigDecimal(useBean.getPreOccupy() != false ? "preamount" : "amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                if (useAmt.compareTo(alluseAmt) == 0) {
                    return;
                }
                if (allReturnAmt.compareTo(useAmt) > 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u5360\u7528\u91d1\u989d[%1$s]\u5c0f\u4e8e\u6388\u4fe1\u5df2\u8fd4\u8fd8\u91d1\u989d[%2$s]\uff0c\u4fee\u6539\u5360\u7528\u989d\u5ea6\u5931\u8d25", (String)"CreditLimitService_20", (String)"tmc-creditm-business", (Object[])new Object[0]), useAmt, allReturnAmt));
                }
                boolean isAdd = useAmt.compareTo(alluseAmt) > 0;
                String amField = useBean.getPreOccupy() != false ? "preamount" : "amount";
                boolean updateCreditLimit = false;
                ArrayList<DynamicObject> newUpdateCreditUse = new ArrayList<DynamicObject>();
                for (DynamicObject creditUse : creditLimitUses) {
                    BigDecimal creditUseAmt = BigDecimal.ZERO;
                    if (useAmt.compareTo(BigDecimal.ZERO) == 0) break;
                    BigDecimal returnAmt = creditUse.getBigDecimal("returnamt");
                    creditUse.set("bizcreditamount", (Object)newAmount);
                    if (isAdd) {
                        useAmt = useAmt.subtract(alluseAmt);
                        DynamicObject creditType = creditUse.getDynamicObject("credittype");
                        BigDecimal creditLimitTypeAmt = CreditLimitHelper.getCreditLimitAvarAmt((DynamicObject)creditLimit, (Long)(creditType != null ? creditType.getLong("id") : 0L), (Long)creditUse.getDynamicObject("org").getLong("id"), null);
                        if (creditLimitTypeAmt.compareTo(BigDecimal.ZERO) == 0) {
                            logger.info("\u53ef\u6539\u5927\u989d\u5ea6\u4e3a0");
                            continue;
                        }
                        if (creditLimitTypeAmt.compareTo(useAmt) >= 0) {
                            creditUse.set(amField, (Object)creditUse.getBigDecimal(amField).add(useAmt));
                            creditUseAmt = useAmt;
                        } else {
                            creditUse.set(amField, (Object)creditUse.getBigDecimal(amField).add(creditLimitTypeAmt));
                            BigDecimal ratio = creditUse.getBigDecimal(amField).multiply(Constants.ONE_HUNDRED).divide(newAmount.multiply(rate), 8, RoundingMode.DOWN);
                            creditUse.set("creditratio", (Object)ratio);
                            creditUse.set(amField, (Object)newAmount.multiply(rate).multiply(ratio.divide(Constants.ONE_HUNDRED, 6, RoundingMode.DOWN)));
                            creditUseAmt = creditLimitTypeAmt;
                            useBean.setCreditRatio(ratio);
                        }
                    } else {
                        useAmt = alluseAmt.subtract(useAmt);
                        BigDecimal minAmount = creditUse.getBigDecimal(amField).subtract(returnAmt);
                        if (minAmount.compareTo(BigDecimal.ZERO) == 0) {
                            logger.info("\u5360\u7528\u5355\u5df2\u5168\u90e8\u8fd4\u8fd8");
                            continue;
                        }
                        if (minAmount.compareTo(useAmt) > 0) {
                            creditUse.set(amField, (Object)creditUse.getBigDecimal(amField).add(useAmt.negate()));
                            creditUseAmt = useAmt.negate();
                        } else {
                            creditUse.set(amField, (Object)minAmount);
                            BigDecimal ratio = creditUse.getBigDecimal(amField).multiply(Constants.ONE_HUNDRED).divide(newAmount.multiply(rate), 8, RoundingMode.DOWN);
                            creditUse.set("creditratio", (Object)ratio);
                            creditUse.set(amField, (Object)newAmount.multiply(rate).multiply(ratio.divide(Constants.ONE_HUNDRED, 6, RoundingMode.DOWN)));
                            creditUseAmt = minAmount.negate();
                            useBean.setCreditRatio(ratio);
                        }
                    }
                    creditUse.set("realamt", (Object)creditUse.getBigDecimal("amount").add(creditUse.getBigDecimal("preamount")).subtract(creditUse.getBigDecimal("returnamt")));
                    newUpdateCreditUse.add(creditUse);
                    if (BigDecimal.ZERO.compareTo(creditUseAmt) == 0) continue;
                    updateCreditLimit = true;
                    CreditLimitHelper.handleCreditLimtByType((DynamicObject)creditLimit, (DynamicObject)creditUse, (BigDecimal)creditUseAmt, (boolean)useBean.getPreOccupy());
                }
                if (updateCreditLimit) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{creditLimit});
                }
                if (newUpdateCreditUse.size() <= 0) continue;
                SaveServiceHelper.save((DynamicObject[])newUpdateCreditUse.toArray(new DynamicObject[0]));
            }
        });
        return useBean;
    }

    private QFilter[] getCreditUseFilter(final String entityName, final Long pkId, String billStatus) {
        return this.getBatchCreditUseFilter(new HashSet(){
            {
                this.add(entityName);
            }
        }, new HashSet(){
            {
                this.add(pkId);
            }
        }, billStatus);
    }

    private QFilter[] getBatchCreditUseFilter(Set<String> entityNames, Set<Long> pkIds, String billStatus) {
        QFilter sourceTypeFilter = new QFilter("sourcetype", "in", entityNames);
        QFilter sourceIdFilter = new QFilter("sourcebillid", "in", pkIds);
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)billStatus);
        return new QFilter[]{sourceTypeFilter, sourceIdFilter, billStatusFilter};
    }

    private DynamicObject getCreditLimit(Object creditLimitId) {
        DynamicObject creditLimit = TmcDataServiceHelper.loadSingle((Object)creditLimitId, (String)"cfm_creditlimit");
        return creditLimit;
    }

    private DynamicObject getRealCreditLimitById(Object creditLimitId) {
        DynamicObject creditLimit = this.getCreditLimit(creditLimitId);
        return this.getRealCreditLimit(creditLimit);
    }

    private DynamicObject getRealCreditLimit(DynamicObject creditLimit) {
        if (creditLimit.getBoolean("ismergesrc")) {
            DynamicObject targetCredit = CreditLimitHelper.getMergeTargetCredit((DynamicObject)creditLimit);
            return this.getRealCreditLimit(targetCredit);
        }
        return creditLimit;
    }

    private static void updateCreditVariety(Long creditTypeId, CreditVarietyOperation operation) {
        String opKey = "save";
        DynamicObject creditType = TmcDataServiceHelper.loadSingle((Object)creditTypeId, (String)"cfm_credittype");
        boolean isGetLock = MutexServiceHelper.request((String)creditTypeId.toString(), (String)"cfm_credittype", (String)"save");
        if (!isGetLock) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u6388\u4fe1\u7c7b\u522b\u5931\u8d25, \u6388\u4fe1\u7c7b\u522b%2$s\u6b63\u5728\u88ab\u66f4\u65b0, \u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"CreditLimitService_17", (String)"tmc-creditm-business", (Object[])new Object[0]), "save", creditType.getString("number")));
        }
        try {
            operation.doOperation(creditType);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (isGetLock) {
                MutexServiceHelper.release((String)creditTypeId.toString(), (String)"cfm_credittype", (String)"save");
            }
        }
    }

    static interface CreditVarietyOperation {
        public boolean doOperation(DynamicObject var1);
    }

    static interface CreditLimitOperation {
        public void doOperation(List<Pair<DynamicObject, List<DynamicObject>>> var1);
    }
}

