/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.service.usecredit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.creditm.business.helper.CreditlimitHelper;
import kd.tmc.creditm.business.service.creditlimit.CreditLimitService;
import kd.tmc.creditm.common.enums.UseCreditChangeTypeEnum;
import kd.tmc.creditm.common.helper.CreditFrameworkHelper;
import kd.tmc.creditm.common.helper.UseCreditHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UseCreditAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("creditamount");
        sel.add("creditrate");
        sel.add("discreditamount");
        sel.add("releaseamount");
        sel.add("rootid");
        sel.add("bindid");
        sel.add("bizdate");
        sel.add("currency");
        sel.add("changetype");
        sel.add("bizbilltype");
        sel.add("businesscode");
        sel.add("contractno");
        sel.add("org");
        sel.add("finorginfo");
        sel.add("businessamount");
        sel.add("credittype");
        sel.add("creditproduct");
        sel.add("expiredate");
        sel.add("startdate");
        sel.add("bizbillid");
        sel.add("banktype");
        return sel;
    }

    public void process(DynamicObject[] entitys) throws KDException {
        ArrayList<CreditLimitInfo> infos = new ArrayList<CreditLimitInfo>(entitys.length);
        for (DynamicObject entity : entitys) {
            BigDecimal currentRelease = entity.getBigDecimal("releaseamount");
            String changeType = entity.getString("changetype");
            DynamicObject useCredit = null;
            if (Objects.equals(changeType, UseCreditChangeTypeEnum.RELEASE.getValue())) {
                useCredit = this.updateReleaseAmount(currentRelease, entity.getString("rootid"));
            }
            this.releaseCreditLimit(entity, useCredit);
            CreditLimitInfo bean = this.creditLimit(entity);
            Set billIds = infos.stream().map(o -> o.getId()).collect(Collectors.toSet());
            if (bean != null && !billIds.contains(bean.getId())) {
                infos.add(bean);
            }
            this.updateCreditFrameWork(entity);
            this.updateBizBillCredit(entity);
        }
        for (CreditLimitInfo info : infos) {
            CreditLimitService creditLimitService = new CreditLimitService();
            creditLimitService.confirmCreditLimit(info);
        }
    }

    private void updateCreditFrameWork(DynamicObject data) {
        String bizType = data.getString("bizbilltype");
        if (!"cfm_creditlimit".equals(bizType)) {
            return;
        }
        String bindId = data.getString("bindid");
        DynamicObject frameWork = data.getDynamicObject("contractno");
        DynamicObject creditLimit = QueryServiceHelper.queryOne((String)"cfm_creditlimit", (String)"id,org,credittype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(bindId))});
        CreditFrameworkHelper.creditWriteBackFrame((Long)frameWork.getLong("id"), (Long)creditLimit.getLong("org"), (Long)creditLimit.getLong("credittype"), (BigDecimal)data.getBigDecimal("creditamount"));
    }

    private void updateBizBillCredit(DynamicObject data) {
        String entityNumber;
        DynamicObject bizBill;
        String bizType = data.getString("bizbilltype");
        if ("other".equals(bizType)) {
            return;
        }
        DynamicObject useConfig = UseCreditHelper.getUseConfig((String)bizType);
        String creditProp = "creditlimit";
        if (EmptyUtil.isNoEmpty((DynamicObject)useConfig)) {
            creditProp = useConfig.getString("creditprop");
        }
        long bizBillId = data.getLong("bindid");
        QFilter filter = new QFilter("id", "=", (Object)bizBillId);
        String creditEntry = useConfig.getString("creditentry");
        if (EmptyUtil.isNoEmpty((String)creditEntry) && EmptyUtil.isNoEmpty((Long)data.getLong("bizentryid"))) {
            filter.and(creditEntry, "=", (Object)data.getLong("bizentryid"));
        }
        if (EmptyUtil.isEmpty((DynamicObject)(bizBill = TmcDataServiceHelper.loadSingle((String)(entityNumber = useConfig.getDynamicObject("biztype").getString("number")), (String)(creditProp + ",modifytime,modifier"), (QFilter[])new QFilter[]{filter})))) {
            return;
        }
        if (EmptyUtil.isNoEmpty((String)creditEntry)) {
            DynamicObjectCollection entrys = bizBill.getDynamicObjectCollection(creditEntry);
            DynamicObject entry = entrys.stream().filter(o -> data.getLong("bizentryid") == o.getLong("id")).findFirst().orElse(null);
            if (entry != null) {
                creditProp = creditProp.replace(creditEntry, "").replace(".", "");
                entry.set(creditProp, data.get("contractno"));
            }
        } else {
            bizBill.set(creditProp, data.get("contractno"));
        }
        bizBill.set("modifytime", (Object)DateUtils.getCurrentTime());
        bizBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
        SaveServiceHelper.update((DynamicObject)bizBill);
    }

    private CreditLimitInfo creditLimit(DynamicObject data) {
        String changeType = data.getString("changetype");
        if ("other".equals(data.getString("bizbilltype")) || "cfm_creditlimit".equals(data.getString("bizbilltype"))) {
            return null;
        }
        if (UseCreditChangeTypeEnum.LOCK.getValue().equals(changeType)) {
            DynamicObject useConfig = UseCreditHelper.getUseConfig((String)data.getString("bizbilltype"));
            if (EmptyUtil.isEmpty((DynamicObject)useConfig)) {
                return null;
            }
            CreditLimitService creditLimitService = new CreditLimitService();
            DynamicObject contractNo = data.getDynamicObject("contractno");
            String bindId = data.getString("bindid");
            String entityName = useConfig.getDynamicObject("biztype").getString("number");
            boolean isPre = useConfig.getBoolean("ispre");
            if (EmptyUtil.isNoEmpty((DynamicObject)contractNo) && EmptyUtil.isNoEmpty((String)bindId)) {
                long bizEntryId = data.getLong("bizentryid");
                boolean isCreditUseBill = CreditlimitHelper.isExistBillCredituse(contractNo.getLong("id"), Long.parseLong(bindId), EmptyUtil.isNoEmpty((Long)bizEntryId) ? bizEntryId : Long.parseLong(bindId), BillStatusEnum.SAVE.getValue());
                if (!isCreditUseBill) {
                    CreditLimitUseBean useBean = new CreditLimitUseBean();
                    useBean.setPkId(Long.valueOf(Long.parseLong(bindId)));
                    useBean.setEntityName(entityName);
                    useBean.setSourceBillEntryId(Long.valueOf(data.getLong("bizentryid")));
                    useBean.setOrgId(Long.valueOf(data.getDynamicObject("org").getLong("id")));
                    useBean.setFinOrgId(Long.valueOf(data.getDynamicObject("finorginfo").getLong("id")));
                    useBean.setCurrencyId(Long.valueOf(data.getDynamicObject("currency").getLong("id")));
                    if (EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("credittype"))) {
                        useBean.setCreditTypeId(Long.valueOf(data.getDynamicObject("credittype").getLong("id")));
                    }
                    useBean.setCreditVariety(data.getString("creditproduct"));
                    useBean.setCreditFinType(data.getString("banktype"));
                    BigDecimal amount = data.getBigDecimal("creditamount");
                    BigDecimal useAmount = data.getBigDecimal("businessamount");
                    useBean.setBizAmt(useAmount);
                    useBean.setCreditRatio(amount.multiply(Constants.ONE_HUNDRED).divide(useAmount, 6, 1));
                    useBean.setMaxAmt(useAmount);
                    useBean.setStartDate(data.getDate("startdate"));
                    useBean.setEndDate(data.getDate("expiredate"));
                    useBean.setCreditLimitNo(contractNo.getString("number"));
                    useBean.setPreOccupy(Boolean.valueOf(isPre));
                    creditLimitService.autoUseCreditLimit(useBean);
                }
            }
            CreditLimitInfo bean = new CreditLimitInfo();
            bean.setId(Long.valueOf(data.getLong("bindid")));
            bean.setBillno(data.getString("businesscode"));
            bean.setCreatetime(data.getDate("bizdate"));
            bean.setPreOccupy(isPre);
            bean.setEntityName(entityName);
            return bean;
        }
        return null;
    }

    private void releaseCreditLimit(DynamicObject data, DynamicObject useCredit) {
        String changeType = data.getString("changetype");
        if (Objects.equals(changeType, UseCreditChangeTypeEnum.RELEASE.getValue())) {
            CreditLimitService creditLimitService = new CreditLimitService();
            ReturnCreditLimitInfo bean = new ReturnCreditLimitInfo();
            bean.setId(Long.valueOf(data.getLong("bindid")));
            bean.setEntityName("cfm_use_credit");
            bean.setReturnAmt(data.getBigDecimal("releaseamount"));
            bean.setReturnBillId((Long)data.getPkValue());
            bean.setReturnTime(data.getDate("bizdate"));
            if (useCredit != null) {
                bean.setLast(useCredit.getBigDecimal("amountreleased").compareTo(useCredit.getBigDecimal("businessamount")) == 0);
            }
            bean.setPreEntityName(data.getDynamicObjectType().getName());
            creditLimitService.returnCreditLimit(bean);
        }
    }

    private DynamicObject updateReleaseAmount(BigDecimal currentRelease, String rootId) {
        DynamicObject useCredit = UseCreditHelper.loadSingleUseCreditById((Long)Long.valueOf(rootId));
        useCredit.set("amountreleased", (Object)useCredit.getBigDecimal("amountreleased").add(currentRelease));
        useCredit.set("curcyamountreleased", (Object)useCredit.getBigDecimal("curcyamountreleased").add(currentRelease));
        SaveServiceHelper.update((DynamicObject)useCredit);
        return useCredit;
    }
}

