/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.service.usecredit;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.tmc.creditm.common.enums.UseCreditChangeTypeEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;

public class UseCreditAutoReleaseService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("bindid");
        sel.add("rootid");
        sel.add("org");
        sel.add("banktype");
        sel.add("credittype");
        sel.add("changetype");
        sel.add("releaseamount");
        sel.add("creditproduct");
        sel.add("bizbilltype");
        sel.add("businesscode");
        sel.add("startdate");
        sel.add("expiredate");
        sel.add("currency");
        sel.add("businessamount");
        sel.add("remark");
        sel.add("description");
        sel.add("uniquecode");
        sel.add("contractno");
        sel.add("registrant");
        sel.add("createtime");
        sel.add("creator");
        sel.add("creditcurrency");
        sel.add("finorginfo");
        sel.add("bizdate");
        return sel;
    }

    public void process(DynamicObject[] entities) throws KDException {
        String billStatus = (String)this.operationVariable.get("billstatus");
        ArrayList<DynamicObject> releases = new ArrayList<DynamicObject>(entities.length);
        for (DynamicObject useEntity : entities) {
            DynamicObject releaseEntity = TmcDataServiceHelper.clone((DynamicObject)useEntity);
            releaseEntity.set("rootid", useEntity.getPkValue());
            releaseEntity.set("billno", null);
            releaseEntity.set("changetype", (Object)UseCreditChangeTypeEnum.RELEASE.getValue());
            releaseEntity.set("releaseamount", (Object)useEntity.getBigDecimal("businessamount").subtract(useEntity.getBigDecimal("amountreleased")));
            releaseEntity.set("uniquecode", (Object)UUID.randomUUID().toString());
            DynamicObject creditLimit = useEntity.getDynamicObject("contractno");
            DynamicObject realCreditLimit = CreditLimitHelper.getRealCreditLimit((DynamicObject)creditLimit);
            releaseEntity.set("contractno", (Object)realCreditLimit);
            releaseEntity.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            releaseEntity.set("createtime", (Object)DateUtils.getCurrentTime());
            releaseEntity.set("creator", (Object)RequestContext.get().getCurrUserId());
            releaseEntity.set("bizdate", (Object)DateUtils.getCurrentDate());
            releases.add(releaseEntity);
        }
        OperationResult operationResult = TmcOperateServiceHelper.execOperate((String)"save", (String)"cfm_use_credit", (DynamicObject[])releases.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if ("submit".equals(billStatus) || "audit".equals(billStatus)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("WF", "TRUE");
            OperationResult submitResult = TmcOperateServiceHelper.execOperate((String)"submit", (String)"cfm_use_credit", (Object[])operationResult.getSuccessPkIds().toArray(), (OperateOption)operateOption);
            if ("audit".equals(billStatus) && submitResult.isSuccess()) {
                TmcOperateServiceHelper.execOperate((String)"audit", (String)"cfm_use_credit", (Object[])submitResult.getSuccessPkIds().toArray(), (OperateOption)operateOption);
            }
        }
    }
}

