/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.service.usecredit;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.creditm.business.service.creditlimit.CreditLimitService;
import kd.tmc.creditm.common.enums.UseCreditChangeTypeEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UseCreditSubmitService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] datas) throws KDException {
        HashMap<String, Set> bindEntryIdMap = new HashMap<String, Set>(datas.length);
        for (DynamicObject data : datas) {
            this.creditLimit(data);
            if (EmptyUtil.isEmpty((DynamicObject)data.getDynamicObject("registrant"))) {
                data.set("registrant", (Object)RequestContext.get().getCurrUserId());
            }
            if (!EmptyUtil.isNoEmpty((Long)data.getLong("bizentryid"))) continue;
            Set entrySet = bindEntryIdMap.getOrDefault(data.getString("bindid"), new HashSet());
            entrySet.add(data.getLong("bizentryid"));
            bindEntryIdMap.put(data.getString("bindid"), entrySet);
        }
        for (Map.Entry entry : bindEntryIdMap.entrySet()) {
            CreditLimitServiceHelper.deleteCreditLimitUse((Long)Long.parseLong((String)entry.getKey()), (Set)((Set)entry.getValue()));
        }
    }

    private void creditLimit(DynamicObject data) {
        DynamicObject contractNo = data.getDynamicObject("contractno");
        String bindId = data.getString("bindid");
        String changeType = data.getString("changetype");
        if (!UseCreditChangeTypeEnum.isLock((String)changeType) || !"other".equals(data.getString("bizbilltype"))) {
            return;
        }
        CreditLimitService creditLimitService = new CreditLimitService();
        if (EmptyUtil.isNoEmpty((DynamicObject)contractNo) && EmptyUtil.isNoEmpty((String)bindId)) {
            DynamicObject creditUseBill = CreditLimitHelper.getCreditUseBill((Long)Long.parseLong(bindId), (String)"cfm_use_credit", (Long)Long.parseLong(bindId));
            if (EmptyUtil.isEmpty((DynamicObject)creditUseBill)) {
                CreditLimitUseBean useBean = new CreditLimitUseBean();
                useBean.setPkId(Long.valueOf(Long.parseLong(bindId)));
                useBean.setEntityName("cfm_use_credit");
                useBean.setOrgId(Long.valueOf(data.getDynamicObject("org").getLong("id")));
                useBean.setFinOrgId(Long.valueOf(data.getDynamicObject("finorginfo").getLong("id")));
                useBean.setCurrencyId(Long.valueOf(data.getDynamicObject("currency").getLong("id")));
                if (EmptyUtil.isNoEmpty((DynamicObject)data.getDynamicObject("credittype"))) {
                    useBean.setCreditTypeId(Long.valueOf(data.getDynamicObject("credittype").getLong("id")));
                }
                useBean.setCreditVariety(data.getString("creditproduct"));
                useBean.setCreditFinType(data.getString("banktype"));
                BigDecimal amount = data.getBigDecimal("creditamount");
                BigDecimal useAmount = data.getBigDecimal("businessamount");
                useBean.setBizAmt(useAmount);
                useBean.setCreditRatio(amount.multiply(Constants.ONE_HUNDRED).divide(useAmount, 6, 1));
                useBean.setMaxAmt(useAmount);
                useBean.setStartDate(data.getDate("startdate"));
                useBean.setEndDate(data.getDate("expiredate"));
                useBean.setCreditLimitNo(contractNo.getString("number"));
                useBean.setPreOccupy(Boolean.FALSE);
                creditLimitService.autoUseCreditLimit(useBean);
            }
            CreditLimitInfo bean = new CreditLimitInfo();
            bean.setId(Long.valueOf(data.getLong("bindid")));
            bean.setBillno(data.getString("billno"));
            bean.setEntityName("cfm_use_credit");
            bean.setCreatetime(data.getDate("bizdate"));
            creditLimitService.confirmCreditLimit(bean);
        }
    }
}

