/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.service.usecredit;

import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.creditm.business.service.creditlimit.CreditLimitService;
import kd.tmc.creditm.common.enums.UseCreditChangeTypeEnum;
import kd.tmc.creditm.common.helper.CreditFrameworkHelper;
import kd.tmc.creditm.common.helper.UseCreditHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UseCreditUnAuditService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] entitys) throws KDException {
        for (DynamicObject useCredit : entitys) {
            if (Objects.equals(UseCreditChangeTypeEnum.LOCK.getValue(), useCredit.getString("changetype"))) {
                this.cancelConfirmLimit(useCredit);
                this.updateCreditFrameWork(useCredit);
                continue;
            }
            this.updateReleaseAmount(useCredit.getBigDecimal("releaseamount"), useCredit.getString("rootid"));
            CreditLimitService creditLimitService = new CreditLimitService();
            ReturnCreditLimitInfo creditLimitCancelReturnBean = new ReturnCreditLimitInfo();
            creditLimitCancelReturnBean.setId(Long.valueOf(useCredit.getLong("bindid")));
            creditLimitCancelReturnBean.setEntityName("cfm_use_credit");
            creditLimitCancelReturnBean.setReturnBillId(Long.valueOf(useCredit.getLong("id")));
            creditLimitCancelReturnBean.setBizBillId(Long.valueOf(useCredit.getLong("id")));
            creditLimitService.cancelReturnCreditLimit(creditLimitCancelReturnBean);
        }
    }

    private void updateReleaseAmount(BigDecimal releaseAmount, String rootId) {
        DynamicObject useCredit = UseCreditHelper.loadSingleUseCreditById((Long)Long.valueOf(rootId));
        useCredit.set("amountreleased", (Object)useCredit.getBigDecimal("amountreleased").subtract(releaseAmount));
        useCredit.set("curcyamountreleased", (Object)useCredit.getBigDecimal("curcyamountreleased").subtract(releaseAmount));
        SaveServiceHelper.update((DynamicObject)useCredit);
    }

    private void cancelConfirmLimit(DynamicObject useCredit) {
        DynamicObject useConfig;
        String bizType = useCredit.getString("bizbilltype");
        if ("cfm_creditlimit".equals(bizType)) {
            return;
        }
        CreditLimitService creditLimitService = new CreditLimitService();
        CreditLimitInfo bean = new CreditLimitInfo();
        bean.setId(Long.valueOf(useCredit.getLong("bindid")));
        bean.setEntityName("cfm_use_credit");
        if (!"other".equals(bizType) && EmptyUtil.isNoEmpty((DynamicObject)(useConfig = UseCreditHelper.getUseConfig((String)bizType)))) {
            bean.setEntityName(useConfig.getDynamicObject("biztype").getString("number"));
        }
        creditLimitService.cancelCreditLimit(bean);
    }

    private void updateCreditFrameWork(DynamicObject data) {
        String bizType = data.getString("bizbilltype");
        if (!"cfm_creditlimit".equals(bizType)) {
            return;
        }
        long bindId = Long.parseLong(data.getString("bindid"));
        DynamicObject limit = TmcDataServiceHelper.loadSingle((Object)bindId, (String)"cfm_creditlimit", (String)"framework");
        if (EmptyUtil.isEmpty((DynamicObject)limit.getDynamicObject("framework"))) {
            return;
        }
        limit.set("framework", null);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{limit});
        DynamicObject frameWork = data.getDynamicObject("contractno");
        DynamicObject creditLimit = QueryServiceHelper.queryOne((String)"cfm_creditlimit", (String)"id,org,credittype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bindId)});
        CreditFrameworkHelper.creditWriteBackFrame((Long)frameWork.getLong("id"), (Long)creditLimit.getLong("org"), (Long)creditLimit.getLong("credittype"), (BigDecimal)data.getBigDecimal("creditamount").negate());
    }
}

