/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.apply;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.creditm.common.enums.CreditmApplyTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditmApplyAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applytype");
        selector.add("billstatus");
        selector.add("org");
        selector.add("bank");
        selector.add("currency");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("creditlimit");
        selector.add("entry_org");
        selector.add("renewalenddate");
        selector.add("isframework");
        selector.add("comment");
        selector.add("entry_org.o_totalamt");
        selector.add("entry_org.o_org");
        selector.add("entry_org.o_singleamt");
        selector.add("entry_org.o_oldsingleamt");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject data = entity.getDataEntity();
            String applyType = data.getString("applytype");
            if (!BillStatusEnum.SUBMIT.getValue().equals(data.getString("billstatus"))) continue;
            if (CreditmApplyTypeEnum.JOIN.getValue().equals(applyType)) {
                this.checkJoin(entity);
                continue;
            }
            if (CreditmApplyTypeEnum.RENEWAL.getValue().equals(applyType)) {
                this.checkRenewal(entity);
                continue;
            }
            if (CreditmApplyTypeEnum.ADJUST.getValue().equals(applyType)) {
                this.checkAdjust(entity);
                continue;
            }
            if (!CreditmApplyTypeEnum.isChange((String)applyType)) continue;
            this.checkStatus(entity);
        }
    }

    private void checkStatus(ExtendedDataEntity entity) {
        DynamicObject data = entity.getDataEntity();
        DynamicObject limit = data.getDynamicObject("creditlimit");
        if (!BillStatusEnum.AUDIT.getValue().equals(limit.getString("status"))) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355[%s]\u975e\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u7533\u8bf7\u3002", (String)"CreditmApplyAuditValidator_3", (String)"tmc-creditm-business", (Object[])new Object[0]), limit.getString("number")));
        }
        if (limit.getBoolean("isclose")) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355[%s]\u5df2\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u7533\u8bf7\u3002", (String)"CreditmApplyAuditValidator_4", (String)"tmc-creditm-business", (Object[])new Object[0]), limit.getString("number")));
        }
    }

    private void checkAdjust(ExtendedDataEntity entity) {
        this.checkStatus(entity);
    }

    private void checkRenewal(ExtendedDataEntity entity) {
        this.checkStatus(entity);
        DynamicObject data = entity.getDataEntity();
        DynamicObject limit = data.getDynamicObject("creditlimit");
        Date endDate = limit.getDate("enddate");
        Date renewalDate = data.getDate("renewalenddate");
        if (EmptyUtil.isEmpty((Object)renewalDate) || !renewalDate.after(endDate)) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7eed\u671f\u540e\u5230\u671f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u6388\u4fe1\u989d\u5ea6\u7684\u5230\u671f\u65e5\u671f[%s]\u3002", (String)"CreditmApplyAuditValidator_2", (String)"tmc-creditm-business", (Object[])new Object[0]), DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd")));
        }
    }

    private void checkJoin(ExtendedDataEntity entity) {
        DynamicObjectCollection orgs;
        this.checkStatus(entity);
        DynamicObject data = entity.getDataEntity();
        DynamicObjectCollection entryOrgs = data.getDynamicObjectCollection("entry_org");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryOrgs) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(orgs = ((DynamicObject)entryOrgs.get(0)).getDynamicObjectCollection("o_org")))) {
            DynamicObject limit = data.getDynamicObject("creditlimit");
            Object orgId = ((DynamicObject)orgs.get(0)).getDynamicObject("fbasedataid").getPkValue();
            String orgName = ((DynamicObject)orgs.get(0)).getDynamicObject("fbasedataid").getString("name");
            DynamicObjectCollection limitEntryOrgs = limit.getDynamicObjectCollection("entry_org");
            HashSet orgIds = new HashSet(limitEntryOrgs.size());
            for (DynamicObject limitEntryOrg : limitEntryOrgs) {
                orgIds.addAll(limitEntryOrg.getDynamicObjectCollection("o_org").stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet()));
            }
            if (orgIds.contains(orgId)) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355[%1$s]\u4e2d\u5df2\u5b58\u5728\u8d44\u91d1\u7ec4\u7ec7[%2$s]\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CreditmApplyAuditValidator_1", (String)"tmc-creditm-business", (Object[])new Object[0]), limit.getString("number"), orgName));
            }
        }
    }
}

