/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.apply;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.creditm.business.helper.CreditlimitApplyHelper;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditmApplySaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("creditlimit");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObject limit = data.getDynamicObject("creditlimit");
            if (EmptyUtil.isEmpty((DynamicObject)limit)) {
                return;
            }
            DynamicObject applyBills = CreditlimitApplyHelper.getCreditLimitApplyBill(limit.getLong("id"), data.getLong("id"));
            if (EmptyUtil.isNoEmpty((DynamicObject)applyBills)) {
                this.addErrorMessage(dataEntity, CreditmBusResourceEnum.CreditmApplySubmitValidator_30.loadKDString(limit.getString("number"), applyBills.getString("billno")));
            }
            if (BillStatusEnum.isAudit((String)limit.getString("status")) && !limit.getBoolean("isclose")) continue;
            this.addErrorMessage(dataEntity, CreditmBusResourceEnum.CreditmApplySubmitValidator_29.loadKDString());
        }
    }
}

