/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.apply;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.business.helper.CreditlimitApplyHelper;
import kd.tmc.creditm.business.helper.CreditlimitHelper;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.enums.CreditmApplyTypeEnum;
import kd.tmc.creditm.common.enums.GuaranteeWayEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditmApplySubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("applytype");
        selector.add("status");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("totalamt");
        selector.add("creditlimit");
        selector.add("renewalenddate");
        selector.add("isframework");
        selector.add("currency");
        selector.add("entry_org");
        selector.add("entry_type");
        selector.add("t_totalamt");
        selector.add("t_singleamt");
        selector.add("guartype");
        selector.add("entry_org.pid");
        selector.add("entry_org.o_totalamt");
        selector.add("entry_org.o_org");
        selector.add("entry_org.o_singleamt");
        selector.add("entry_org.o_oldsingleamt");
        selector.add("entry_type.pid");
        selector.add("entry_type.t_credittype");
        selector.add("entry_mult.m_org");
        selector.add("entry_mult.m_credittype");
        selector.add("entry_mult.m_totalamt");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject data = entity.getDataEntity();
            String applyType = data.getString("applytype");
            if (!BillStatusEnum.SAVE.getValue().equals(data.getString("billstatus"))) continue;
            this.baseValidata(entity);
            if (CreditmApplyTypeEnum.isAdd((String)applyType)) {
                this.checkAddAndChange(entity);
                this.checkAddRepeat(entity);
                continue;
            }
            if (CreditmApplyTypeEnum.isJoin((String)applyType)) {
                this.checkJoin(entity);
                continue;
            }
            if (CreditmApplyTypeEnum.isRenewal((String)applyType)) {
                this.checkRenewal(entity);
                continue;
            }
            if (CreditmApplyTypeEnum.isAdjust((String)applyType)) {
                this.checkAdjust(entity);
                continue;
            }
            if (!CreditmApplyTypeEnum.isChange((String)applyType)) continue;
            this.checkAddAndChange(entity);
            this.checkChange(entity);
        }
    }

    private void baseValidata(ExtendedDataEntity entity) {
        DynamicObject data = entity.getDataEntity();
        DynamicObject limit = data.getDynamicObject("creditlimit");
        if (EmptyUtil.isEmpty((DynamicObject)limit)) {
            return;
        }
        DynamicObject applyBills = CreditlimitApplyHelper.getCreditLimitApplyBill(limit.getLong("id"), data.getLong("id"));
        if (EmptyUtil.isNoEmpty((DynamicObject)applyBills)) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_30.loadKDString(limit.getString("number"), applyBills.getString("billno")));
        }
        if (!BillStatusEnum.isAudit((String)limit.getString("status")) || limit.getBoolean("isclose")) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_29.loadKDString());
        }
    }

    private void checkChange(ExtendedDataEntity entity) {
        DynamicObject limit;
        DynamicObject data = entity.getDataEntity();
        String res = CreditlimitHelper.checkExistOrgAndType(data, Collections.singleton((limit = data.getDynamicObject("creditlimit")).getLong("id")));
        if (EmptyUtil.isNoEmpty((String)res)) {
            this.addErrorMessage(entity, res);
        }
    }

    private void checkAdjust(ExtendedDataEntity entity) {
        DynamicObject data = entity.getDataEntity();
        DynamicObject limit = data.getDynamicObject("creditlimit");
        if (EmptyUtil.isEmpty((DynamicObject)limit)) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_6.loadKDString());
            return;
        }
        this.checkStatus(entity);
        DynamicObjectCollection orgEntrys = data.getDynamicObjectCollection("entry_org");
        for (int rowIdx = 0; rowIdx < orgEntrys.size(); ++rowIdx) {
            DynamicObject entry = (DynamicObject)orgEntrys.get(rowIdx);
            BigDecimal oldAmt = entry.getBigDecimal("o_oldsingleamt");
            if (!EmptyUtil.isNoEmpty((BigDecimal)oldAmt) || oldAmt.compareTo(entry.getBigDecimal("o_singleamt")) != 0 && oldAmt.compareTo(entry.getBigDecimal("o_totalamt")) != 0) continue;
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_15.loadKDString(rowIdx + 1));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgEntrys)) {
            DynamicObject orgEntry = orgEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((BigDecimal)o.getBigDecimal("pid"))).findFirst().orElse(null);
            String amtField = "o_singleamt";
            if (orgEntrys.size() == 1 && orgEntry == null) {
                orgEntry = (DynamicObject)orgEntrys.get(0);
                amtField = "o_totalamt";
            }
            String fieldName = ((IDataEntityProperty)data.getDynamicObjectCollection("entry_org").getDynamicObjectType().getProperties().get((Object)amtField)).getDisplayName().getLocaleValue();
            BigDecimal amt = orgEntry.getBigDecimal(amtField);
            DynamicObject org = orgEntry.getDynamicObjectCollection("o_org").stream().map(o -> o.getDynamicObject("fbasedataid")).findFirst().orElseGet(null);
            if (EmptyUtil.isEmpty((DynamicObject)orgEntry) || org == null) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_0.loadKDString(fieldName));
            } else {
                BigDecimal totalAmt = limit.getBigDecimal("totalamt");
                DynamicObject currency = data.getDynamicObject("currency");
                int amtPrecision = CreditLimitHelper.getAmtPrecision((DynamicObject)currency);
                if (amt.compareTo(totalAmt) > 0) {
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_1.loadKDString(org.getString("name"), fieldName, totalAmt.setScale(amtPrecision)));
                }
                DynamicObjectCollection limitEntryOrgs = limit.getDynamicObjectCollection("entry_org");
                for (DynamicObject limitEntryOrg : limitEntryOrgs) {
                    Set orgIds = limitEntryOrg.getDynamicObjectCollection("o_org").stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                    BigDecimal etotalAmt = limitEntryOrg.getBigDecimal("o_totalamt");
                    if (orgIds.size() <= 1 || !orgIds.contains(org.getPkValue()) || etotalAmt.compareTo(BigDecimal.ZERO) <= 0 || amt.compareTo(etotalAmt) <= 0) continue;
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_2.loadKDString(org.getString("name"), fieldName, etotalAmt.setScale(amtPrecision)));
                    break;
                }
            }
        }
    }

    private void checkRenewal(ExtendedDataEntity entity) {
        DynamicObject data = entity.getDataEntity();
        DynamicObject limit = data.getDynamicObject("creditlimit");
        if (EmptyUtil.isEmpty((DynamicObject)limit)) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_6.loadKDString());
            return;
        }
        this.checkStatus(entity);
        Date endDate = limit.getDate("enddate");
        Date renewalDate = data.getDate("renewalenddate");
        if (EmptyUtil.isEmpty((Object)renewalDate) || !renewalDate.after(endDate)) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_4.loadKDString(DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd")));
        }
    }

    private void checkAddAndChange(ExtendedDataEntity entity) {
        String guartypes;
        List guartypeList;
        BigDecimal totalAmt;
        DynamicObject data = entity.getDataEntity();
        Date startDate = data.getDate("startdate");
        Date endDate = data.getDate("enddate");
        String applyType = data.getString("applytype");
        if (CreditmApplyTypeEnum.isAddChange((String)applyType) && !endDate.after(startDate)) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_5.loadKDString());
        }
        if (EmptyUtil.isEmpty((BigDecimal)(totalAmt = data.getBigDecimal("totalamt"))) || totalAmt.compareTo(BigDecimal.ZERO) <= 0) {
            this.addErrorMessage(entity, CreditmApplyTypeEnum.isAdd((String)applyType) ? CreditmBusResourceEnum.CreditmApplySubmitValidator_13.loadKDString() : CreditmBusResourceEnum.CreditmApplySubmitValidator_31.loadKDString());
        }
        if ((guartypeList = Arrays.stream((guartypes = data.getString("guartype")).split(",")).collect(Collectors.toList())).contains(GuaranteeWayEnum.OTHER.getValue()) && guartypeList.contains(GuaranteeWayEnum.NONE.getValue())) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_34.loadKDString());
        }
        DynamicObject currency = data.getDynamicObject("currency");
        int amtPrecision = CreditLimitHelper.getAmtPrecision((DynamicObject)currency);
        DynamicObjectCollection orgEntrys = data.getDynamicObjectCollection("entry_org");
        if (orgEntrys.size() == 0) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_14.loadKDString());
        }
        HashSet orgIds = new HashSet(orgEntrys.size());
        Map parentAmtMap = CreditLimitHelper.getParentAmtMap((DynamicObjectCollection)orgEntrys, (String)"o_totalamt");
        for (int i = 0; i < orgEntrys.size(); ++i) {
            DynamicObject orgEntry = (DynamicObject)orgEntrys.get(i);
            Set orgIdSets = CreditLimitHelper.getCollIds((DynamicObjectCollection)orgEntry.getDynamicObjectCollection("o_org"));
            if (orgIdSets.size() == 0) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_24.loadKDString(i + 1));
            }
            if (orgIdSets.size() == 1) {
                if (orgIds.contains(orgIdSets.iterator().next())) {
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_8.loadKDString(i + 1));
                } else {
                    orgIds.addAll(orgIdSets);
                }
            }
            if (EmptyUtil.isEmpty((Long)orgEntry.getLong("pid"))) {
                BigDecimal ototalAmt = orgEntry.getBigDecimal("o_totalamt");
                if (ototalAmt.compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_19.loadKDString(i + 1));
                }
                if (ototalAmt.compareTo(totalAmt) <= 0) continue;
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_23.loadKDString(i + 1, totalAmt.setScale(amtPrecision)));
                continue;
            }
            BigDecimal entrySingleAmt = orgEntry.getBigDecimal("o_singleamt");
            BigDecimal parentAmt = (BigDecimal)parentAmtMap.get(orgEntry.getLong("pid"));
            if (entrySingleAmt != null && entrySingleAmt.compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_20.loadKDString(i + 1));
            }
            if (entrySingleAmt == null || entrySingleAmt.compareTo(parentAmt) <= 0) continue;
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_7.loadKDString(i + 1, parentAmt.setScale(amtPrecision)));
        }
        DynamicObjectCollection typeEntrys = data.getDynamicObjectCollection("entry_type");
        Map parentTypeAmtMap = CreditLimitHelper.getParentAmtMap((DynamicObjectCollection)typeEntrys, (String)"t_totalamt");
        for (int i = 0; i < typeEntrys.size(); ++i) {
            DynamicObject typeEntry = (DynamicObject)typeEntrys.get(i);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)typeEntry.getDynamicObjectCollection("t_credittype"))) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_16.loadKDString(i + 1));
            }
            if (EmptyUtil.isEmpty((Long)typeEntry.getLong("pid"))) {
                BigDecimal ttotalAmt = typeEntry.getBigDecimal("t_totalamt");
                if (ttotalAmt.compareTo(BigDecimal.ZERO) <= 0) {
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_21.loadKDString(i + 1));
                }
                if (ttotalAmt.compareTo(totalAmt) <= 0) continue;
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_9.loadKDString(i + 1, totalAmt.setScale(amtPrecision)));
                continue;
            }
            BigDecimal entrySingleAmt = typeEntry.getBigDecimal("t_singleamt");
            if (entrySingleAmt != null && entrySingleAmt.compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_22.loadKDString(i + 1));
            }
            BigDecimal parentAmt = (BigDecimal)parentTypeAmtMap.get(typeEntry.getLong("pid"));
            if (entrySingleAmt == null || entrySingleAmt.compareTo(parentAmt) <= 0) continue;
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_10.loadKDString(i + 1, parentAmt.setScale(amtPrecision)));
        }
        if (!CreditmApplyTypeEnum.isChange((String)applyType)) {
            return;
        }
        Set collOrgIds = CreditLimitHelper.getMultiPorpIds((DynamicObjectCollection)orgEntrys, (String)"o_org");
        Set collTypeIds = CreditLimitHelper.getMultiPorpIds((DynamicObjectCollection)typeEntrys, (String)"t_credittype");
        DynamicObjectCollection multEntrys = data.getDynamicObjectCollection("entry_mult");
        HashSet<String> orgTypeIds = new HashSet<String>(multEntrys.size());
        for (int i = 0; i < multEntrys.size(); ++i) {
            String msg;
            BigDecimal mtotalAmt = ((DynamicObject)multEntrys.get(i)).getBigDecimal("m_totalamt");
            if (mtotalAmt != null && mtotalAmt.compareTo(totalAmt) > 0) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_32.loadKDString(i + 1));
            }
            if (!EmptyUtil.isNoEmpty((String)(msg = CreditlimitHelper.checkOrgType(orgTypeIds, collOrgIds, collTypeIds, (DynamicObject)multEntrys.get(i), data.getString("orgsharetype"))))) continue;
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_7.loadKDString(i + 1, msg));
        }
    }

    private void checkAddRepeat(ExtendedDataEntity entity) {
        DynamicObject data = entity.getDataEntity();
        boolean isFrameWork = data.getBoolean("isframework");
        DynamicObject org = data.getDynamicObject("org");
        DynamicObject bank = data.getDynamicObject("bank");
        DynamicObject currency = data.getDynamicObject("currency");
        Date startDate = data.getDate("startdate");
        Date endDate = data.getDate("enddate");
        DynamicObjectCollection creditLimits = QueryServiceHelper.query((String)"cfm_creditlimit", (String)"id,number,startdate,enddate", (QFilter[])new QFilter[]{new QFilter("org", "=", org.getPkValue()).and("bank", "=", bank.getPkValue()).and("currency", "=", currency.getPkValue()).and("isframework", "=", (Object)isFrameWork)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)creditLimits)) {
            return;
        }
        for (DynamicObject creditLimit : creditLimits) {
            Date creditStartDate = creditLimit.getDate("startdate");
            Date creditEndDate = creditLimit.getDate("enddate");
            if (startDate.after(creditEndDate) || endDate.before(creditStartDate)) continue;
            this.addWarningMessage(entity, isFrameWork ? CreditmBusResourceEnum.CreditmApplySubmitValidator_28.loadKDString(creditLimit.getString("number")) : CreditmBusResourceEnum.CreditmApplySubmitValidator_25.loadKDString(creditLimit.getString("number")));
            break;
        }
    }

    private void checkJoin(ExtendedDataEntity entity) {
        boolean isparentOrg;
        DynamicObjectCollection orgs;
        DynamicObject data = entity.getDataEntity();
        DynamicObject limit = data.getDynamicObject("creditlimit");
        if (EmptyUtil.isEmpty((DynamicObject)limit)) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_6.loadKDString());
            return;
        }
        this.checkStatus(entity);
        BigDecimal totalAmt = limit.getBigDecimal("totalamt");
        DynamicObjectCollection entryOrgs = data.getDynamicObjectCollection("entry_org");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryOrgs)) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_26.loadKDString());
        }
        DynamicObject currency = data.getDynamicObject("currency");
        BigDecimal entryTotalAmt = ((DynamicObject)entryOrgs.get(0)).getBigDecimal("o_totalamt");
        if (EmptyUtil.isEmpty((BigDecimal)entryTotalAmt) || entryTotalAmt.compareTo(BigDecimal.ZERO) <= 0) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_18.loadKDString());
        }
        int amtPrecision = CreditLimitHelper.getAmtPrecision((DynamicObject)currency);
        if (entryTotalAmt != null && entryTotalAmt.compareTo(totalAmt) > 0) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_17.loadKDString(entryTotalAmt.setScale(amtPrecision), limit.getString("number"), totalAmt.setScale(amtPrecision)));
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)(orgs = ((DynamicObject)entryOrgs.get(0)).getDynamicObjectCollection("o_org")))) {
            return;
        }
        long orgId = ((DynamicObject)orgs.get(0)).getDynamicObject("fbasedataid").getLong("id");
        if (EmptyUtil.isNoEmpty((DynamicObject)limit.getDynamicObject("framework")) && !(isparentOrg = CreditLimitHelper.isCheckParentOrg((long)limit.getDynamicObject("org").getLong("id"), (long)orgId))) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_33.loadKDString(limit.getString("number"), limit.getDynamicObject("org").getString("name")));
        }
        String orgName = ((DynamicObject)orgs.get(0)).getDynamicObject("fbasedataid").getString("name");
        DynamicObjectCollection limitEntryOrgs = limit.getDynamicObjectCollection("entry_org");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)limitEntryOrgs)) {
            return;
        }
        HashSet orgIds = new HashSet(limitEntryOrgs.size());
        for (DynamicObject limitEntryOrg : limitEntryOrgs) {
            orgIds.addAll(limitEntryOrg.getDynamicObjectCollection("o_org").stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet()));
        }
        if (orgIds.contains(orgId)) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_27.loadKDString(limit.getString("number"), orgName));
        }
    }

    private void checkStatus(ExtendedDataEntity entity) {
        DynamicObject data = entity.getDataEntity();
        DynamicObject limit = data.getDynamicObject("creditlimit");
        if (!BillStatusEnum.AUDIT.getValue().equals(limit.getString("status"))) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_11.loadKDString(limit.getString("number")));
        }
        if (limit.getBoolean("isclose")) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_12.loadKDString(limit.getString("number")));
        }
    }
}

