/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.apply;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.enums.CreditmApplyTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditmApplyUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("applytype");
        sel.add("ishascreditlimit");
        sel.add("isframework");
        sel.add("creditlimit");
        sel.add("auditdate");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject lastChangeHistory;
            DynamicObject applyNotAudit;
            DynamicObject limit;
            DynamicObject applyBill = dataEntity.getDataEntity();
            if (CreditmApplyTypeEnum.isAdd((String)applyBill.getString("applytype")) && applyBill.getBoolean("ishascreditlimit")) {
                boolean isFrameWork = applyBill.getBoolean("isframework");
                this.addErrorMessage(dataEntity, isFrameWork ? CreditmBusResourceEnum.CreditmApplyUnAuditValidator_2.loadKDString() : CreditmBusResourceEnum.CreditmApplyUnAuditValidator_1.loadKDString());
            }
            if (EmptyUtil.isEmpty((DynamicObject)(limit = applyBill.getDynamicObject("creditlimit")))) continue;
            if (limit.getBoolean("isclose")) {
                this.addErrorMessage(dataEntity, CreditmBusResourceEnum.CreditmApplyUnAuditValidator_7.loadKDString(limit.getString("number")));
            }
            if (!BillStatusEnum.isAudit((String)limit.getString("status"))) {
                this.addErrorMessage(dataEntity, CreditmBusResourceEnum.CreditmApplyUnAuditValidator_8.loadKDString(limit.getString("number")));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(applyNotAudit = QueryServiceHelper.queryOne((String)"creditm_apply", (String)"billno", (QFilter[])new QFilter[]{new QFilter("creditlimit", "=", (Object)limit.getLong("id")).and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())})))) {
                this.addErrorMessage(dataEntity, CreditmBusResourceEnum.CreditmApplyUnAuditValidator_5.loadKDString(limit.getString("number"), applyNotAudit.getString("billno")));
            }
            if (EmptyUtil.isEmpty((DynamicObject)(lastChangeHistory = BillChangeHistoryHelper.getLastChangeHistory((Long)limit.getLong("id"), (String)"cfm_creditlimit")))) {
                this.addErrorMessage(dataEntity, CreditmBusResourceEnum.CreditmApplyUnAuditValidator_4.loadKDString());
            } else if (lastChangeHistory.getLong("applyid") != applyBill.getLong("id")) {
                this.addErrorMessage(dataEntity, CreditmBusResourceEnum.CreditmApplyUnAuditValidator_3.loadKDString());
            }
            this.checkCreditUseOper(dataEntity);
        }
    }

    private void checkCreditUseOper(ExtendedDataEntity dataEntity) {
        DynamicObject applyBill = dataEntity.getDataEntity();
        String applyType = applyBill.getString("applytype");
        if (!(CreditmApplyTypeEnum.isChange((String)applyType) || CreditmApplyTypeEnum.isAdjust((String)applyType) || CreditmApplyTypeEnum.isJoin((String)applyType))) {
            return;
        }
        Date auditTime = applyBill.getDate("auditdate");
        DynamicObject limit = applyBill.getDynamicObject("creditlimit");
        DynamicObjectCollection creditUses = QueryServiceHelper.query((String)"cfm_credituse", (String)"sourcebillno", (QFilter[])new QFilter[]{new QFilter("creditlimit", "=", (Object)limit.getLong("id")).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("operatetime", ">=", (Object)auditTime)}, (String)"operatetime desc", (int)3);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditUses)) {
            String billNos = creditUses.stream().map(o -> o.getString("sourcebillno")).collect(Collectors.joining("\u3001"));
            this.addErrorMessage(dataEntity, CreditmBusResourceEnum.CreditmApplyUnAuditValidator_6.loadKDString(limit.getString("number"), billNos));
        }
    }
}

