/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.creditlimit;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.GuaConBizStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("org");
        selector.add("banktype");
        selector.add("bank");
        selector.add("totalamt");
        selector.add("avaramt");
        selector.add("preuseamt");
        selector.add("contractno");
        selector.add("disttype");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("ismergenew");
        selector.add("entry_org");
        selector.add("entry_type");
        selector.add("entry_mult");
        selector.add("credittype");
        selector.add("isgrouplimit");
        selector.add("creditlimitagree");
        selector.add("orgsharetype");
        selector.add("o_org");
        selector.add("o_totalamt");
        selector.add("o_singleamt");
        selector.add("o_preamt");
        selector.add("o_useamt");
        selector.add("t_avaramt");
        selector.add("t_credittype");
        selector.add("t_totalamt");
        selector.add("t_singleamt");
        selector.add("t_useamt");
        selector.add("t_avaramt");
        selector.add("m_org");
        selector.add("m_credittype");
        selector.add("m_totalamt");
        selector.add("m_useamt");
        selector.add("m_preamt");
        selector.add("m_useamt");
        selector.add("m_avaramt");
        selector.add("entry_org.pid");
        selector.add("entry_type.pid");
        selector.add("entry_mult.pid");
        selector.add("sourcebillids");
        selector.add("guartype");
        selector.add("currency");
        selector.add("ismultcontrol");
        selector.add("framework");
        selector.add("entry_gcontract");
        selector.add("entry_gcontract.gcontract");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject data = entity.getDataEntity();
            String guaType = data.getString("guartype");
            DynamicObject[] gConEntry = this.getGuaEntry(data);
            List<String> guarTypes = Arrays.asList(guaType.split(","));
            if (!data.getBoolean("ismergenew")) {
                this.checkGcon(gConEntry, entity, guarTypes, null);
                continue;
            }
            DynamicObjectCollection soureBills = data.getDynamicObjectCollection("sourcebillids");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)soureBills)) continue;
            QFilter idFilter = new QFilter("gsrcbillid", "=", ((DynamicObject)soureBills.get(0)).getDynamicObject("fbasedataid").getPkValue());
            DynamicObject[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)"id,gcontract", (QFilter[])new QFilter[]{idFilter});
            this.checkGcon(gConEntry, entity, guarTypes, gcUseBills);
        }
    }

    private void checkGcon(DynamicObject[] gConEntry, ExtendedDataEntity entity, List<String> guarTypes, DynamicObject[] oldUseBills) {
        for (DynamicObject entry : gConEntry) {
            DynamicObject guaCon;
            Set<Object> gcontractIds = new HashSet();
            if (EmptyUtil.isNoEmpty((Object[])oldUseBills)) {
                gcontractIds = Arrays.stream(oldUseBills).map(o -> o.getDynamicObject("gcontract").getLong("id")).collect(Collectors.toSet());
            }
            if ((guaCon = entry.getDynamicObject("gcontract")) == null || gcontractIds.contains(guaCon.getLong("id"))) continue;
            if (!GuaConBizStatusEnum.REGISTED.getValue().equals(guaCon.getString("bizstatus")) && !GuaConBizStatusEnum.DOING.getValue().equals(guaCon.getString("bizstatus"))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u62c5\u4fdd\u5355\u53f7[%s]\u7684\u4e1a\u52a1\u72b6\u6001\u975e\u5df2\u767b\u8bb0\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CreditLimitSaveValidator_10", (String)"tmc-creditm-business", (Object[])new Object[]{guaCon.getString("billno")}));
                continue;
            }
            List<String> guaranteewayArr = Arrays.asList(guaCon.getString("guaranteeway").split(","));
            if (CreditLimitHelper.checkGuaType(guarTypes, guaranteewayArr)) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u62c5\u4fdd\u5355\u53f7[%s]\u7684\u62c5\u4fdd\u7c7b\u578b\u548c\u6388\u4fe1\u989d\u5ea6\u5355\u7684\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CreditLimitSaveValidator_9", (String)"tmc-creditm-business", (Object[])new Object[]{guaCon.getString("billno")}));
        }
    }

    private DynamicObject[] getGuaEntry(DynamicObject data) {
        boolean fromEdit = this.getOption().getVariables().containsKey("op_from_edit_form");
        if (!fromEdit) {
            QFilter idFilter = new QFilter("gsrcbillid", "=", data.getPkValue());
            DynamicObject[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)"id,gcontract", (QFilter[])new QFilter[]{idFilter});
            return gcUseBills;
        }
        DynamicObjectCollection gConEntry = data.getDynamicObjectCollection("entry_gcontract");
        return gConEntry.stream().collect(Collectors.toSet()).toArray(new DynamicObject[0]);
    }
}

