/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.creditlimit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;

public class CreditLimitAutoCloseValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("number");
        selector.add("enddate");
        selector.add("status");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject creditLimit = entity.getDataEntity();
            String billNo = creditLimit.getString("number");
            if (creditLimit.getDate("enddate").compareTo(DateUtils.getCurrentDate()) > 0) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitAutoCloseValidator_01.loadKDString(billNo));
            }
            if (BillStatusEnum.isAudit((String)creditLimit.getString("status"))) continue;
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitAutoCloseValidator_02.loadKDString(billNo));
        }
    }
}

