/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.creditlimit;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.enums.CreditmApplyTypeEnum;
import kd.tmc.creditm.common.helper.CreditmValidateFrameHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitFrameworkValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("framework");
        sel.add("creditprop");
        sel.add("currency");
        sel.add("applytype");
        sel.add("currency");
        sel.add("credittype");
        sel.add("sourcebillids");
        sel.add("ismergenew");
        sel.add("isframework");
        sel.add("isgrouplimit");
        sel.add("renewalenddate");
        sel.add("startdate");
        sel.add("enddate");
        sel.add("creditlimit");
        sel.add("org");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject frameWork;
            DynamicObject data = dataEntity.getDataEntity();
            boolean isFrameWork = data.getBoolean("isframework");
            boolean isGroup = data.getBoolean("isgrouplimit");
            if (isFrameWork && !isGroup) {
                this.addErrorMessage(dataEntity, CreditmBusResourceEnum.CreditLimitFrameworkValidator_0.loadKDString());
            }
            if (EmptyUtil.isEmpty((DynamicObject)(frameWork = data.getDynamicObject("framework")))) continue;
            Date endDate = data.getDate("enddate");
            if ("creditm_apply".equals(data.getDynamicObjectType().getName())) {
                String applyType = data.getString("applytype");
                if (CreditmApplyTypeEnum.isAdjust((String)applyType)) continue;
                if (CreditmApplyTypeEnum.isRenewal((String)applyType)) {
                    data.set("enddate", (Object)data.getDate("renewalenddate"));
                }
            }
            List checkMsgs = CreditmValidateFrameHelper.checkLimitFrame((DynamicObject)data, (DynamicObject)frameWork);
            for (String checkMsg : checkMsgs) {
                this.addErrorMessage(dataEntity, checkMsg);
            }
            data.set("enddate", (Object)endDate);
        }
    }
}

