/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.creditlimit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.creditm.business.helper.CreditlimitApplyHelper;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitMergeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("org");
        selector.add("bank");
        selector.add("currency");
        selector.add("status");
        selector.add("isclose");
        selector.add("ismergenew");
        selector.add("number");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObject applyBills;
            DynamicObject data = entity.getDataEntity();
            if (!BillStatusEnum.AUDIT.getValue().equals(data.get("status")) || data.getBoolean("isclose")) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitMergeValidator_1.loadKDString());
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(applyBills = CreditlimitApplyHelper.getCreditLimitApplyBill(data.getLong("id"), 0L)))) continue;
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditmApplySubmitValidator_30.loadKDString(data.getString("number"), applyBills.getString("billno")));
        }
    }
}

