/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.creditlimit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class CreditLimitReleaseAmtValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sels = super.getSelector();
        sels.add("status");
        sels.add("isclose");
        return sels;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            DynamicObject creditBill = dataEntity.getDataEntity();
            if (!BillStatusEnum.AUDIT.getValue().equals(creditBill.getString("status"))) {
                this.addErrorMessage(dataEntity, CreditmBusResourceEnum.CreditLimitReleaseAmtValidator_0.loadKDString());
                continue;
            }
            if (creditBill.getBoolean("isclose")) {
                this.addErrorMessage(dataEntity, CreditmBusResourceEnum.CreditLimitReleaseAmtValidator_1.loadKDString());
                continue;
            }
            boolean isUsed = TmcDataServiceHelper.exists((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("creditlimit", "=", creditBill.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())});
            if (isUsed) continue;
            this.addErrorMessage(dataEntity, CreditmBusResourceEnum.CreditLimitReleaseAmtValidator_2.loadKDString());
        }
    }
}

