/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.creditlimit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.enums.GuaranteeWayEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.GuaConBizStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("totalamt");
        selector.add("enddate");
        selector.add("preuseamt");
        selector.add("avaramt");
        selector.add("amount");
        selector.add("totalamt");
        selector.add("ismergenew");
        selector.add("ischanging");
        selector.add("entry_org");
        selector.add("sourcebillids");
        selector.add("orgsharetype");
        selector.add("guartype");
        selector.add("entry_org.o_avaramt");
        selector.add("entry_org.o_totalamt");
        selector.add("entry_org.o_singleamt");
        selector.add("entry_org.o_useamt");
        selector.add("entry_org.o_preamt");
        selector.add("entry_type");
        selector.add("entry_type.t_avaramt");
        selector.add("entry_type.t_totalamt");
        selector.add("entry_type.t_singleamt");
        selector.add("entry_type.t_useamt");
        selector.add("entry_type.t_preamt");
        selector.add("entry_type.typeorgin");
        selector.add("entry_mult");
        selector.add("entry_mult.m_avaramt");
        selector.add("entry_mult.m_totalamt");
        selector.add("entry_mult.m_singleamt");
        selector.add("entry_mult.m_preamt");
        selector.add("isframework");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            Long typeId;
            long entrySize;
            DynamicObjectCollection entryTypes;
            boolean isMergeNew;
            boolean isCheck;
            DynamicObject data = entity.getDataEntity();
            String guaType = data.getString("guartype");
            if (EmptyUtil.isEmpty((String)guaType)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreditLimitSaveValidator_6", (String)"tmc-creditm-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject[] gConEntry = this.getGuaEntry(data);
            List<String> guarTypes = Arrays.asList(guaType.split(","));
            if (!(gConEntry.length <= 0 || guarTypes.contains(GuaranteeWayEnum.ENSURE.getValue()) || guarTypes.contains(GuaranteeWayEnum.MORTGAGE.getValue()) || guarTypes.contains(GuaranteeWayEnum.PLEDGE.getValue()))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u4e3a\u4fdd\u8bc1\u3001\u62b5\u62bc\u3001\u8d28\u62bc\u65f6\uff0c\u4e0d\u652f\u6301\u5173\u8054\u62c5\u4fdd\u5408\u540c\u3002", (String)"CreditLimitSaveValidator_7", (String)"tmc-creditm-business", (Object[])new Object[0]));
            }
            boolean isFrameWork = data.getBoolean("isframework");
            boolean isImport = this.getOption().getVariables().containsKey("importtag_of_datasource");
            boolean bl = isCheck = isImport || this.getOption().getVariables().containsKey("check");
            if (!isFrameWork && this.isRelateDebt(data) && isCheck && gConEntry.length == 0 && (guarTypes.contains(GuaranteeWayEnum.ENSURE.getValue()) || guarTypes.contains(GuaranteeWayEnum.MORTGAGE.getValue()) || guarTypes.contains(GuaranteeWayEnum.PLEDGE.getValue()))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e3a\u4fdd\u8bc1\u3001\u62b5\u62bc\u3001\u8d28\u62bc\u65f6\uff0c\u8bf7\u586b\u5199\u62c5\u4fdd\u8be6\u60c5\u3002", (String)"CreditLimitSaveValidator_8", (String)"tmc-creditm-business", (Object[])new Object[0]));
            }
            if (!(isMergeNew = data.getBoolean("ismergenew")) && !data.getBoolean("ischanging")) {
                this.checkGcon(gConEntry, entity, guarTypes, null);
                continue;
            }
            if (isMergeNew) {
                DynamicObjectCollection sourceBills;
                Date endDate = data.getDate("enddate");
                if (EmptyUtil.isEmpty((Object)endDate)) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6388\u4fe1\u5230\u671f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreditLimitSaveValidator_4", (String)"tmc-creditm-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)(sourceBills = data.getDynamicObjectCollection("sourcebillids")))) {
                    DynamicObject creditLimit = TmcDataServiceHelper.loadSingle((Object)((DynamicObject)sourceBills.get(0)).getDynamicObject("fbasedataid").getPkValue(), (String)"cfm_creditlimit", (String)"id,enddate");
                    if (EmptyUtil.isNoEmpty((Object)endDate) && endDate.compareTo(creditLimit.getDate("enddate")) < 0) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u5230\u671f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u539f\u6388\u4fe1\u989d\u5ea6\u5355\u7684\u5230\u671f\u65e5\u671f[%s]\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CreditLimitSaveValidator_5", (String)"tmc-creditm-business", (Object[])new Object[0]), DateUtils.formatString((Date)creditLimit.getDate("enddate"), (String)"yyyy-MM-dd")));
                    }
                    QFilter idFilter = new QFilter("gsrcbillid", "=", creditLimit.getPkValue());
                    DynamicObject[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)"id,gcontract", (QFilter[])new QFilter[]{idFilter});
                    this.checkGcon(gConEntry, entity, guarTypes, gcUseBills);
                }
            }
            this.checkEntryAmount(entity);
            if (data.getBoolean("ismergenew")) continue;
            DynamicObjectCollection sourceBillIds = data.getDynamicObjectCollection("sourcebillids");
            Set creditId = CreditLimitHelper.getCollIds((DynamicObjectCollection)sourceBillIds);
            if (data.getBoolean("ischanging")) {
                creditId.add(data.getLong("id"));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)(entryTypes = data.getDynamicObjectCollection("entry_type"))) || (entrySize = entryTypes.stream().filter(o -> o.getBoolean("typeorgin")).count()) != 0L) continue;
            Set creditTypeIds = entryTypes.stream().filter(t -> EmptyUtil.isNoEmpty((DynamicObjectCollection)t.getDynamicObjectCollection("t_credittype"))).map(o -> CreditLimitHelper.getMultCollectIdOrName((DynamicObjectCollection)o.getDynamicObjectCollection("t_credittype"), (boolean)true)).collect(Collectors.toSet());
            Set<Long> hasUseIds = this.getEntryTypes(creditId);
            if (!EmptyUtil.isNoEmpty(hasUseIds) || !EmptyUtil.isNoEmpty((Long)(typeId = CreditLimitHelper.checkExist(creditTypeIds, hasUseIds)))) continue;
            DynamicObject creditType = CreditLimitHelper.getCreditTypeById((long)typeId);
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u7c7b\u522b[%s]\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u6dfb\u52a0\u5230\u7c7b\u522b\u5171\u4eab\u4e2d\u3002", (String)"CreditLimitSaveValidator_11", (String)"tmc-creditm-business", (Object[])new Object[0]), creditType.getString("name")));
        }
    }

    private boolean isRelateDebt(DynamicObject bizBill) {
        return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.GM.getId(), (long)bizBill.getDynamicObject(EntityMetadataCache.getDataEntityType((String)bizBill.getDataEntityType().getName()).getMainOrg()).getLong("id"), (String)"isrelatedebt");
    }

    private void checkGcon(DynamicObject[] gConEntry, ExtendedDataEntity entity, List<String> guarTypes, DynamicObject[] oldUseBills) {
        if (this.getOption().getVariables().containsKey("op_from_isc")) {
            return;
        }
        for (DynamicObject entry : gConEntry) {
            DynamicObject guaCon;
            Set<Object> gContractIds = new HashSet(10);
            if (EmptyUtil.isNoEmpty((Object[])oldUseBills)) {
                gContractIds = Arrays.stream(oldUseBills).map(o -> o.getDynamicObject("gcontract").getLong("id")).collect(Collectors.toSet());
            }
            if ((guaCon = entry.getDynamicObject("gcontract")) == null) continue;
            if (!(gContractIds.contains(guaCon.getLong("id")) || GuaConBizStatusEnum.REGISTED.getValue().equals(guaCon.getString("bizstatus")) || GuaConBizStatusEnum.DOING.getValue().equals(guaCon.getString("bizstatus")))) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u62c5\u4fdd\u5355\u53f7[%s]\u7684\u4e1a\u52a1\u72b6\u6001\u975e\u5df2\u767b\u8bb0\u72b6\u6001\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CreditLimitSaveValidator_10", (String)"tmc-creditm-business", (Object[])new Object[]{guaCon.getString("billno")}));
                continue;
            }
            List<String> guaranteeWayArr = Arrays.asList(guaCon.getString("guaranteeway").split(","));
            if (CreditLimitHelper.checkGuaType(guarTypes, guaranteeWayArr)) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u62c5\u4fdd\u5355\u53f7[%s]\u7684\u62c5\u4fdd\u7c7b\u578b\u548c\u6388\u4fe1\u989d\u5ea6\u5355\u7684\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CreditLimitSaveValidator_12", (String)"tmc-creditm-business", (Object[])new Object[]{guaCon.getString("billno")}));
        }
    }

    private DynamicObject[] getGuaEntry(DynamicObject data) {
        boolean fromEdit;
        boolean isImport = this.getOption().getVariables().containsKey("importtag_of_datasource");
        boolean bl = fromEdit = isImport || this.getOption().getVariables().containsKey("op_from_edit_form");
        if (!fromEdit) {
            QFilter idFilter = new QFilter("gsrcbillid", "=", data.getPkValue());
            DynamicObject[] gcUseBills = TmcDataServiceHelper.load((String)"gm_guaranteeuse", (String)"id,gcontract", (QFilter[])new QFilter[]{idFilter});
            return gcUseBills;
        }
        DynamicObjectCollection gConEntry = data.getDynamicObjectCollection("entry_gcontract");
        return gConEntry.stream().collect(Collectors.toSet()).toArray(new DynamicObject[0]);
    }

    private Set<Long> getEntryTypes(Set<Long> creditLimitId) {
        HashSet<Long> setIds = new HashSet<Long>();
        DataSet creditUseDataSet = QueryServiceHelper.queryDataSet((String)"creditTypeIds", (String)"cfm_credituse", (String)"id,org,credittype,amount,preamount", (QFilter[])new QFilter[]{new QFilter("creditlimit", "in", creditLimitId), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("amount", ">", (Object)0).or(new QFilter("preamount", ">", (Object)0))}, (String)"org").groupBy(new String[]{"credittype"}).finish();
        for (Row creditUse : creditUseDataSet) {
            Long key = creditUse.getLong("credittype");
            setIds.add(key);
        }
        return setIds;
    }

    private void checkEntryAmount(ExtendedDataEntity entity) {
        DynamicObject data = entity.getDataEntity();
        boolean isMergeNew = data.getBoolean("ismergenew");
        BigDecimal totalAmt = data.getBigDecimal("totalamt");
        BigDecimal useAmt = data.getBigDecimal("useamt");
        BigDecimal preAmt = data.getBigDecimal("preuseamt");
        if (data.getBigDecimal("avaramt").compareTo(BigDecimal.ZERO) < 0) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSaveValidator_11.loadKDString());
        }
        if (isMergeNew) {
            return;
        }
        if (totalAmt.subtract(useAmt).subtract(preAmt).compareTo(BigDecimal.ZERO) < 0) {
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSaveValidator_0.loadKDString());
        }
        DynamicObjectCollection orgEntrys = data.getDynamicObjectCollection("entry_org");
        BigDecimal orgAllAmt = BigDecimal.ZERO;
        for (int i = 0; i < orgEntrys.size(); ++i) {
            BigDecimal orgTotalAmt = ((DynamicObject)orgEntrys.get(i)).getBigDecimal("o_totalamt");
            orgAllAmt = orgAllAmt.add(orgTotalAmt);
            BigDecimal orgSingleAmt = ((DynamicObject)orgEntrys.get(i)).getBigDecimal("o_singleamt");
            BigDecimal orgUseAmt = ((DynamicObject)orgEntrys.get(i)).getBigDecimal("o_useamt");
            BigDecimal orgPreAmt = ((DynamicObject)orgEntrys.get(i)).getBigDecimal("o_preamt");
            if (orgTotalAmt.add(orgSingleAmt).subtract(orgUseAmt).subtract(orgPreAmt).compareTo(BigDecimal.ZERO) >= 0) continue;
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSaveValidator_1.loadKDString(i + 1));
        }
        DynamicObjectCollection typeEntrys = data.getDynamicObjectCollection("entry_type");
        for (int i = 0; i < typeEntrys.size(); ++i) {
            BigDecimal typeTotalAmt = ((DynamicObject)typeEntrys.get(i)).getBigDecimal("t_totalamt");
            BigDecimal typeSingleAmt = ((DynamicObject)typeEntrys.get(i)).getBigDecimal("t_singleamt");
            BigDecimal typeUseAmt = ((DynamicObject)typeEntrys.get(i)).getBigDecimal("t_useamt");
            BigDecimal typePreAmt = ((DynamicObject)typeEntrys.get(i)).getBigDecimal("t_preamt");
            if (typeTotalAmt.add(typeSingleAmt).subtract(typeUseAmt).subtract(typePreAmt).compareTo(BigDecimal.ZERO) >= 0) continue;
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSaveValidator_2.loadKDString(i + 1));
        }
        DynamicObjectCollection multEntrys = data.getDynamicObjectCollection("entry_mult");
        for (int i = 0; i < multEntrys.size(); ++i) {
            BigDecimal multTotalAmt = ((DynamicObject)multEntrys.get(i)).getBigDecimal("m_totalamt");
            BigDecimal multUseAmt = ((DynamicObject)multEntrys.get(i)).getBigDecimal("m_useamt");
            BigDecimal multPreAmt = ((DynamicObject)multEntrys.get(i)).getBigDecimal("m_preamt");
            if (multTotalAmt.subtract(multUseAmt).subtract(multPreAmt).compareTo(BigDecimal.ZERO) >= 0) continue;
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSaveValidator_3.loadKDString(i + 1));
        }
    }
}

