/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.creditlimit;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.creditm.business.helper.CreditlimitHelper;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("name");
        selector.add("number");
        selector.add("bank");
        selector.add("banktype");
        selector.add("avaramt");
        selector.add("totalamt");
        selector.add("useamt");
        selector.add("startdate");
        selector.add("enddate");
        selector.add("preuseamt");
        selector.add("ismergesrcclose");
        selector.add("orgsharetype");
        selector.add("sourcebillids");
        selector.add("guartype");
        selector.add("entry_org");
        selector.add("creditlmttype_entry");
        selector.add("entry_org.pid");
        selector.add("o_avaramt");
        selector.add("o_totalamt");
        selector.add("o_singleamt");
        selector.add("o_useamt");
        selector.add("o_preamt");
        selector.add("entry_type");
        selector.add("entry_type.pid");
        selector.add("t_avaramt");
        selector.add("t_totalamt");
        selector.add("t_singleamt");
        selector.add("t_useamt");
        selector.add("t_preamt");
        selector.add("entry_mult");
        selector.add("entry_mult.pid");
        selector.add("m_avaramt");
        selector.add("m_totalamt");
        selector.add("m_useamt");
        selector.add("m_preamt");
        selector.add("ismergenew");
        selector.add("ischanging");
        selector.add("creditlimitagree");
        selector.add("entry_type.typeorgin");
        selector.add("ismultcontrol");
        selector.add("entry_gcontract");
        selector.add("entry_gcontract.gcontract");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DynamicObjectCollection orgEntrys;
            DynamicObject data = entity.getDataEntity();
            BigDecimal totalAmt = data.getBigDecimal("totalamt");
            Date startDate = data.getDate("startdate");
            Date endDate = data.getDate("enddate");
            if (EmptyUtil.isEmpty((Object)endDate)) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSaveValidator_4.loadKDString());
            }
            if (EmptyUtil.isNoEmpty((Object)endDate) && endDate.before(startDate)) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_0.loadKDString());
            }
            if (EmptyUtil.isEmpty((BigDecimal)data.getBigDecimal("totalamt"))) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_16.loadKDString());
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)(orgEntrys = data.getDynamicObjectCollection("entry_org")))) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_19.loadKDString());
            }
            HashSet<Long> orgIds = new HashSet<Long>(orgEntrys.size());
            Map parentAmtMap = CreditLimitHelper.getParentAmtMap((DynamicObjectCollection)orgEntrys, (String)"o_totalamt");
            for (int i = 0; i < orgEntrys.size(); ++i) {
                DynamicObject org;
                DynamicObject orgEntry = (DynamicObject)orgEntrys.get(i);
                if (EmptyUtil.isEmpty((Long)orgEntry.getLong("pid"))) {
                    BigDecimal oTotalAmt = orgEntry.getBigDecimal("o_totalamt");
                    BigDecimal oSingleAmt = orgEntry.getBigDecimal("o_singleamt");
                    if (EmptyUtil.isEmpty((BigDecimal)oTotalAmt)) {
                        this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_27.loadKDString(i + 1));
                    }
                    if (oTotalAmt.compareTo(totalAmt) > 0) {
                        this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_11.loadKDString(i + 1, totalAmt));
                    }
                    if (oSingleAmt == null || oSingleAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_22.loadKDString(i + 1));
                    continue;
                }
                BigDecimal entrySingleAmt = orgEntry.getBigDecimal("o_singleamt");
                BigDecimal entryTotalAmt = orgEntry.getBigDecimal("o_totalamt");
                BigDecimal parentAmt = (BigDecimal)parentAmtMap.get(orgEntry.getLong("pid"));
                if (parentAmt != null && entrySingleAmt.compareTo(parentAmt) > 0) {
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_17.loadKDString(i + 1, parentAmt));
                }
                if (entryTotalAmt != null && entryTotalAmt.compareTo(BigDecimal.ZERO) > 0) {
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_20.loadKDString(i + 1));
                }
                if ((org = CreditLimitHelper.getDynFormMultiple((DynamicObject)orgEntry, (String)"o_org")) == null) continue;
                if (orgIds.contains(org.getLong("id"))) {
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_2.loadKDString(i + 1, org.getString("name")));
                    continue;
                }
                orgIds.add(org.getLong("id"));
            }
            DynamicObjectCollection typeEntrys = data.getDynamicObjectCollection("entry_type");
            Map parentTypeAmtMap = CreditLimitHelper.getParentAmtMap((DynamicObjectCollection)typeEntrys, (String)"t_totalamt");
            for (int i = 0; i < typeEntrys.size(); ++i) {
                DynamicObject typeEntry = (DynamicObject)typeEntrys.get(i);
                if (EmptyUtil.isEmpty((Long)typeEntry.getLong("pid"))) {
                    BigDecimal tTotalAmt = typeEntry.getBigDecimal("t_totalamt");
                    BigDecimal tSingleAmt = typeEntry.getBigDecimal("t_singleamt");
                    if (EmptyUtil.isEmpty((BigDecimal)tTotalAmt)) {
                        this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_28.loadKDString(i + 1));
                    }
                    if (tTotalAmt.compareTo(totalAmt) > 0) {
                        this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_18.loadKDString(i + 1, totalAmt));
                    }
                    if (tSingleAmt == null || tSingleAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_23.loadKDString(i + 1));
                    continue;
                }
                BigDecimal entrySingleAmt = typeEntry.getBigDecimal("t_singleamt");
                BigDecimal entryTotalAmt = typeEntry.getBigDecimal("t_totalamt");
                BigDecimal parentAmt = (BigDecimal)parentTypeAmtMap.get(typeEntry.getLong("pid"));
                if (parentAmt != null && entrySingleAmt.compareTo(parentAmt) > 0) {
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_12.loadKDString(i + 1, parentAmt));
                }
                if (entryTotalAmt == null || entryTotalAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_21.loadKDString(i + 1));
            }
            DynamicObjectCollection multEntrys = data.getDynamicObjectCollection("entry_mult");
            boolean isMultCon = data.getBoolean("ismultcontrol");
            if (isMultCon && EmptyUtil.isEmpty((DynamicObjectCollection)multEntrys)) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_1.loadKDString());
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)multEntrys)) {
                long notOrg;
                long notType = multEntrys.stream().filter(o -> EmptyUtil.isEmpty((DynamicObjectCollection)o.getDynamicObjectCollection("m_credittype"))).count();
                if (EmptyUtil.isNoEmpty((Long)notType)) {
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_4.loadKDString());
                }
                if (EmptyUtil.isNoEmpty((Long)(notOrg = multEntrys.stream().filter(o -> EmptyUtil.isEmpty((DynamicObjectCollection)o.getDynamicObjectCollection("m_org"))).count()))) {
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_5.loadKDString());
                }
                Set collOrgIds = CreditLimitHelper.getMultiPorpIds((DynamicObjectCollection)orgEntrys, (String)"o_org");
                Set collTypeIds = CreditLimitHelper.getMultiPorpIds((DynamicObjectCollection)typeEntrys, (String)"t_credittype");
                HashSet<String> orgTypeIds = new HashSet<String>(multEntrys.size());
                for (int i = 0; i < multEntrys.size(); ++i) {
                    String msg;
                    DynamicObject entryObj = (DynamicObject)multEntrys.get(i);
                    BigDecimal mtotalAmt = entryObj.getBigDecimal("m_totalamt");
                    if (mtotalAmt.compareTo(totalAmt) > 0) {
                        this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_14.loadKDString(i + 1));
                    }
                    if (!EmptyUtil.isNoEmpty((String)(msg = CreditlimitHelper.checkOrgType(orgTypeIds, collOrgIds, collTypeIds, entryObj, data.getString("orgsharetype"))))) continue;
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitSubmitValidator_7.loadKDString(i + 1, msg));
                }
            }
            this.checkMergeEntry(entity);
        }
    }

    private void checkMergeEntry(ExtendedDataEntity entity) {
        DynamicObject data = entity.getDataEntity();
        boolean isMerge = data.getBoolean("ismergenew");
        DynamicObjectCollection srcLimits = data.getDynamicObjectCollection("sourcebillids");
        Set<Long> limitIds = srcLimits.stream().filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("fbasedataid"))).map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        if (!isMerge || EmptyUtil.isEmpty(limitIds)) {
            return;
        }
        String res = CreditlimitHelper.checkExistOrgAndType(data, limitIds);
        if (EmptyUtil.isNoEmpty((String)res)) {
            this.addErrorMessage(entity, res);
        }
    }
}

