/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.creditlimit;

import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.business.helper.CreditlimitApplyHelper;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitUnAuditValidator
extends AbstractTmcBizOppValidator {
    private static Log logger = LogFactory.getLog(CreditLimitUnAuditValidator.class);

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity entity : dataEntity) {
            DataSet srcCreditUseDs;
            DataSet creditUseDs;
            DataSet resultDs;
            DataSet notEqualDs;
            Object[] srcCreditLimit;
            String checkMsg;
            DynamicObject data = entity.getDataEntity();
            if (data.getBoolean("isframework")) {
                DynamicObjectCollection limits = QueryServiceHelper.query((String)"cfm_creditlimit", (String)"number,isframework", (QFilter[])new QFilter[]{new QFilter("framework", "in", data.getPkValue())});
                String frameStr = limits.stream().filter(o -> o.getBoolean("isframework")).map(o -> o.getString("number")).collect(Collectors.joining("\u3001"));
                String limitStr = limits.stream().filter(o -> !o.getBoolean("isframework")).map(o -> o.getString("number")).collect(Collectors.joining("\u3001"));
                if (EmptyUtil.isNoEmpty((String)frameStr)) {
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitUnAuditValidator_3.loadKDString(frameStr));
                }
                if (EmptyUtil.isNoEmpty((String)limitStr)) {
                    this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitUnAuditValidator_4.loadKDString(limitStr));
                }
            }
            if (EmptyUtil.isNoEmpty((String)(checkMsg = this.checkCreditSelected(data.getLong("id"))))) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitUnAuditValidator_2.loadKDString(checkMsg));
                continue;
            }
            DynamicObject applyBill = CreditlimitApplyHelper.getCreditLimitApplyBill(data.getLong("id"), 0L);
            if (EmptyUtil.isNoEmpty((DynamicObject)applyBill)) {
                this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitUnAuditValidator_5.loadKDString(applyBill.getString("billno")));
                continue;
            }
            if (!data.getBoolean("ismergenew") || !EmptyUtil.isNoEmpty((Object[])(srcCreditLimit = CreditLimitHelper.getMergeSrcCredit((DynamicObject)data))) || (notEqualDs = (resultDs = (creditUseDs = this.getCreditUseDs(data.getLong("id"), true)).fullJoin(srcCreditUseDs = this.getCreditUseDs(srcCreditLimit[0].getLong("id"), false)).on("sourcebillentryid", "sourcebillentryid").on("sourcebillid", "sourcebillid").select(new String[]{"realamt", "sourcebillno"}, new String[]{"realamt srcrealamt", "sourcebillno srcbillno"}).finish()).filter("realamt!=srcrealamt").select("case when sourcebillno=null then srcbillno else sourcebillno end sourcebillno")).isEmpty()) continue;
            StringBuilder souceBillNo = new StringBuilder(128);
            for (Row notEqualD : notEqualDs) {
                souceBillNo.append(notEqualD.getString("sourcebillno")).append("\u3001");
            }
            String billNos = "";
            if (souceBillNo.length() > 0) {
                billNos = souceBillNo.substring(0, souceBillNo.length() - 1);
            }
            this.addErrorMessage(entity, CreditmBusResourceEnum.CreditLimitUnAuditValidator_1.loadKDString(billNos));
        }
    }

    private String checkCreditSelected(long credtitLimitId) {
        String entityName = "";
        DynamicObjectCollection credtiUses = QueryServiceHelper.query((String)"cfm_credituse", (String)"sourcebillid,sourcetype", (QFilter[])new QFilter[]{new QFilter("creditlimit", "=", (Object)credtitLimitId).and("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()).and("iscopy", "=", (Object)"0")});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)credtiUses)) {
            Map creditMap = credtiUses.stream().collect(Collectors.groupingBy(o -> o.getString("sourcetype"), Collectors.mapping(o -> o.getLong("sourcebillid"), Collectors.toList())));
            for (Map.Entry credit : creditMap.entrySet()) {
                QFilter filter = new QFilter("id", "in", credit.getValue());
                if ("cfm_use_credit".equals(credit.getKey())) {
                    filter = new QFilter("bindid", "in", credit.getValue().stream().map(String::valueOf).collect(Collectors.toSet()));
                }
                try {
                    DynamicObject bizBill = TmcDataServiceHelper.loadSingle((String)credit.getKey(), (String)"id,billno", (QFilter[])new QFilter[]{filter});
                    if (!EmptyUtil.isNoEmpty((DynamicObject)bizBill)) continue;
                    entityName = bizBill.getDataEntityType().getDisplayName().getLocaleValue();
                    if (!bizBill.getDataEntityType().getProperties().containsKey((Object)"billno")) break;
                    entityName = String.join((CharSequence)"", entityName, "/", bizBill.getString("billno"));
                    break;
                }
                catch (Exception e) {
                    entityName = credit.getKey();
                    logger.error((Throwable)e);
                }
            }
        }
        return entityName;
    }

    private DataSet getCreditUseDs(Long creditlimitId, boolean isMerge) {
        QFilter filter = new QFilter("creditlimit", "=", (Object)creditlimitId).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        if (isMerge) {
            filter.and(new QFilter("iscopy", "=", (Object)"1"));
        }
        DataSet creditUseDs = QueryServiceHelper.queryDataSet((String)"getCreditUseDs", (String)"cfm_credituse", (String)"sourcebillno,sourcebillentryid,sourcebillid,realamt", (QFilter[])new QFilter[]{filter}, null);
        return creditUseDs;
    }
}

