/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.credituse;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class CredituseUpdateLimitValidate
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("creditlimit");
        selector.add("amount");
        selector.add("preamount");
        selector.add("realamt");
        selector.add("returnamt");
        selector.add("returnentry");
        selector.add("returnentry.e_amount");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject limit = data.getDataEntity();
            if (limit.getBigDecimal("amount").compareTo(BigDecimal.ZERO) > 0 && limit.getBigDecimal("preamount").compareTo(BigDecimal.ZERO) > 0) {
                this.addErrorMessage(data, CreditmBusResourceEnum.CredituseUpdateLimitValidate_2.loadKDString());
                continue;
            }
            if (limit.getBigDecimal("amount").add(limit.getBigDecimal("preamount")).compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(data, CreditmBusResourceEnum.CredituseUpdateLimitValidate_1.loadKDString());
                continue;
            }
            this.addWarningMessage(data, CreditmBusResourceEnum.CredituseUpdateLimitValidate_0.loadKDString());
        }
    }
}

