/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.usecredit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.enums.UseCreditChangeTypeEnum;
import kd.tmc.creditm.common.helper.CreditmValidateFrameHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UseCreditAuditLimitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bindid");
        selector.add("rootid");
        selector.add("changetype");
        selector.add("bizbilltype");
        selector.add("uniquecode");
        selector.add("businesscode");
        selector.add("contractno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        List entrys = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity()).filter(o -> UseCreditChangeTypeEnum.LOCK.getValue().equals(o.getString("changetype"))).filter(o -> "cfm_creditlimit".equals(o.getString("bizbilltype"))).filter(o -> EmptyUtil.isNoEmpty((String)o.getString("bindid"))).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("contractno"))).collect(Collectors.toList());
        Object[] limitIds = entrys.stream().map(o -> Long.parseLong(o.getString("bindid"))).toArray();
        Object[] frameWorks = entrys.stream().map(o -> o.getDynamicObject("contractno").getLong("id")).toArray();
        Map limitMaps = new HashMap();
        if (limitIds.length > 0) {
            limitMaps = TmcDataServiceHelper.loadFromCache((Object[])limitIds, (String)"cfm_creditlimit");
        }
        Map frameMaps = new HashMap();
        if (frameWorks.length > 0) {
            frameMaps = TmcDataServiceHelper.loadFromCache((Object[])frameWorks, (String)"creditm_limit_framework");
        }
        for (ExtendedDataEntity dataEntityex : this.dataEntities) {
            DynamicObject dataEntity = dataEntityex.getDataEntity();
            String changeType = dataEntity.getString("changetype");
            if (!UseCreditChangeTypeEnum.LOCK.getValue().equals(changeType) || !"cfm_creditlimit".equals(dataEntity.getString("bizbilltype")) || EmptyUtil.isEmpty((String)dataEntity.getString("bindid")) || EmptyUtil.isEmpty((DynamicObject)dataEntity.getDynamicObject("contractno"))) continue;
            String bindId = dataEntity.getString("bindid");
            DynamicObject creditLimit = dataEntity.getDynamicObject("contractno");
            List checkMsgs = CreditmValidateFrameHelper.checkLimitFrame((DynamicObject)((DynamicObject)limitMaps.get(Long.parseLong(bindId))), (DynamicObject)((DynamicObject)frameMaps.get(creditLimit.getPkValue())));
            for (String checkMsg : checkMsgs) {
                this.addErrorMessage(dataEntityex, CreditmBusResourceEnum.UseCreditAuditLimitValidator_0.loadKDString(dataEntity.getString("businesscode")) + checkMsg);
            }
        }
    }
}

