/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.usecredit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.enums.UseCreditChangeTypeEnum;
import kd.tmc.creditm.common.helper.UseCreditHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class UseCreditAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("bindid");
        selector.add("rootid");
        selector.add("org");
        selector.add("changetype");
        selector.add("bizbilltype");
        selector.add("businesscode");
        selector.add("uniquecode");
        selector.add("releaseamount");
        selector.add("bizentryid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Set creditBindIds = Arrays.stream(extendedDataEntities).map(o -> o.getDataEntity().getLong("rootid")).collect(Collectors.toSet());
        Map creditAmtMap = UseCreditHelper.getCreditAmtMap(creditBindIds);
        for (ExtendedDataEntity exDataEntity : extendedDataEntities) {
            boolean isLegal;
            DynamicObject dataEntity = exDataEntity.getDataEntity();
            String changeType = dataEntity.getString("changetype");
            String businessCode = dataEntity.getString("businesscode");
            if (UseCreditChangeTypeEnum.LOCK.getValue().equals(changeType) && StringUtils.isNotEmpty((CharSequence)businessCode) && !(isLegal = UseCreditHelper.checkbillisLegal((DynamicObject)dataEntity.getDynamicObject("org"), (String)dataEntity.getString("bizbilltype"), (Long)dataEntity.getLong("bindid"), (long)dataEntity.getLong("bizentryid")))) {
                DynamicObject finOrg = dataEntity.getDynamicObject("finorginfo");
                this.addErrorMessage(exDataEntity, EmptyUtil.isEmpty((Long)dataEntity.getLong("bizentryid")) ? CreditmBusResourceEnum.UseCreditSaveValidator_4.loadKDString(businessCode) : CreditmBusResourceEnum.UseCreditSaveValidator_11.loadKDString(businessCode, finOrg != null ? finOrg.getString("name") : ""));
                return;
            }
            if (!UseCreditChangeTypeEnum.RELEASE.getValue().equals(changeType)) continue;
            long rootId = dataEntity.getLong("rootid");
            if (((BigDecimal)creditAmtMap.get(rootId)).compareTo(dataEntity.getBigDecimal("releaseamount")) < 0) {
                this.addErrorMessage(exDataEntity, CreditmBusResourceEnum.UseCreditSubmitValidator_6.loadKDString(dataEntity.getString("businesscode"), creditAmtMap.get(rootId), dataEntity.getBigDecimal("releaseamount")));
                continue;
            }
            creditAmtMap.put(rootId, ((BigDecimal)creditAmtMap.get(rootId)).subtract(dataEntity.getBigDecimal("releaseamount")));
        }
    }
}

