/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.usecredit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.enums.CreditPropEnum;
import kd.tmc.creditm.common.enums.UseCreditChangeTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class UseCreditAutoReleaseValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("changetype");
        selector.add("bizbilltype");
        selector.add("businesscode");
        selector.add("creditamount");
        selector.add("amountreleased");
        selector.add("contractno");
        selector.add("expiredate");
        selector.add("rootid");
        selector.add(String.join((CharSequence)".", "contractno", "enddate"));
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity exDataEntity : extendedDataEntities) {
            DynamicObjectCollection useCredits;
            DynamicObject contractNo;
            DynamicObject dataEntity = exDataEntity.getDataEntity();
            String changeType = dataEntity.getString("changetype");
            String businessCode = dataEntity.getString("businesscode");
            if (dataEntity.getBigDecimal("businessamount").subtract(dataEntity.getBigDecimal("amountreleased")).compareTo(BigDecimal.ZERO) <= 0) {
                this.addErrorMessage(exDataEntity, CreditmBusResourceEnum.UseCreditAutoReleaseValidator_6.loadKDString(businessCode));
            }
            if (!StringUtils.equals((CharSequence)changeType, (CharSequence)UseCreditChangeTypeEnum.LOCK.getValue())) {
                this.addErrorMessage(exDataEntity, CreditmBusResourceEnum.UseCreditAutoReleaseValidator_0.loadKDString(businessCode));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)(contractNo = dataEntity.getDynamicObject("contractno"))) && StringUtils.equals((CharSequence)contractNo.getString("creditprop"), (CharSequence)CreditPropEnum.FIX.getValue())) {
                this.addErrorMessage(exDataEntity, CreditmBusResourceEnum.UseCreditAutoReleaseValidator_1.loadKDString(businessCode));
            }
            if (!StringUtils.equals((CharSequence)dataEntity.getString("bizbilltype"), (CharSequence)"other")) {
                this.addErrorMessage(exDataEntity, CreditmBusResourceEnum.UseCreditAutoReleaseValidator_2.loadKDString(businessCode));
            }
            if (!StringUtils.equals((CharSequence)dataEntity.getString("billstatus"), (CharSequence)BillStatusEnum.AUDIT.getValue())) {
                this.addErrorMessage(exDataEntity, CreditmBusResourceEnum.UseCreditAutoReleaseValidator_3.loadKDString(businessCode));
            }
            if (dataEntity.getBigDecimal("creditamount").compareTo(dataEntity.getBigDecimal("amountreleased")) < 0) {
                this.addErrorMessage(exDataEntity, CreditmBusResourceEnum.UseCreditAutoReleaseValidator_4.loadKDString(businessCode));
            }
            if (dataEntity.getDate("expiredate").compareTo(DateUtils.getCurrentDate()) > 0) {
                this.addErrorMessage(exDataEntity, CreditmBusResourceEnum.UseCreditAutoReleaseValidator_5.loadKDString(businessCode));
            }
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)(useCredits = QueryServiceHelper.query((String)"cfm_use_credit", (String)"billno", (QFilter[])new QFilter[]{new QFilter("rootid", "=", (Object)dataEntity.getString("id")).and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue())})))) continue;
            String billNos = useCredits.stream().map(o -> o.getString("billno")).collect(Collectors.joining("\u3001"));
            this.addErrorMessage(exDataEntity, CreditmBusResourceEnum.UseCreditSaveValidator_10.loadKDString(billNos));
        }
    }
}

