/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.usecredit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.business.helper.UseCreditLimitHelper;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.enums.UseCreditChangeTypeEnum;
import kd.tmc.creditm.common.helper.UseCreditHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class UseCreditSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("businesscode");
        sel.add("changetype");
        sel.add("uniquecode");
        sel.add("startdate");
        sel.add("expiredate");
        sel.add("releaseamount");
        sel.add("amountreleased");
        sel.add("businessamount");
        sel.add("creditamount");
        sel.add("bindid");
        sel.add("registrant");
        sel.add("rootid");
        sel.add("bizbilltype");
        sel.add("contractno");
        sel.add("billno");
        sel.add("bizentryid");
        return sel;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        ArrayList<String> businessCodes = new ArrayList<String>();
        ArrayList<String> bindIds = new ArrayList<String>();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            String useCreditBillNos;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String businessCode = dataEntity.getString("businesscode");
            String changeType = dataEntity.getString("changetype");
            String bizType = dataEntity.getString("bizbilltype");
            if ("other".equals(bizType) && businessCodes.contains(businessCode)) {
                this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSaveValidator_0.loadKDString(businessCode));
                continue;
            }
            if (StringUtils.isNotEmpty((CharSequence)businessCode) && UseCreditChangeTypeEnum.isLock((String)changeType)) {
                businessCodes.add(dataEntity.getString("businesscode"));
                if ("other".equals(dataEntity.getString("bizbilltype")) && UseCreditHelper.checkCodeExist((String)businessCode, (String)dataEntity.getString("uniquecode"))) {
                    this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSaveValidator_1.loadKDString(businessCode));
                    continue;
                }
            }
            Date startDate = dataEntity.getDate("startdate");
            Date expireDate = dataEntity.getDate("expiredate");
            if (startDate != null && expireDate != null && startDate.compareTo(expireDate) > 0) {
                this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSaveValidator_2.loadKDString());
                continue;
            }
            this.checkLockValidata(extendedDataEntity, bindIds);
            if (!UseCreditChangeTypeEnum.isRelease((String)changeType) || !EmptyUtil.isNoEmpty((String)(useCreditBillNos = UseCreditLimitHelper.getNotAuditRelease(dataEntity.getString("rootid"), dataEntity.getLong("id"))))) continue;
            this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSaveValidator_10.loadKDString(useCreditBillNos));
        }
    }

    private void checkLockValidata(ExtendedDataEntity extendedDataEntity, List<String> bindIds) {
        BigDecimal bizUseAmt;
        boolean isBind;
        String bizType;
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String changeType = dataEntity.getString("changetype");
        String businessCode = dataEntity.getString("businesscode");
        if (!UseCreditChangeTypeEnum.isLock((String)changeType)) {
            return;
        }
        String checkBillno = UseCreditLimitHelper.checkBindAndEntryID(dataEntity);
        if (EmptyUtil.isNoEmpty((String)checkBillno)) {
            this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSubmitValidator_7.loadKDString(businessCode, checkBillno));
        }
        if (!"other".equals(bizType = dataEntity.getString("bizbilltype"))) {
            return;
        }
        if (bindIds.contains(dataEntity.getString("bindid"))) {
            this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSaveValidator_8.loadKDString());
        }
        if (isBind = QueryServiceHelper.exists((String)"cfm_use_credit", (QFilter[])new QFilter[]{new QFilter("bindid", "=", (Object)dataEntity.getString("bindid")).and("id", "!=", (Object)dataEntity.getLong("id"))})) {
            this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSaveValidator_9.loadKDString(dataEntity.getString("bindid")));
        }
        bindIds.add(dataEntity.getString("bindid"));
        if (EmptyUtil.isEmpty((DynamicObject)dataEntity.getDynamicObject("contractno"))) {
            return;
        }
        BigDecimal bizAmt = dataEntity.getBigDecimal("businessamount");
        if (EmptyUtil.isEmpty((BigDecimal)bizAmt)) {
            this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSaveValidator_6.loadKDString());
        }
        if (EmptyUtil.isEmpty((BigDecimal)(bizUseAmt = dataEntity.getBigDecimal("creditamount")))) {
            this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSaveValidator_7.loadKDString());
        }
    }
}

