/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.usecredit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.business.helper.UseCreditLimitHelper;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.enums.UseCreditChangeTypeEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.creditm.common.helper.UseCreditHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UseCreditSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("startdate");
        selector.add("expiredate");
        selector.add("bizdate");
        selector.add("contractno");
        selector.add("businessamount");
        selector.add("creditamount");
        selector.add("creditrate");
        selector.add("discreditamount");
        selector.add("releaseamount");
        selector.add("rootid");
        selector.add("bindid");
        selector.add("org");
        selector.add("amountreleased");
        selector.add("lockamount");
        selector.add("changetype");
        selector.add("bizbilltype");
        selector.add("businesscode");
        selector.add("uniquecode");
        selector.add("finorginfo");
        selector.add("credittype");
        selector.add("creditproduct");
        selector.add("currency");
        selector.add("creditamount");
        selector.add("registrant");
        selector.add("banktype");
        selector.add("billno");
        selector.add("bizentryid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Set creditBindIds = Arrays.stream(extendedDataEntities).map(o -> o.getDataEntity().getLong("rootid")).collect(Collectors.toSet());
        Map creditAmtMap = UseCreditHelper.getCreditAmtMap(creditBindIds);
        ArrayList<String> businessCodes = new ArrayList<String>();
        HashMap<String, String> bindIdAndEntryIds = new HashMap<String, String>();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            String key;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String businessCode = dataEntity.getString("businesscode");
            String billNo = dataEntity.getString("billno");
            if (EmptyUtil.isEmpty((String)billNo)) {
                billNo = businessCode;
            }
            if (bindIdAndEntryIds.containsKey(key = dataEntity.getString("bindid") + dataEntity.getString("bizentryid"))) {
                if (EmptyUtil.isEmpty((String)dataEntity.getString("billno"))) {
                    this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSubmitValidator_9.loadKDString(billNo, bindIdAndEntryIds.get(key)));
                    continue;
                }
                this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSubmitValidator_8.loadKDString(billNo, bindIdAndEntryIds.get(key)));
                continue;
            }
            bindIdAndEntryIds.put(key, billNo);
            this.checkRelease(extendedDataEntity, creditAmtMap);
            this.checkLock(extendedDataEntity, businessCodes);
            Date startDate = dataEntity.getDate("startdate");
            Date expireDate = dataEntity.getDate("expiredate");
            if ("other".equals(dataEntity.getString("bizbilltype")) && expireDate == null) {
                this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSaveValidator_3.loadKDString());
            }
            if (startDate == null || expireDate == null || startDate.compareTo(expireDate) <= 0) continue;
            this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSaveValidator_2.loadKDString());
        }
    }

    private void checkLock(ExtendedDataEntity extendedDataEntity, List<String> businessCodes) {
        String checkBillno;
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String changeType = dataEntity.getString("changetype");
        String businessCode = dataEntity.getString("businesscode");
        if (!UseCreditChangeTypeEnum.isLock((String)changeType) || EmptyUtil.isEmpty((String)businessCode)) {
            return;
        }
        this.checkSlEntry(extendedDataEntity, businessCodes);
        if ("other".equals(dataEntity.getString("bizbilltype")) && businessCodes.contains(businessCode)) {
            this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSaveValidator_5.loadKDString(businessCode));
            return;
        }
        businessCodes.add(businessCode);
        boolean isLegal = UseCreditHelper.checkbillisLegal((DynamicObject)dataEntity.getDynamicObject("org"), (String)dataEntity.getString("bizbilltype"), (Long)dataEntity.getLong("bindid"), (long)dataEntity.getLong("bizentryid"));
        if (!isLegal) {
            DynamicObject finOrg = dataEntity.getDynamicObject("finorginfo");
            this.addErrorMessage(extendedDataEntity, EmptyUtil.isEmpty((Long)dataEntity.getLong("bizentryid")) ? CreditmBusResourceEnum.UseCreditSaveValidator_4.loadKDString(businessCode) : CreditmBusResourceEnum.UseCreditSaveValidator_11.loadKDString(businessCode, finOrg != null ? finOrg.getString("name") : ""));
        }
        if ("other".equals(dataEntity.getString("bizbilltype")) && UseCreditHelper.checkCodeExist((String)businessCode, (String)dataEntity.getString("uniquecode"))) {
            this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSaveValidator_1.loadKDString(businessCode));
        }
        if (EmptyUtil.isNoEmpty((String)(checkBillno = UseCreditLimitHelper.checkBindAndEntryID(dataEntity)))) {
            this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSubmitValidator_7.loadKDString(businessCode, checkBillno));
        }
    }

    private void checkSlEntry(ExtendedDataEntity extendedDataEntity, List<String> businessCodes) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        if (!"cfm_loanbill_b_l#sl".equals(dataEntity.getString("bizbilltype")) || businessCodes.contains(dataEntity.getString("businesscode"))) {
            return;
        }
        long LoanBillId = dataEntity.getLong("bindid");
        DynamicObject loanBill = QueryServiceHelper.queryOne((String)"cfm_loanbill", (String)"billno,loancontractbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LoanBillId)});
        if (EmptyUtil.isEmpty((DynamicObject)loanBill)) {
            return;
        }
        DynamicObjectCollection creditUses = CreditLimitHelper.queryCreditUses((Long)loanBill.getLong("loancontractbill"), (String)"cfm_loancontractbill", null, (String)"sourcebillno,billstatus");
        long creditUseCount = creditUses.stream().filter(o -> BillStatusEnum.isAudit((String)((DynamicObject)creditUses.get(0)).getString("billstatus"))).count();
        if (creditUseCount > 0L) {
            this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSubmitValidator_10.loadKDString(loanBill.getString("billno"), ((DynamicObject)creditUses.get(0)).getString("sourcebillno")));
        }
    }

    private void checkRelease(ExtendedDataEntity extendedDataEntity, Map<Long, BigDecimal> creditAmtMap) {
        long rootId;
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String changeType = dataEntity.getString("changetype");
        if (!UseCreditChangeTypeEnum.isRelease((String)changeType)) {
            return;
        }
        BigDecimal releaseAmt = dataEntity.getBigDecimal("releaseamount");
        if (BigDecimal.ZERO.compareTo(releaseAmt) >= 0) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u91ca\u653e\u989d\u5ea6\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"UseCreditSubmitValidator_0", (String)"tmc-creditm-business", (Object[])new Object[0]));
            return;
        }
        String useCreditBillNos = UseCreditLimitHelper.getNotAuditRelease(dataEntity.getString("rootid"), dataEntity.getLong("id"));
        if (EmptyUtil.isNoEmpty((String)useCreditBillNos)) {
            this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSaveValidator_10.loadKDString(useCreditBillNos));
        }
        if (creditAmtMap.get(rootId = dataEntity.getLong("rootid")).compareTo(dataEntity.getBigDecimal("releaseamount")) < 0) {
            this.addErrorMessage(extendedDataEntity, CreditmBusResourceEnum.UseCreditSubmitValidator_6.loadKDString(dataEntity.getString("businesscode"), creditAmtMap.get(rootId), dataEntity.getBigDecimal("releaseamount")));
        } else {
            creditAmtMap.put(rootId, creditAmtMap.get(rootId).subtract(dataEntity.getBigDecimal("releaseamount")));
        }
    }
}

