/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.usecredit;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.enums.UseCreditChangeTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class UseCreditUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("changetype");
        sel.add("bizbilltype");
        sel.add("bindid");
        sel.add("releaseamount");
        sel.add("discreditamount");
        sel.add("creditamount");
        sel.add("rootid");
        sel.add("contractno");
        return sel;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            String bizType = data.getString("bizbilltype");
            if (!"other".equals(bizType) && !"cfm_creditlimit".equals(bizType)) {
                this.addErrorMessage(dataEntity, CreditmBusResourceEnum.UseCreditUnAuditValidator_0.loadKDString());
                continue;
            }
            if (!"other".equals(bizType) || !UseCreditChangeTypeEnum.LOCK.getValue().equals(data.getString("changetype"))) continue;
            QFilter qFilter = new QFilter("rootid", "=", (Object)String.valueOf(data.getPkValue())).and(new QFilter("changetype", "=", (Object)UseCreditChangeTypeEnum.RELEASE.getValue()));
            boolean isRelease = TmcDataServiceHelper.exists((String)data.getDataEntityType().getName(), (QFilter[])new QFilter[]{qFilter});
            if (!isRelease) continue;
            this.addErrorMessage(dataEntity, CreditmBusResourceEnum.UseCreditUnAuditValidator_1.loadKDString());
        }
    }
}

