/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.validate.usecredit;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.enums.UseCreditChangeTypeEnum;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class UseCreditUnSubmitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("changetype");
        sel.add("bizbilltype");
        sel.add("bindid");
        return sel;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            if (!"other".equals(data.getString("bizbilltype"))) continue;
            QFilter qFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.SAVE.getValue());
            qFilter.and(new QFilter("rootid", "=", (Object)String.valueOf(data.getPkValue())));
            qFilter.and(new QFilter("changetype", "=", (Object)UseCreditChangeTypeEnum.RELEASE.getValue()));
            DynamicObjectCollection releaseUses = QueryServiceHelper.query((String)data.getDataEntityType().getName(), (String)"billstatus", (QFilter[])qFilter.toArray());
            if (!Objects.equals(data.get("changetype"), UseCreditChangeTypeEnum.LOCK.getValue()) || releaseUses.isEmpty()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u5360\u7528\u5355\u7684\u91ca\u653e\u5355\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"UseCreditUnSubmitValidator_0", (String)"tmc-creditm-business", (Object[])new Object[0]));
        }
    }
}

