/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.mservice.paybill;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbd.common.helper.PushPayBillVerifyHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.paywriteback.AbstractPayBillWriteBackService;
import kd.tmc.fbp.service.paywriteback.PayBillWriteBackParam;

public class Surety2PayBillWriteBackService
extends AbstractPayBillWriteBackService {
    private static final String SURETY_PROP = "id,billno,billstatus,bizstatus,paybill,isfinaccountfrozen,currency,paybill,lockpayamt,initamount,eassrcid";

    protected void doSaveExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, param.getPayBill().getPayBillId(), param.getPayBill().getAmount());
    }

    protected void doSubmitExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, param.getPayBill().getPayBillId(), param.getPayBill().getAmount());
    }

    protected void doDeleteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, null, BigDecimal.ZERO);
    }

    protected void doChargebackExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, null, BigDecimal.ZERO);
    }

    protected void doRenoteExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.updateBizBill(sourceBill, null, BigDecimal.ZERO);
    }

    protected void doSaveValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.addForwardValid(sourceBill);
        super.doSaveValidateExecute(param, sourceBill);
    }

    protected void doSubmitValidateExecute(PayBillWriteBackParam param, DynamicObject sourceBill) {
        this.addForwardValid(sourceBill);
        super.doSubmitValidateExecute(param, sourceBill);
    }

    protected DynamicObject getSourceBill(PayBillWriteBackParam.PayBillInfo payBillInfo) {
        return TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (String)SURETY_PROP, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payBillInfo.getSourceBillId())});
    }

    protected Long getSourceBillCurrencyId(DynamicObject sourceBill) {
        return Optional.ofNullable(sourceBill).map(r -> r.getDynamicObject("currency")).map(r -> r.getLong("id")).orElse(0L);
    }

    protected BigDecimal getSourceBillPayAmount(DynamicObject sourceBill) {
        return Optional.ofNullable(sourceBill.getBigDecimal("initamount")).orElse(BigDecimal.ZERO);
    }

    private void addForwardValid(DynamicObject sourceBill) {
        String msg = PushPayBillVerifyHelper.verifySuretyBill((DynamicObject)sourceBill);
        if (EmptyUtil.isNoEmpty((String)msg)) {
            throw new KDBizException(msg);
        }
    }

    private void updateBizBill(DynamicObject sourceBill, Long payBillId, BigDecimal lockPayAmt) {
        sourceBill.set("paybill", (Object)payBillId);
        sourceBill.set("lockpayamt", (Object)lockPayAmt);
        this.DBTxBizUpdate(sourceBill);
    }
}

