/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.mservice.recbill;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbd.common.helper.PushRecBillVerifyHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.service.recwriteback.AbstractRecBillWriteBackService;
import kd.tmc.fbp.service.recwriteback.RecBillWriteBackParam;

public class SuretySettleInt2RecBillWriteBackService
extends AbstractRecBillWriteBackService {
    private static final String SURETY_SETTLE_INT_PROP = "id,billno,billstatus,currency,ispushrec,recbillno,revenuetype,suretybill.isfinaccountfrozen,actpreinstamt,recbill";

    protected void doSaveExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSaveExecute(param, sourceBill);
        sourceBill.set("ispushrec", (Object)true);
        sourceBill.set("recbillno", (Object)param.getRecBill().getRecBillNo());
        sourceBill.set("recbill", (Object)param.getRecBill().getRecBillId());
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSubmitExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doSubmitExecute(param, sourceBill);
        this.doSaveExecute(param, sourceBill);
    }

    protected void doDeleteExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        super.doDeleteExecute(param, sourceBill);
        sourceBill.set("ispushrec", (Object)false);
        sourceBill.set("recbillno", null);
        sourceBill.set("recbill", null);
        this.DBTxBizUpdate(sourceBill);
    }

    protected void doSaveValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        this.addForwardValid(sourceBill);
        super.doSaveValidateExecute(param, sourceBill);
    }

    protected void doSubmitValidateExecute(RecBillWriteBackParam param, DynamicObject sourceBill) {
        this.addForwardValid(sourceBill);
        super.doSubmitValidateExecute(param, sourceBill);
    }

    protected DynamicObject getSourceBill(RecBillWriteBackParam param) {
        return TmcDataServiceHelper.loadSingle((String)"fbd_surety_settleint", (String)SURETY_SETTLE_INT_PROP, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)param.getRecBill().getSourceBillId())});
    }

    protected Long getSourceBillCurrencyId(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return Optional.ofNullable(sourceBill).map(r -> r.getDynamicObject("currency").getLong("id")).orElse(0L);
    }

    protected BigDecimal getSourceBillRecAmount(RecBillWriteBackParam param, DynamicObject sourceBill) {
        return Optional.ofNullable(sourceBill.getBigDecimal("actpreinstamt")).orElse(BigDecimal.ZERO);
    }

    private void addForwardValid(DynamicObject sourceBill) {
        String msg = PushRecBillVerifyHelper.verifySuretySettleIntBill((DynamicObject)sourceBill);
        if (EmptyUtil.isNoEmpty((String)msg)) {
            throw new KDBizException(msg);
        }
    }
}

