/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.mservice.surety;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.mservice.surety.ISuretyReleaseService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.SuretyBizStatusEnum;
import kd.tmc.fbp.common.helper.CodeRuleHelper;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyReleaseService
implements ISuretyReleaseService {
    private static final String SURETY_RELEASE_PROP = String.join((CharSequence)",", "org", "billno", "billstatus", "bizstatus");

    @Override
    public Map<Long, String> validateBeforeRelease(DynamicObject[] bizBills) {
        DynamicObject bizBillDB;
        HashMap<Long, String> errorMsgMap = new HashMap<Long, String>(2);
        DynamicObject bizBill = bizBills[0];
        Long bizBillId = bizBill.getLong("id");
        String status = SuretyHelper.getBizPropName((String)bizBill.getDataEntityType().getName(), (String)"status");
        if (StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)bizBill.getDataEntityType().getName())) {
            bizBillDB = QueryServiceHelper.queryOne((String)bizBill.getDataEntityType().getName(), (String)String.join((CharSequence)",", status, "isclose"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizBillId)});
            if (!bizBillDB.getBoolean("isclose")) {
                errorMsgMap.put(bizBillId, ResManager.loadKDString((String)"\u6388\u4fe1\u672a\u5173\u95ed\uff0c\u4e0d\u80fd\u5b58\u51fa\u4fdd\u8bc1\u91d1\u3002", (String)"SuretyReleaseService_2", (String)"tmc-fbd-mservice", (Object[])new Object[0]));
                return errorMsgMap;
            }
        } else {
            bizBillDB = QueryServiceHelper.queryOne((String)bizBill.getDataEntityType().getName(), (String)status, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizBillId)});
        }
        if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDIT.getValue(), (CharSequence)bizBillDB.getString(status))) {
            errorMsgMap.put(bizBillId, ResManager.loadKDString((String)"\u5355\u636e\u975e\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5b58\u51fa\u4fdd\u8bc1\u91d1\u3002", (String)"SuretyReleaseService_3", (String)"tmc-fbd-mservice", (Object[])new Object[0]));
            return errorMsgMap;
        }
        DynamicObject surety = this.suretyFromDb(bizBill);
        if (null == surety) {
            errorMsgMap.put(bizBillId, ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u4fdd\u8bc1\u91d1\u975e\u5df2\u5b58\u5165\u3001\u90e8\u5206\u5b58\u51fa\u72b6\u6001\u3002", (String)"SuretyReleaseService_0", (String)"tmc-fbd-mservice", (Object[])new Object[0]));
            return errorMsgMap;
        }
        QFilter qFilter = new QFilter("suretybill", "=", surety.get("id")).and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
        if (TmcDataServiceHelper.exists((String)"fbd_suretyreleasebill", (QFilter[])qFilter.toArray())) {
            errorMsgMap.put(bizBillId, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5b58\u51fa\u5355\uff0c\u8bf7\u5148\u64cd\u4f5c\u524d\u5e8f\u5355\u636e\u3002", (String)"SuretyReleaseService_1", (String)"tmc-fbd-mservice", (Object[])new Object[0]));
            return errorMsgMap;
        }
        return Collections.emptyMap();
    }

    private DynamicObject suretyFromDb(DynamicObject bizBill) {
        if (EmptyUtil.isEmpty((DynamicObject)bizBill)) {
            return null;
        }
        Long bizBillId = bizBill.getLong("id");
        QFilter idFilter = StringUtils.equals((CharSequence)"cfm_creditlimit", (CharSequence)bizBill.getDataEntityType().getName()) ? new QFilter("entry_credit.creditbillid", "=", (Object)bizBillId) : new QFilter("entry.debtbillid", "=", (Object)bizBillId);
        idFilter.and("enable", "=", (Object)true);
        idFilter.and("bizstatus", "in", Arrays.asList(SuretyBizStatusEnum.SURETY_DONE.getValue(), SuretyBizStatusEnum.SURETY_PART.getValue()));
        return QueryServiceHelper.queryOne((String)"fbd_suretybill", (String)"id", (QFilter[])idFilter.toArray());
    }

    @Override
    public void release(DynamicObject[] bizBills) {
        String entityName = bizBills[0].getDataEntityType().getName();
        Long bizId = bizBills[0].getLong("id");
        this.suretyRelease(bizId, entityName);
    }

    private void suretyRelease(Long bizId, String entityName) {
        QFilter qFilter = SuretyHelper.getSuretyEntryFilterWithSave((Long)bizId, (String)entityName);
        Object[] suretyReleases = TmcDataServiceHelper.load((String)"fbd_suretyreleasebill", (String)SURETY_RELEASE_PROP, (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((Object[])suretyReleases)) {
            DynamicObject suretyBill = SuretyHelper.loadSuretyByBizId((Long)bizId, (String)entityName);
            OperateOption create = OperateOption.create();
            create.setVariableValue("suretyReleaseDebtBillIdStr", String.valueOf(bizId));
            TmcOperateServiceHelper.execOperate((String)"pushandsaverelease", (String)"fbd_suretybill", (Object[])new Object[]{suretyBill.getLong("id")}, (OperateOption)create);
        }
        for (Object suretyRelease : suretyReleases) {
            if (!EmptyUtil.isEmpty((String)suretyRelease.getString("billno"))) continue;
            suretyRelease.set("billno", (Object)CodeRuleHelper.generateNumber((String)"fbd_suretyreleasebill", (DynamicObject)suretyRelease, (String)suretyRelease.getDynamicObject("org").getString("id"), (String)""));
        }
        TmcDataServiceHelper.save((DynamicObject[])suretyReleases);
    }
}

