/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.feedetailbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.constant.FeeInfoConstant;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.ShareTypeEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.property.FeeDetailEntryProp;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BatchFeeInputPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final BigDecimal MAX_RATE = new BigDecimal("1000");
    private static final BigDecimal MIN_RATE = new BigDecimal("-1000");
    private static final BigDecimal MAX_FEE = new BigDecimal("9999999999999.9999999999");
    private static final BigDecimal MIN_FEE = new BigDecimal("-9999999999999.9999999999");
    private static Log logger = LogFactory.getLog(BatchFeeInputPlugin.class);
    private static final String SELECTBILLNO_CLOSECALLBACK = "selectbillno_closeCallBack";
    private static final String FEEBILL_CLOSECALLBACK = "feebill_closeCallBack";
    private final Set<String> CDM_TYPESET = Stream.of("cdm_payablebill_ap_manual", "cdm_payablebill", "cdm_payablebill", "cdm_receivablebill", "cdm_drafttradebill", "cdm_payablebill_ap_manual").collect(Collectors.toSet());

    public void registerListener(EventObject e) {
        BasedataEdit feeAcctBank;
        super.registerListener(e);
        TextEdit srcBillNo = (TextEdit)this.getControl("srcbillno");
        srcBillNo.addClickListener((ClickListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        if (EmptyUtil.isNoEmpty((Object)org)) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (EmptyUtil.isNoEmpty((Object)(feeAcctBank = (BasedataEdit)this.getControl("feeacctbank")))) {
            feeAcctBank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        TextEdit feeNumber = (TextEdit)this.getControl("feenumber");
        feeNumber.addClickListener((ClickListener)this);
        BasedataEdit productType = (BasedataEdit)this.getView().getControl("producttype");
        productType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entry = (EntryGrid)this.getControl("entry");
        if (entry != null) {
            entry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String billFormId;
        this.getModel().setValue("batchno", (Object)UUID.randomUUID().toString().replace("-", ""));
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        if (this.getModel().getEntryRowCount("entry") == 0) {
            entry.addNew();
        }
        if (EmptyUtil.isNoEmpty((String)(billFormId = TmcBusinessBaseHelper.getBillFormId((String)((String)this.getView().getFormShowParameter().getCustomParams().get("billFormId")))))) {
            for (ProductTypeEnum productType : this.getBizBillProductTypes()) {
                if (!productType.getFormId().equals(billFormId)) continue;
                this.getModel().setValue("isfrombizbill", (Object)true);
                break;
            }
            this.setSrcBillNo();
        }
        if (!((Boolean)this.getModel().getValue("isfrombizbill")).booleanValue()) {
            this.getModel().setValue("org", (Object)this.getFisBankRollOrg(), 0);
        }
        if (this.checkFormId()) {
            this.setExcRate(0);
        }
    }

    private void setSrcBillNo() {
        if (((Boolean)this.getModel().getValue("isfrombizbill")).booleanValue()) {
            String billFormId = TmcBusinessBaseHelper.getBillFormId((String)((String)this.getView().getFormShowParameter().getCustomParams().get("billFormId")));
            String selectedRowBillNo = (String)this.getView().getFormShowParameter().getCustomParams().get("selectedRowBillNo");
            for (ProductTypeEnum productType : this.getBizBillProductTypes()) {
                if (!productType.getFormId().equals(billFormId)) continue;
                QFilter qFilter = new QFilter("cfm_creditlimit".equals(billFormId) ? "number" : "billno", "=", (Object)selectedRowBillNo);
                DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)productType.getEntity(), (String)"org", (QFilter[])new QFilter[]{qFilter});
                this.getModel().setValue("org", bill.getDynamicObject("org").getPkValue(), this.getModel().getEntryRowCount("entry") - 1);
                this.getModel().setValue("producttype", (Object)productType.getId(), this.getModel().getEntryRowCount("entry") - 1);
                this.visibleShareType();
                break;
            }
            this.getModel().setValue("srcbillno", (Object)selectedRowBillNo, this.getModel().getEntryRowCount("entry") - 1);
        }
    }

    private ProductTypeEnum[] getBizBillProductTypes() {
        return new ProductTypeEnum[]{ProductTypeEnum.LOANBILL_B_L, ProductTypeEnum.LOANBILL_E_L, ProductTypeEnum.LOANBILL_BOND, ProductTypeEnum.LC_ARRIVAL, ProductTypeEnum.LC_LETTER, ProductTypeEnum.LC_APPLY, ProductTypeEnum.LC_RECEIPT, ProductTypeEnum.LC_PRESENT, ProductTypeEnum.LC_FORFAIT, ProductTypeEnum.GM_LETTEROFGUARANTEE, ProductTypeEnum.GM_PLEDGEBILL, ProductTypeEnum.SCF_FIN_DEBTS, ProductTypeEnum.SCF_FIN_CREDIT, ProductTypeEnum.CFM_CREDITLIMIT, ProductTypeEnum.FL_LEASE_CONTRACT_BILL, ProductTypeEnum.GM_GUARANTEECONTRACT};
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "srcbillno": {
                this.showBillF7();
                break;
            }
            case "feenumber": {
                this.selectFeeBill();
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("entry".equals(entryName)) {
            if (((Boolean)this.getModel().getValue("isfrombizbill")).booleanValue()) {
                this.setSrcBillNo();
            }
            boolean isFromBizBill = (Boolean)this.getModel().getValue("isfrombizbill");
            String billFormId = (String)this.getView().getFormShowParameter().getCustomParams().get("billFormId");
            boolean isEnableOrg = EmptyUtil.isNoEmpty((String)billFormId) && ("gm_letterofguarantee".equals(billFormId) || "gm_pledgebill".equals(billFormId));
            for (RowDataEntity row : e.getRowDataEntities()) {
                int index = row.getRowIndex();
                if (this.checkFormId()) {
                    this.setExcRate(index);
                }
                if (!((Boolean)this.getModel().getValue("isfrombizbill")).booleanValue() && index >= 0 && EmptyUtil.isEmpty((Object)this.getModel().getValue("org", index))) {
                    this.getModel().setValue("org", (Object)this.getFisBankRollOrg(), index);
                }
                this.getView().setEnable(Boolean.valueOf(!isFromBizBill || isEnableOrg), index, new String[]{"org"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("batchinputsave".equals(operateKey) && args.getOperationResult().isSuccess()) {
            HashMap<String, Boolean> returnData = new HashMap<String, Boolean>(16);
            returnData.put("OK", true);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(this.checkFormId()), new String[]{"excrate"});
        boolean isFromBizBill = (Boolean)this.getModel().getValue("isfrombizbill");
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParams().get("billFormId");
        boolean isEnableOrg = EmptyUtil.isNoEmpty((String)billFormId) && ("gm_letterofguarantee".equals(billFormId) || "gm_pledgebill".equals(billFormId));
        this.getView().setEnable(Boolean.valueOf(!isFromBizBill || isEnableOrg), 0, new String[]{"org"});
        this.visibleShareType();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex;
        String fieldName = evt.getFieldName();
        if ("srcbillno".equals(fieldName) && (rowIndex = evt.getRowIndex()) > -1) {
            DynamicObject entry = this.getModel().getEntryRowEntity("entry", rowIndex);
            String srcBillNo = entry.getString("srcbillno");
            if (EmptyUtil.isNoEmpty((String)srcBillNo)) {
                String entityName;
                DynamicObject bizBillInfo = TmcDataServiceHelper.loadSingle((String)entityName, (String)"id", (QFilter[])new QFilter("cfm_creditlimit".equals(TmcBusinessBaseHelper.getBillFormId((String)(entityName = ProductTypeEnum.getEnumByValue((String)entry.getDynamicObject("producttype").getString("number")).getEntity()))) ? "number" : "billno", "=", (Object)srcBillNo).toArray());
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(entityName);
                parameter.setPkId(bizBillInfo.getPkValue());
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"FeeDetailBillEdit_5", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void showBillF7() {
        DynamicObjectCollection cdmDraftBillColl;
        DynamicObjectCollection entryEntity;
        Set hasSelectCdmDraftIdSet;
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", this.getModel().getEntryCurrentRowIndex("entry"));
        DynamicObject org = entry.getDynamicObject("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatchFeeInputPlugin_01", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject productType = entry.getDynamicObject("producttype");
        if (EmptyUtil.isEmpty((DynamicObject)productType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatchFeeInputPlugin_02", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        String productTypeNum = productType.getString("number");
        String formId = ProductTypeEnum.getEnumByValue((String)productTypeNum).getFormId();
        boolean isNeedMultiSelect = false;
        if (this.CDM_TYPESET.contains(formId)) {
            isNeedMultiSelect = true;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)formId, (boolean)isNeedMultiSelect, (int)2);
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        lsp.setCustomParam("isframework", (Object)Boolean.FALSE);
        QFilter showBillF7QFilter = TmcBusinessBaseHelper.getOrgFilter((String)productType.getString("number"));
        QFilter extendQFilter = this.getLoanTypesFilterByFormId(formId);
        if (EmptyUtil.isNoEmpty((Object)extendQFilter)) {
            showBillF7QFilter.and(extendQFilter);
        }
        if (this.CDM_TYPESET.contains(formId) && EmptyUtil.isNoEmpty(hasSelectCdmDraftIdSet = (entryEntity = this.getModel().getEntryEntity("entry")).stream().filter(e -> null != e.getDynamicObject("producttype") && productTypeNum.equals(e.getDynamicObject("producttype").getString("number")) && EmptyUtil.isNoEmpty((String)e.getString("srcbillno"))).map(e -> e.getString("srcbillno")).collect(Collectors.toSet())) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(cdmDraftBillColl = QueryServiceHelper.query((String)formId, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "in", hasSelectCdmDraftIdSet)})))) {
            Set draftBillIDSet = cdmDraftBillColl.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            showBillF7QFilter.and(new QFilter("id", "not in", draftBillIDSet));
        }
        lsp.getListFilterParameter().getQFilters().add(showBillF7QFilter);
        logger.info("show\u7684\u5355\u636e\u5e03\u5c40\u662f" + formId + "\u8fc7\u6ee4\u6761\u4ef6\u662f:" + lsp.getListFilterParameter().getQFilters());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECTBILLNO_CLOSECALLBACK);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private QFilter getLoanTypesFilterByFormId(String formId) {
        if (formId.startsWith("cfm_")) {
            switch (formId) {
                case "cfm_loancontract_bl_l": 
                case "cfm_loanbill_b_l": {
                    return new QFilter("loantype", "in", Arrays.asList("loan", "sl"));
                }
                case "cfm_loancontract_ic_l": 
                case "cfm_loanbill_e_l": {
                    return new QFilter("loantype", "in", Arrays.asList("ec", "entrust"));
                }
                case "cfm_loancontract_bo": 
                case "cfm_loanbill_bond": {
                    return new QFilter("loantype", "=", (Object)"bond");
                }
            }
        }
        if ("gm_letterofguarantee".equals(formId)) {
            return new QFilter("bizstatus", "!=", (Object)"cancelled");
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (!EmptyUtil.isEmpty((Object)returnData)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            switch (actionId) {
                case "selectbillno_closeCallBack": {
                    int currRow = this.getModel().getEntryCurrentRowIndex("entry");
                    DynamicObject entry = this.getModel().getEntryRowEntity("entry", currRow);
                    String formId = ProductTypeEnum.getEnumByValue((String)entry.getDynamicObject("producttype").getString("number")).getEntity();
                    int size = selectedRows.size();
                    if (size > 1) {
                        if (!this.CDM_TYPESET.contains(formId)) break;
                        this.selectBatchCdmBillNoCloseCallBack(selectedRows);
                        break;
                    }
                    if (size != 1) break;
                    this.selectBillNoCloseCallBack(selectedRows.get(0));
                    break;
                }
                case "feebill_closeCallBack": {
                    this.feeBillCloseCallBack(selectedRows.get(0));
                }
            }
        }
    }

    private void selectBatchCdmBillNoCloseCallBack(ListSelectedRowCollection listSelectedRows) {
        int currRow = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", currRow);
        Set draftIdSet = listSelectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        DynamicObject productype = entry.getDynamicObject("producttype");
        String entityName = ProductTypeEnum.getEnumByValue((String)productype.getString("number")).getEntity();
        DynamicObjectCollection cdmDraftsColl = QueryServiceHelper.query((String)entityName, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", draftIdSet)});
        Set cdmDraftsBillnoSet = cdmDraftsColl.stream().map(e -> e.getString("billno")).collect(Collectors.toSet());
        String cdmDraftId = entry.getString("srcbillno");
        if (EmptyUtil.isEmpty((String)cdmDraftId) || !cdmDraftsBillnoSet.contains(cdmDraftId)) {
            DynamicObject cdmDraftFirst = (DynamicObject)cdmDraftsColl.get(0);
            this.getModel().setValue("srcbillno", (Object)cdmDraftFirst.getString("billno"), currRow);
            cdmDraftsColl.removeIf(e -> cdmDraftFirst.getString("billno").equals(e.getString("billno")));
        } else {
            cdmDraftsColl.removeIf(e -> cdmDraftId.equals(e.getString("billno")));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cdmDraftsColl)) {
            for (DynamicObject cdmDraft : cdmDraftsColl) {
                int rowIndex = this.getModel().createNewEntryRow("entry");
                this.getModel().setValue("producttype", (Object)productype.getLong("id"), rowIndex);
                this.getModel().setValue("srcbillno", (Object)cdmDraft.getString("billno"), rowIndex);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        if ("feeacctbank".equals(propName)) {
            this.initAcctBankF7(evt);
        }
        if ("producttype".equals(propName)) {
            this.productTypeF7Evt(evt);
        }
        if ("org".equals(propName)) {
            this.orgF7Evt(evt);
        }
    }

    private void productTypeF7Evt(BeforeF7SelectEvent evt) {
        QFilter qFilter = new QFilter("enable", "in", (Object)Boolean.TRUE);
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParams().get("billFormId");
        if (billFormId == null) {
            return;
        }
        ArrayList<Long> productTypeIds = new ArrayList<Long>(10);
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        String shareType = (String)this.getModel().getValue("sharetype", entryCurrentRowIndex);
        switch (billFormId) {
            case "cfm_feebill": {
                List<Long> typeIds = TmcBusinessBaseHelper.getProductTypeId((String)"cfm", (String)billFormId);
                if (!ShareTypeEnum.NOTSHARE.getValue().equals(shareType)) {
                    typeIds = Collections.singletonList(Long.valueOf(ProductTypeEnum.LOANBILL_B_L.getId()));
                }
                productTypeIds.addAll(typeIds);
                break;
            }
            case "bdim_feebill": {
                List<Long> typeIds = TmcBusinessBaseHelper.getProductTypeId((String)"bdim", (String)billFormId);
                if (!ShareTypeEnum.NOTSHARE.getValue().equals(shareType)) {
                    typeIds = Collections.singletonList(Long.valueOf(ProductTypeEnum.LOANBILL_BOND.getId()));
                }
                productTypeIds.addAll(typeIds);
                break;
            }
            case "cdm_feebill": {
                productTypeIds.addAll(TmcBusinessBaseHelper.getProductTypeId((String)"cdm", (String)billFormId));
                break;
            }
            case "lc_feebill": {
                productTypeIds.addAll(TmcBusinessBaseHelper.getProductTypeId((String)"lc", (String)billFormId));
                break;
            }
            case "gm_feebill": 
            case "gm_pledgefeebill": 
            case "gm_contractfeebill": {
                productTypeIds.addAll(TmcBusinessBaseHelper.getProductTypeId((String)"gm", (String)billFormId));
                break;
            }
            case "am_feebill": {
                productTypeIds.addAll(TmcBusinessBaseHelper.getProductTypeId((String)"am", (String)billFormId));
                break;
            }
            case "scf_feebill": {
                productTypeIds.addAll(TmcBusinessBaseHelper.getProductTypeId((String)"scf", (String)billFormId));
                break;
            }
            case "creditm_feebill": {
                productTypeIds.addAll(TmcBusinessBaseHelper.getProductTypeId((String)"creditm", (String)billFormId));
                break;
            }
            case "fl_feebill": {
                productTypeIds.addAll(TmcBusinessBaseHelper.getProductTypeId((String)"fl", (String)billFormId));
                break;
            }
        }
        if (EmptyUtil.isNoEmpty(productTypeIds)) {
            qFilter.and(new QFilter("id", "in", productTypeIds));
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        int rowIndex = e.getRowIndex();
        switch (key) {
            case "payamt": {
                if (!EmptyUtil.isNoEmpty((Object)value)) break;
                this.checkCurrency(e, key, rowIndex);
                this.checkAmtChgEvt(e, key, rowIndex, value);
                break;
            }
            case "rate": {
                if (!EmptyUtil.isNoEmpty((Object)value)) break;
                this.checkCurrency(e, key, rowIndex);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        Object newVal = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propName = e.getProperty().getName()) {
            case "org": {
                this.getModel().setValue("feeacctbank", null, rowIndex);
                break;
            }
            case "producttype": {
                this.getModel().setValue("srcbillno", null, rowIndex);
                break;
            }
            case "payamt": {
                this.setRate(e);
                break;
            }
            case "rate": {
                this.setFee(e);
                break;
            }
            case "srcbillno": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"rate", (Object)BigDecimal.ZERO, (int)rowIndex);
                if (this.checkFormId()) {
                    this.setExcRate(rowIndex);
                }
                this.setRate(e);
                break;
            }
            case "feenumber": {
                this.numberChgEvt(rowIndex, (String)newVal);
                break;
            }
            case "currency": {
                if (EmptyUtil.isEmpty((Object)newVal)) {
                    this.getModel().setValue("excrate", (Object)BigDecimal.ONE, rowIndex);
                    break;
                }
                if (!this.checkFormId()) break;
                this.setExcRate(rowIndex);
                break;
            }
            case "excrate": {
                this.setRate(e);
            }
        }
    }

    private void setRate(PropertyChangedArgs e) {
        BigDecimal feeAmount;
        String srcBillNo;
        DynamicObject productType = (DynamicObject)this.getModel().getValue("producttype");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{productType, srcBillNo = (String)this.getModel().getValue("srcbillno"), feeAmount = (BigDecimal)this.getModel().getValue("payamt")})) {
            return;
        }
        String productTypeId = String.valueOf(productType.get("id"));
        String amountKey = (String)FeeInfoConstant.formIdAmtKeyMap.get(productTypeId);
        if (EmptyUtil.isEmpty((String)amountKey)) {
            return;
        }
        BigDecimal excRate = (BigDecimal)this.getModel().getValue("excrate", e.getChangeSet()[0].getRowIndex());
        if (EmptyUtil.isEmpty((BigDecimal)excRate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u4fe1\u606f\u4e2d\u7684\u6298\u503a\u52a1\u5e01\u79cd\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatchFeeInputPlugin_04", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityName = ProductTypeEnum.getEnumById((String)productTypeId).getEntity();
        DynamicObject srcBill = QueryServiceHelper.queryOne((String)entityName, (String)amountKey, (QFilter[])new QFilter[]{new QFilter("cfm_creditlimit".equals(entityName) ? "number" : "billno", "=", (Object)srcBillNo)});
        BigDecimal amount = srcBill.getBigDecimal(amountKey);
        if (EmptyUtil.isNoEmpty((BigDecimal)amount)) {
            BigDecimal rate = feeAmount.multiply(excRate).multiply(Constants.ONE_HUNDRED).divide(amount, 10, RoundingMode.HALF_UP);
            if (MIN_RATE.compareTo(rate) > 0 || MAX_RATE.compareTo(rate) < 0) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8d39\u7528\u91d1\u989d\u8d85\u51fa\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u201c%s\u201d\u3002", (String)"BatchFeeInputPlugin_03", (String)"tmc-fbd-formplugin", (Object[])new Object[]{this.getModel().getProperty(e.getProperty().getName()).getDisplayName()}));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payamt", (Object)e.getChangeSet()[0].getOldValue(), (int)this.getModel().getEntryCurrentRowIndex("entry"));
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"rate", (Object)rate, (int)this.getModel().getEntryCurrentRowIndex("entry"));
            }
        }
    }

    private void setFee(PropertyChangedArgs e) {
        BigDecimal rate;
        String srcBillNo;
        DynamicObject productType = (DynamicObject)this.getModel().getValue("producttype");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{productType, srcBillNo = (String)this.getModel().getValue("srcbillno"), rate = (BigDecimal)this.getModel().getValue("rate")})) {
            return;
        }
        String productTypeId = String.valueOf(productType.get("id"));
        String amountKey = (String)FeeInfoConstant.formIdAmtKeyMap.get(productTypeId);
        if (EmptyUtil.isEmpty((String)amountKey)) {
            return;
        }
        BigDecimal excRate = (BigDecimal)this.getModel().getValue("excrate", e.getChangeSet()[0].getRowIndex());
        if (EmptyUtil.isEmpty((BigDecimal)excRate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u4fe1\u606f\u4e2d\u7684\u6298\u503a\u52a1\u5e01\u79cd\u6c47\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatchFeeInputPlugin_04", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityName = ProductTypeEnum.getEnumById((String)productTypeId).getEntity();
        DynamicObject srcBill = QueryServiceHelper.queryOne((String)entityName, (String)amountKey, (QFilter[])new QFilter[]{new QFilter("cfm_creditlimit".equals(entityName) ? "number" : "billno", "=", (Object)srcBillNo)});
        BigDecimal amount = srcBill.getBigDecimal(amountKey);
        if (EmptyUtil.isNoEmpty((BigDecimal)amount)) {
            BigDecimal fee = amount.multiply(rate).divide(excRate, 10, RoundingMode.HALF_UP).divide(Constants.ONE_HUNDRED, 10, RoundingMode.HALF_UP);
            if (MIN_FEE.compareTo(fee) > 0 || MAX_FEE.compareTo(fee) < 0) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8d39\u7528\u91d1\u989d\u8d85\u51fa\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u201c%s\u201d\u3002", (String)"BatchFeeInputPlugin_03", (String)"tmc-fbd-formplugin", (Object[])new Object[]{this.getModel().getProperty(e.getProperty().getName()).getDisplayName()}));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"rate", (Object)e.getChangeSet()[0].getOldValue(), (int)this.getModel().getEntryCurrentRowIndex("entry"));
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payamt", (Object)fee, (int)this.getModel().getEntryCurrentRowIndex("entry"));
            }
        }
    }

    private void selectBillNoCloseCallBack(ListSelectedRow listSelectedRow) {
        int currRow = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", currRow);
        Object pkId = listSelectedRow.getPrimaryKeyValue();
        String entityName = ProductTypeEnum.getEnumByValue((String)entry.getDynamicObject("producttype").getString("number")).getEntity();
        DynamicObject bizBill = TmcDataServiceHelper.loadSingle((Object)pkId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", currRow);
        if (EmptyUtil.isEmpty((DynamicObject)currency) && this.checkFormId()) {
            String currencyStr = (String)FeeInfoConstant.formIdCurrencyKeyMap.get(entityName);
            this.getModel().setValue("currency", (Object)bizBill.getDynamicObject(currencyStr), currRow);
        }
        this.getModel().setValue("srcbillno", (Object)bizBill.getString("cfm_creditlimit".equals(entityName) ? "number" : "billno"), currRow);
    }

    private void initAcctBankF7(BeforeF7SelectEvent evt) {
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", this.getModel().getEntryCurrentRowIndex("entry"));
        DynamicObject org = entry.getDynamicObject("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org)) {
            long orgId = Long.parseLong(org.getPkValue().toString());
            QFilter qFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId).and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatchFeeInputPlugin_01", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void orgF7Evt(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParams().get("billFormId");
        if ("gm_letterofguarantee".equals(billFormId)) {
            String srcBillNo = (String)this.getModel().getValue("srcbillno", evt.getRow());
            DynamicObject bill = TmcDataServiceHelper.loadSingle((String)"gm_letterofguarantee", (String)"applyorg,org", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)srcBillNo)});
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", Arrays.asList(bill.getDynamicObject("applyorg").getPkValue(), bill.getDynamicObject("org").getPkValue())));
        } else if ("gm_pledgebill".equals(billFormId)) {
            String srcBillNo = (String)this.getModel().getValue("srcbillno", evt.getRow());
            DynamicObject bill = TmcDataServiceHelper.loadSingle((String)"gm_pledgebill", (String)"realright,realrightpersonid,org", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)srcBillNo)});
            List<Object> authorizedAccountLegalOrgId = Collections.singletonList(bill.getDynamicObject("org").getPkValue());
            if ("tmc_org".equals(bill.getString("realright"))) {
                authorizedAccountLegalOrgId = Arrays.asList(bill.get("realrightpersonid"), bill.getDynamicObject("org").getPkValue());
            }
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", authorizedAccountLegalOrgId));
        } else {
            String appId = this.getView().getFormShowParameter().getAppId();
            List authorizedAccountLegalOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"cfm_feebill", (String)"47150e89000000ac");
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)authorizedAccountLegalOrgId));
        }
    }

    private void checkAmtChgEvt(BeforeFieldPostBackEvent e, String key, int rowIndex, Object value) {
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("feenumber", rowIndex))) {
            BigDecimal newValue = new BigDecimal(value.toString());
            DynamicObject feeBill = TmcDataServiceHelper.loadSingle((Object)this.getModel().getValue("feebillid", rowIndex), (String)"cfm_feebill", (String)"enpayamt,billno");
            BigDecimal enPayAmt = feeBill.getBigDecimal("enpayamt");
            if (enPayAmt.compareTo(BigDecimal.ZERO) < 0 && newValue.compareTo(BigDecimal.ZERO) > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u8d39\u7528\u660e\u7ec6[%s]\u7684\u8d39\u7528\u91d1\u989d\u4e3a\u8d1f\u6570\uff0c\u5f55\u5165\u7684\u8d39\u7528\u91d1\u989d\u5e94\u4e3a\u8d1f\u6570\u3002", (String)"BatchFeeInputPlugin_05", (String)"tmc-fbd-formplugin", (Object[])new Object[0]), feeBill.getString("billno")));
                e.setCancel(true);
            }
            if (enPayAmt.compareTo(BigDecimal.ZERO) > 0 && newValue.compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u8d39\u7528\u660e\u7ec6[%s]\u7684\u8d39\u7528\u91d1\u989d\u4e3a\u6b63\u6570\uff0c\u5f55\u5165\u7684\u8d39\u7528\u91d1\u989d\u5e94\u4e3a\u6b63\u6570\u3002", (String)"BatchFeeInputPlugin_06", (String)"tmc-fbd-formplugin", (Object[])new Object[0]), feeBill.getString("billno")));
                e.setCancel(true);
            }
            if (newValue.abs().compareTo(enPayAmt.abs()) > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u8d39\u7528\u91d1\u989d\u8d85\u8fc7\u5173\u8054\u7684\u8d39\u7528\u660e\u7ec6[%s]\u7684\u5269\u4f59\u8d39\u7528\u91d1\u989d\u3002", (String)"BatchFeeInputPlugin_07", (String)"tmc-fbd-formplugin", (Object[])new Object[0]), feeBill.getString("billno")));
                e.setCancel(true);
            }
            this.getView().updateView(key, rowIndex);
        }
    }

    private void numberChgEvt(int rowIndex, String newValue) {
        if (EmptyUtil.isEmpty((String)newValue)) {
            IDataModel mode = this.getModel();
            IFormView view = this.getView();
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feenumber", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"paydate", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feetype", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"currency", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"rate", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feeacctbank", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"oppunittype", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"issettle", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"feebillid", null, (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)mode, (String)"payamt", null, (int)rowIndex);
        }
    }

    private void selectFeeBill() {
        DynamicObject bill;
        int indexRow = this.getModel().getEntryCurrentRowIndex("feedetail");
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParams().get("billFormId");
        String srcBillNo = (String)this.getModel().getValue("srcbillno", indexRow);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("enpayamt", "!=", (Object)BigDecimal.ZERO);
        qFilter.and(new QFilter("entry.srcbillno", "!=", (Object)srcBillNo).or("entry", "is null", null));
        if ("gm_letterofguarantee".equals(billFormId)) {
            bill = TmcDataServiceHelper.loadSingle((String)"gm_letterofguarantee", (String)"applyorg,org", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)srcBillNo)});
            qFilter.and("org", "in", Arrays.asList(bill.getDynamicObject("org").getPkValue(), bill.getDynamicObject("applyorg").getPkValue()));
        } else if ("gm_pledgebill".equals(billFormId)) {
            bill = TmcDataServiceHelper.loadSingle((String)"gm_pledgebill", (String)"realright,realrightpersonid,org", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)srcBillNo)});
            List<Object> authorizedAccountLegalOrgId = Collections.singletonList(bill.getDynamicObject("org").getPkValue());
            if ("tmc_org".equals(bill.getString("realright"))) {
                authorizedAccountLegalOrgId = Arrays.asList(bill.get("realrightpersonid"), bill.getDynamicObject("org").getPkValue());
            }
            qFilter.and("org", "in", authorizedAccountLegalOrgId);
        } else {
            qFilter.and("org", "=", org.getPkValue());
        }
        String entityNumber = FeeDetailEntryProp.BDIM_FEE_FORMID.contains(billFormId) ? "bdim_feebill" : ("gm_pledgebill".equals(billFormId) ? billFormId.replace("bill", "feebill") : ("gm_guaranteecontract".equals(billFormId) ? "gm_contractfeebill" : ("cfm_creditlimit".equals(billFormId) ? "creditm_feebill" : billFormId.split("_")[0] + "_feebill")));
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)false);
        listShowParameter.getListFilterParameter().getQFilters().add(qFilter);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FEEBILL_CLOSECALLBACK));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void feeBillCloseCallBack(ListSelectedRow row) {
        IDataModel mode = this.getModel();
        DynamicObject feeBill = TmcDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"cfm_feebill");
        DynamicObjectCollection feeDetailEntrys = mode.getEntryEntity("entry");
        String feeNumber = feeBill.getString("billno");
        List exitFeeNumber = feeDetailEntrys.stream().filter(r -> feeNumber.equals(r.getString("feenumber"))).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(exitFeeNumber)) {
            int indexRow = mode.getEntryCurrentRowIndex("entry");
            mode.setValue("feenumber", (Object)feeBill.getString("billno"), indexRow);
            mode.setValue("paydate", (Object)feeBill.getDate("paydate"), indexRow);
            mode.setValue("feetype", (Object)feeBill.getDynamicObject("feetype"), indexRow);
            mode.setValue("currency", (Object)feeBill.getDynamicObject("currency"), indexRow);
            mode.setValue("feeacctbank", (Object)feeBill.getDynamicObject("feeacctbank"), indexRow);
            mode.setValue("oppunittype", (Object)feeBill.getString("oppunittype"), indexRow);
            mode.setValue("issettle", (Object)feeBill.getBoolean("issettle"), indexRow);
            mode.setValue("feebillid", feeBill.getPkValue(), indexRow);
            mode.setValue("rate", (Object)feeBill.getBigDecimal("amountrate"), indexRow);
            mode.setValue("payamt", (Object)feeBill.getBigDecimal("enpayamt"), indexRow);
            mode.setValue("org", (Object)feeBill.getDynamicObject("org"), indexRow);
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u76f8\u540c\u7684\u8d39\u7528\u660e\u7ec6[%s]\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u9009\u62e9\u3002", (String)"BatchFeeInputPlugin_08", (String)"tmc-fbd-formplugin", (Object[])new Object[0]), feeNumber));
        }
    }

    private void checkCurrency(BeforeFieldPostBackEvent e, String key, int rowIndex) {
        DynamicObject feeCur = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isEmpty((DynamicObject)feeCur)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u884c\u652f\u4ed8\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BatchFeeInputPlugin_00", (String)"tmc-fbd-formplugin", (Object[])new Object[0]), rowIndex));
            e.setCancel(true);
            this.getView().updateView(key, rowIndex);
        }
    }

    private void setExcRate(int rowIndex) {
        String srcBillNo = (String)this.getModel().getValue("srcbillno", rowIndex);
        if (EmptyUtil.isEmpty((String)srcBillNo)) {
            this.getModel().setValue("excrate", (Object)BigDecimal.ONE, rowIndex);
            return;
        }
        DynamicObject productType = (DynamicObject)this.getModel().getValue("producttype", rowIndex);
        String entity = ProductTypeEnum.getEnumById((String)productType.getPkValue().toString()).getEntity();
        String currency = (String)FeeInfoConstant.formIdCurrencyKeyMap.get(entity);
        QFilter qFilter = new QFilter("billno", "=", (Object)srcBillNo);
        if ("cfm_creditlimit".equals(entity)) {
            qFilter = new QFilter("number", "=", (Object)srcBillNo);
        }
        DynamicObject srcBill = TmcDataServiceHelper.loadSingle((String)entity, (String)(currency + ",org"), (QFilter[])new QFilter[]{qFilter});
        DynamicObject org = srcBill.getDynamicObject("org");
        DynamicObject headCur = srcBill.getDynamicObject(currency);
        DynamicObject feeCur = (DynamicObject)this.getModel().getValue("currency", rowIndex);
        if (EmptyUtil.isEmpty((DynamicObject)headCur) || EmptyUtil.isEmpty((DynamicObject)feeCur) || headCur.getPkValue().equals(feeCur.getPkValue())) {
            this.getModel().setValue("excrate", (Object)BigDecimal.ONE, rowIndex);
        } else {
            this.getModel().setValue("excrate", (Object)this.getExcRate(org, headCur, feeCur), rowIndex);
        }
    }

    private BigDecimal getExcRate(DynamicObject org, DynamicObject headCur, DynamicObject feeCur) {
        if (headCur.getPkValue().toString().equals(feeCur.getPkValue().toString())) {
            return BigDecimal.ONE;
        }
        Long exchangeTableId = TmcBusinessBaseHelper.getExchageTableId((Long)org.getLong("id"));
        if (EmptyUtil.isEmpty((Long)exchangeTableId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s:\u6ca1\u6709\u5728\u51fa\u7eb3\u521d\u59cb\u5316\u91cc\u7ef4\u62a4\u6c47\u7387\u8868,\u8bf7\u7ef4\u62a4\u3002", (String)"BatchFeeInputPlugin_09", (String)"tmc-fbd-formplugin", (Object[])new Object[]{org.getString("name")}));
            return BigDecimal.ONE;
        }
        BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeTableId, (Long)feeCur.getLong("id"), (Long)headCur.getLong("id"), null);
        if (EmptyUtil.isNoEmpty((BigDecimal)exchangeRate)) {
            return exchangeRate;
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s:\u6ca1\u6709\u7ef4\u62a4[%2$s]\u8f6c\u6362[%3$s]\u7684\u6c47\u7387\u3002", (String)"BatchFeeInputPlugin_10", (String)"tmc-fbd-formplugin", (Object[])new Object[0]), org.getString("name"), feeCur.getString("name"), headCur.getString("name")));
        return BigDecimal.ONE;
    }

    private boolean checkFormId() {
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParams().get("billFormId");
        return FeeInfoConstant.BATCHINPUT_FEE_FORMID.contains(billFormId);
    }

    private void visibleShareType() {
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParams().get("billFormId");
        this.getView().setVisible(Boolean.valueOf(FeeInfoConstant.BARCHINPUT_FEE_SHARETYPE_FORMID.contains(billFormId)), new String[]{"sharetype"});
    }

    public Long getFisBankRollOrg() {
        RequestContext requestContext = RequestContext.get();
        DynamicObject currentOrg = this.checkCurrentBankOrg();
        if (currentOrg != null && currentOrg.getBoolean("fisbankroll")) {
            return currentOrg.getLong("id");
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        appId = EmptyUtil.isNotEmpty((CharSequence)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"cas").getId();
        List authorizedBankOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)requestContext.getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        if (authorizedBankOrgId != null && authorizedBankOrgId.size() > 0) {
            return (Long)authorizedBankOrgId.get(0);
        }
        return null;
    }

    public DynamicObject checkCurrentBankOrg() {
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObject currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType);
        if (currentOrg.getBoolean("fisbankroll")) {
            return currentOrg;
        }
        return null;
    }
}

