/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.feedetailbill;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class Fee2PayBillConvert
extends AbstractConvertPlugIn {
    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("id");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String descEntity = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(descEntity)) {
            DynamicObject payBill = dataEntity.getDataEntity();
            List srcRows = (List)dataEntity.getValue("ConvertSource");
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            Long srcId = (Long)((DynamicProperty)e.getFldProperties().get("id")).getValue((Object)srcRow);
            DynamicObject feeDetail = TmcDataServiceHelper.loadSingle((Object)srcId, (String)this.getSrcMainType().getName());
            String oppunitType = feeDetail.getString("oppunittype");
            if ("fbd_other".equals(oppunitType) || "bd_finorginfo".equals(oppunitType)) {
                payBill.set("payeetype", (Object)"other");
            } else {
                DynamicObject oppunit = feeDetail.getDynamicObject("oppunit");
                if (EmptyUtil.isNoEmpty((DynamicObject)oppunit)) {
                    payBill.set("itempayee", oppunit.getPkValue());
                    payBill.set("payee", oppunit.getPkValue());
                    payBill.set("payeename", (Object)oppunit.getString("name"));
                    payBill.set("payeenumber", (Object)oppunit.getString("number"));
                }
            }
            BigDecimal headAmt = payBill.getBigDecimal("actpayamt");
            if (feeDetail.getDynamicObjectCollection("entry").size() != 0) continue;
            DynamicObject row = payBill.getDynamicObjectCollection("entry").addNew();
            row.set("e_actamt", (Object)headAmt);
            row.set("e_payableamt", (Object)headAmt);
        }
    }
}

