/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.cfm.formplugin.feedetailbill;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.constant.FeeInfoConstant;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FeeCalTypeEnum;
import kd.tmc.fbp.common.enums.FeeDetailSrcBillStatusEnum;
import kd.tmc.fbp.common.enums.OppUnitTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.ShareTypeEnum;
import kd.tmc.fbp.common.helper.ListConstructorHelper;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.property.FeeDetailBillProp;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FeeDetailBillEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(FeeDetailBillEdit.class);
    private static final String SELECTBILLNO_CLOSECALLBACK = "selectbillno_closeCallBack";
    private static final String OPPACCTBANK_CLOSECALLBACK = "oppacctbank_closeCallBack";
    private final Set<String> CDM_TYPESET = Stream.of("cdm_payablebill_ap_manual", "cdm_payablebill", "cdm_payablebill", "cdm_receivablebill", "cdm_drafttradebill", "cdm_payablebill_ap_manual").collect(Collectors.toSet());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit feeScheme = (BasedataEdit)this.getView().getControl("feescheme");
        feeScheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit feeAcctBank = (BasedataEdit)this.getView().getControl("feeacctbank");
        feeAcctBank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit oppAcctBank = (TextEdit)this.getControl("oppacctbank");
        oppAcctBank.addClickListener((ClickListener)this);
        BasedataEdit productType = (BasedataEdit)this.getView().getControl("producttype");
        productType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit srcBillNo = (TextEdit)this.getControl("srcbillno");
        srcBillNo.addClickListener((ClickListener)this);
        EntryGrid entry = (EntryGrid)this.getControl("entry");
        if (entry != null) {
            entry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "feescheme": {
                this.feeSchemeEvt(evt);
                break;
            }
            case "feeacctbank": {
                this.acctBankF7Evt(evt);
                break;
            }
            case "producttype": {
                this.productTypeF7Evt(evt);
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        List initEntrys;
        DynamicObject currency;
        super.afterCreateNewData(e);
        this.getModel().setValue("appsource", (Object)this.getBizType());
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isNoEmpty((DynamicObject)org) && EmptyUtil.isNoEmpty((DynamicObject)(currency = TmcBusinessBaseHelper.getCasBaseCurrency((long)((Long)org.getPkValue()))))) {
            this.getModel().setValue("currency", (Object)currency);
        }
        if ((initEntrys = (List)this.getView().getFormShowParameter().getCustomParams().get("initentry")) != null) {
            TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), (List)initEntrys);
        } else if ("gm".equals(this.getBizType()) && this.getModel().getEntryRowCount("entry") > 0) {
            String billFormId = this.getView().getFormShowParameter().getFormId();
            if (billFormId != null && billFormId.endsWith("_feebill")) {
                this.getModel().setValue("producttype", (Object)ProductTypeEnum.GM_LETTEROFGUARANTEE.getId(), 0);
            } else if (billFormId != null && billFormId.endsWith("_pledgefeebill")) {
                this.getModel().setValue("producttype", (Object)ProductTypeEnum.GM_PLEDGEBILL.getId(), 0);
            } else if (billFormId != null && billFormId.endsWith("_contractfeebill")) {
                this.getModel().setValue("producttype", (Object)ProductTypeEnum.GM_GUARANTEECONTRACT.getId(), 0);
            }
        }
        if (this.checkFormId()) {
            this.setExcRate(0);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        DynamicObject rowInfo;
        int entry;
        super.beforeClick(evt);
        Control c = (Control)evt.getSource();
        String opKey = c.getKey().toLowerCase();
        if ("srcbillno".equals(opKey) && (entry = this.getModel().getEntryCurrentRowIndex("entry")) >= 0 && EmptyUtil.isEmpty((DynamicObject)(rowInfo = this.getModel().getEntryRowEntity("entry", entry)).getDynamicObject("producttype"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailBillEdit_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey().toLowerCase()) {
            case "oppacctbank": {
                this.dealAndShowBankInfo();
                break;
            }
            case "srcbillno": {
                this.showBillF7();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (!EmptyUtil.isEmpty((Object)returnData)) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            switch (actionId) {
                case "selectbillno_closeCallBack": {
                    int currRow = this.getModel().getEntryCurrentRowIndex("entry");
                    DynamicObject entry = this.getModel().getEntryRowEntity("entry", currRow);
                    String formId = ProductTypeEnum.getEnumByValue((String)entry.getDynamicObject("producttype").getString("number")).getEntity();
                    int size = selectedRows.size();
                    if (size > 1) {
                        if (!this.CDM_TYPESET.contains(formId)) break;
                        this.selectBatchCdmBillNoCloseCallBack(selectedRows);
                        break;
                    }
                    if (size != 1) break;
                    this.selectBillNoCloseCallBack(selectedRows.get(0));
                    break;
                }
                case "oppacctbank_closeCallBack": {
                    this.oppAcctBankCloseCallBack(selectedRows.get(0));
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        Object newVal = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propName = e.getProperty().getName()) {
            case "payamt": {
                this.calAllRowRadioAndAmt((BigDecimal)newVal);
                break;
            }
            case "feeratio": {
                this.calRowDetailAmt((BigDecimal)newVal, rowIndex);
                break;
            }
            case "feedetailamt": {
                this.calRowRatio((BigDecimal)newVal, rowIndex);
                break;
            }
            case "oppunittype": {
                this.clearOppInfo("oppunit", "oppunittext", "oppacctbank", "oppbebank");
                break;
            }
            case "oppunit": {
                this.clearOppInfo("oppunittext", "oppacctbank", "oppbebank");
                this.setDefaultAcctBankVal();
                break;
            }
            case "oppacctbank": {
                this.clearOppInfo("oppbebank");
                break;
            }
            case "producttype": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"srcbillno", null, (int)rowIndex);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"srcbillid", (Object)0, (int)rowIndex);
                if (!this.isLcOp()) break;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"creditno", null, (int)rowIndex);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"arrisubno", null, (int)rowIndex);
                break;
            }
            case "srcbillno": {
                if (EmptyUtil.isEmpty((Object)newVal)) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"srcbillid", (Object)0, (int)rowIndex);
                    if (this.isLcOp()) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"creditno", null, (int)rowIndex);
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"arrisubno", null, (int)rowIndex);
                    }
                }
                if (!this.checkFormId()) break;
                this.setExcRate(rowIndex);
                break;
            }
            case "feescheme": {
                this.feeSchemeChg((DynamicObject)newVal);
                break;
            }
            case "currency": {
                if (!this.checkFormId()) break;
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
                for (int i = 0; i < entrys.size(); ++i) {
                    this.setExcRate(i);
                }
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (BillStatusEnum.SAVE.getValue().equals(this.getModel().getValue("billstatus"))) {
            this.setFeeBillEnableByScheme();
        }
        String bizType = this.getBizType();
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)"gm".equals(bizType), (String[])new String[]{"srcbillno", "producttype"});
        this.getView().setVisible(Boolean.valueOf(this.checkFormId()), new String[]{"excrate"});
        DynamicObjectCollection entry = (DynamicObjectCollection)this.getModel().getValue("entry");
        for (int i = 0; i < entry.size(); ++i) {
            if (!FeeDetailSrcBillStatusEnum.NOAUDIT.getValue().equals(((DynamicObject)entry.get(i)).getString("srcstatus"))) continue;
            this.getModel().deleteEntryRow("entry", i);
            --i;
        }
    }

    private void feeSchemeChg(DynamicObject feeScheme) {
        boolean isSchemeNoEmpty = EmptyUtil.isNoEmpty((DynamicObject)feeScheme);
        this.getModel().setValue("feetype", isSchemeNoEmpty ? feeScheme.getDynamicObject("feetype") : Integer.valueOf(0));
        this.getModel().setValue("currency", isSchemeNoEmpty ? feeScheme.getDynamicObject("currency") : Integer.valueOf(0));
        if (isSchemeNoEmpty) {
            this.getModel().setValue("issettle", (Object)(!feeScheme.getBoolean("handsettle") ? 1 : 0));
            String feeCalType = feeScheme.getString("feecaltype");
            if (FeeCalTypeEnum.ratio.getValue().equals(feeCalType)) {
                this.getModel().setValue("amountrate", (Object)feeScheme.getBigDecimal("amountrate"));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"payamt", (Object)BigDecimal.ZERO);
            } else {
                this.getModel().setValue("payamt", (Object)feeScheme.getBigDecimal("amountrate"));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amountrate", (Object)BigDecimal.ZERO);
            }
            this.setEntryProductType(feeScheme);
        }
        this.setFeeBillEnableByScheme();
    }

    private void setEntryProductType(DynamicObject feeScheme) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        DynamicObject productType = feeScheme.getDynamicObject("tradetype");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)entrys.get(i);
            DynamicObject productRowInfo = entry.getDynamicObject("producttype");
            if (!EmptyUtil.isEmpty((DynamicObject)productRowInfo) && productType.getPkValue().equals(productRowInfo.getPkValue())) continue;
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"producttype", (Object)productType.getPkValue(), (int)i);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"srcbillno", null, (int)i);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"srcbillid", null, (int)i);
        }
    }

    private void productTypeF7Evt(BeforeF7SelectEvent evt) {
        QFilter qFilter = new QFilter("enable", "in", (Object)true).and(new QFilter("id", "in", this.getProductTypeId(this.getBizType())));
        DynamicObject feeScheme = (DynamicObject)this.getModel().getValue("feescheme");
        if (EmptyUtil.isNoEmpty((DynamicObject)feeScheme)) {
            DynamicObject tradeType = feeScheme.getDynamicObject("tradetype");
            qFilter = new QFilter("id", "=", tradeType.getPkValue());
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private void feeSchemeEvt(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject mainOrg = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)mainOrg)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailBillEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("org", "=", mainOrg.getPkValue());
        qFilter = qFilter.and(new QFilter("tradetype.id", "in", this.getProductTypeId(this.getBizType())));
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private void acctBankF7Evt(BeforeF7SelectEvent evt) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailBillEdit_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject mainOrg = (DynamicObject)this.getModel().getValue("org");
        long orgId = mainOrg == null ? 0L : Long.parseLong(mainOrg.getPkValue().toString());
        QFilter qFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId).and("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue());
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private void setFeeBillEnableByScheme() {
        DynamicObject feeScheme = (DynamicObject)this.getModel().getValue("feescheme");
        if (EmptyUtil.isNoEmpty((DynamicObject)feeScheme)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"feetype", "currency", "issettle"});
            String feeCalType = feeScheme.getString("feecaltype");
            if ("ratio".equals(feeCalType)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"amountrate"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"payamt"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"payamt"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"amountrate"});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"feetype", "payamt", "amountrate", "currency", "issettle"});
        }
    }

    private void setDefaultAcctBankVal() {
        DynamicObject oppUnit = (DynamicObject)this.getModel().getValue("oppunit");
        if (EmptyUtil.isNoEmpty((DynamicObject)oppUnit)) {
            String oppUnitEntityType = oppUnit.getDataEntityType().getName();
            if (OppUnitTypeEnum.SUPPLIER.getValue().equals(oppUnitEntityType) || OppUnitTypeEnum.CUSTOMER.getValue().equals(oppUnitEntityType)) {
                QFilter qFilter = new QFilter("id", "=", oppUnit.getPkValue());
                qFilter.and("entry_bank.isdefault_bank", "=", (Object)"1");
                DynamicObject entryBankDO = TmcDataServiceHelper.loadSingle((String)oppUnitEntityType, (String)"id,entry_bank,entry_bank.bankaccount,entry_bank.bank", (QFilter[])qFilter.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObject)entryBankDO)) {
                    DynamicObjectCollection entrys = entryBankDO.getDynamicObjectCollection("entry_bank");
                    DynamicObject entry = (DynamicObject)entrys.get(0);
                    this.getModel().setValue("oppacctbank", (Object)entry.getString("bankaccount"));
                    this.getModel().setValue("oppbebank", (Object)entry.getDynamicObject("bank"));
                }
            }
        }
    }

    private void dealAndShowBankInfo() {
        String oppUnitType = (String)this.getModel().getValue("oppunittype");
        if (EmptyUtil.isEmpty((String)oppUnitType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u65b9\u5355\u4f4d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailBillEdit_3", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (OppUnitTypeEnum.FINORGINFO.getValue().equals(oppUnitType) || OppUnitTypeEnum.OTHER.getValue().equals(oppUnitType)) {
            return;
        }
        DynamicObject oppUnit = (DynamicObject)this.getModel().getValue("oppunit");
        if (EmptyUtil.isNoEmpty((DynamicObject)oppUnit)) {
            String oppUnitEntityType = oppUnit.getDataEntityType().getName();
            Object oppUnitId = oppUnit.getPkValue();
            Object innerOrgId = null;
            if (StringUtils.equals((CharSequence)oppUnitEntityType, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)oppUnitEntityType, (CharSequence)"bd_customer")) {
                DynamicObject innerOrg = TmcBusinessBaseHelper.getInternalOrg((DynamicObject)oppUnit);
                if (EmptyUtil.isEmpty((DynamicObject)innerOrg)) {
                    String qFilter = new QFilter("id", "=", oppUnitId);
                    DynamicObject entryBankDO = TmcDataServiceHelper.loadSingle((String)oppUnitEntityType, (String)"entry_bank", (QFilter[])qFilter.toArray());
                    if (entryBankDO.getDynamicObjectCollection("entry_bank").size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5bf9\u5e94\u5ba2\u5546\u7684\u94f6\u884c\u4fe1\u606f\u3002", (String)"FeeDetailBillEdit_4", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else {
                    innerOrgId = innerOrg.getPkValue();
                }
            }
            ListShowParameter lsp = new ListShowParameter();
            switch (oppUnitEntityType) {
                case "bd_supplier": {
                    if (EmptyUtil.isNoEmpty((Object)innerOrgId)) {
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getSupplierBankInfoShowParameter((Object)oppUnitId);
                    break;
                }
                case "bd_customer": {
                    if (EmptyUtil.isNoEmpty((Object)innerOrgId)) {
                        lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)innerOrgId);
                        break;
                    }
                    lsp = ListConstructorHelper.getCustomerBankInfoShowParameter((Object)oppUnitId);
                    break;
                }
                case "bos_org": {
                    lsp = ListConstructorHelper.getAccountbanksInfoShowParameter((Object)oppUnitId);
                    break;
                }
            }
            if (EmptyUtil.isNoEmpty((Object)lsp)) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, OPPACCTBANK_CLOSECALLBACK);
                lsp.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)lsp);
            }
        }
    }

    private void selectBillNoCloseCallBack(ListSelectedRow listSelectedRow) {
        int currRow = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", currRow);
        Object pkId = listSelectedRow.getPrimaryKeyValue();
        String entityName = ProductTypeEnum.getEnumByValue((String)entry.getDynamicObject("producttype").getString("number")).getEntity();
        DynamicObject bizBill = TmcDataServiceHelper.loadSingle((Object)pkId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
        this.getModel().setValue("srcbillno", (Object)("cfm_creditlimit".equals(TmcBusinessBaseHelper.getBillFormId((String)entityName)) ? bizBill.getString("number") : bizBill.getString("billno")), currRow);
        this.getModel().setValue("srcbillid", (Object)bizBill.getLong("id"), currRow);
        this.lcBizDeal(currRow, entityName, bizBill);
    }

    private void selectBatchCdmBillNoCloseCallBack(ListSelectedRowCollection listSelectedRows) {
        int currRow = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", currRow);
        Set draftIdSet = listSelectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        DynamicObject productype = entry.getDynamicObject("producttype");
        String entityName = ProductTypeEnum.getEnumByValue((String)productype.getString("number")).getEntity();
        DynamicObjectCollection cdmDraftsColl = QueryServiceHelper.query((String)entityName, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", draftIdSet)});
        long cdmDraftId = entry.getLong("srcbillid");
        if (0L == cdmDraftId || !draftIdSet.contains(cdmDraftId)) {
            DynamicObject cdmDraftFirst = (DynamicObject)cdmDraftsColl.get(0);
            this.getModel().setValue("srcbillno", (Object)cdmDraftFirst.getString("billno"), currRow);
            this.getModel().setValue("srcbillid", (Object)cdmDraftFirst.getLong("id"), currRow);
            cdmDraftsColl.removeIf(e -> cdmDraftFirst.getLong("id") == e.getLong("id"));
        } else {
            cdmDraftsColl.removeIf(e -> cdmDraftId == e.getLong("id"));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cdmDraftsColl)) {
            for (DynamicObject cdmDraft : cdmDraftsColl) {
                int rowIndex = this.getModel().createNewEntryRow("entry");
                this.getModel().setValue("producttype", (Object)productype.getLong("id"), rowIndex);
                this.getModel().setValue("srcbillno", (Object)cdmDraft.getString("billno"), rowIndex);
                this.getModel().setValue("srcbillid", (Object)cdmDraft.getLong("id"), rowIndex);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex;
        String fieldName = evt.getFieldName();
        if ("srcbillno".equals(fieldName) && (rowIndex = evt.getRowIndex()) > -1) {
            DynamicObject entry = this.getModel().getEntryRowEntity("entry", rowIndex);
            Long srcBillId = entry.getLong("srcbillid");
            if (EmptyUtil.isNoEmpty((Long)srcBillId)) {
                String entityName = ProductTypeEnum.getEnumByValue((String)entry.getDynamicObject("producttype").getString("number")).getEntity();
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(entityName);
                parameter.setPkId((Object)srcBillId);
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"FeeDetailBillEdit_5", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (("settle".equals(operateKey) || "unsettle".equals(operateKey)) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void lcBizDeal(int currRow, String entityName, DynamicObject bizBill) {
        if (this.isLcOp()) {
            if (ProductTypeEnum.LC_LETTER.getEntity().equals(entityName)) {
                this.getModel().setValue("creditno", (Object)bizBill.getString("creditno"), currRow);
            } else if (ProductTypeEnum.LC_ARRIVAL.getEntity().equals(entityName) || ProductTypeEnum.LC_PRESENT.getEntity().equals(entityName)) {
                if ("credit".equals(bizBill.getString("arrivaltype"))) {
                    this.getModel().setValue("creditno", (Object)bizBill.getDynamicObject("lettercredit").getString("number"), currRow);
                }
                this.getModel().setValue("arrisubno", (Object)bizBill.getString("arrivalno"), currRow);
            } else if (ProductTypeEnum.LC_FORFAIT.getEntity().equals(entityName)) {
                if ("credit".equals(bizBill.getString("arrivaltype"))) {
                    this.getModel().setValue("creditno", (Object)bizBill.getDynamicObject("lettercredit").getString("number"), currRow);
                }
                this.getModel().setValue("arrisubno", (Object)bizBill.getDynamicObject("arrivalno").getString("arrivalno"), currRow);
            } else if (ProductTypeEnum.LC_RECEIPT.getEntity().equals(entityName)) {
                this.getModel().setValue("creditno", (Object)bizBill.getString("creditno"), currRow);
            }
        }
    }

    private boolean isLcOp() {
        return "lc_feebill".equals(this.getView().getFormShowParameter().getFormId());
    }

    private void oppAcctBankCloseCallBack(ListSelectedRow row) {
        Object entryKey = row.getEntryPrimaryKeyValue();
        DynamicObject oppUnit = this.getModel().getDataEntity().getDynamicObject("oppunit");
        String entityName = oppUnit.getDataEntityType().getName();
        DynamicObject innerOrg = null;
        if ("bd_supplier".equals(entityName) || "bd_customer".equals(entityName)) {
            innerOrg = TmcBusinessBaseHelper.getInternalOrg((DynamicObject)oppUnit);
        }
        if ((StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_supplier") || StringUtils.equals((CharSequence)entityName, (CharSequence)"bd_customer")) && innerOrg == null) {
            DynamicObject oppUnitDetail = TmcDataServiceHelper.loadSingle((String)oppUnit.getDataEntityType().getName(), (String)"id,bankaccount,bank", (QFilter[])new QFilter[]{new QFilter("entry_bank.id", "=", entryKey)});
            if (EmptyUtil.isEmpty((DynamicObject)oppUnitDetail)) {
                return;
            }
            DynamicObjectCollection entryBank = oppUnitDetail.getDynamicObjectCollection("entry_bank");
            for (DynamicObject entry : entryBank) {
                if (!entry.getPkValue().equals(entryKey)) continue;
                this.getModel().setValue("oppacctbank", (Object)entry.getString("bankaccount"));
                this.getModel().setValue("oppbebank", (Object)entry.getDynamicObject("bank"));
                break;
            }
        } else if ("bos_org".equals(entityName) || EmptyUtil.isNoEmpty((DynamicObject)innerOrg)) {
            DynamicObject accountBanksDO = TmcDataServiceHelper.loadSingle((String)"bd_accountbanks", (String)"id,bank,number", (QFilter[])new QFilter("id", "=", row.getPrimaryKeyValue()).toArray());
            if (EmptyUtil.isEmpty((DynamicObject)accountBanksDO)) {
                return;
            }
            this.getModel().setValue("oppacctbank", (Object)accountBanksDO.getString("number"));
            DynamicObject bankDO = accountBanksDO.getDynamicObject("bank");
            if (!EmptyUtil.isEmpty((DynamicObject)bankDO)) {
                this.getModel().setValue("oppbebank", (Object)bankDO.getDynamicObject("bebank"));
            }
        }
    }

    private void showBillF7() {
        DynamicObjectCollection entryEntity;
        Set hasSelectCdmDraftIdSet;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailBillEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject entry = this.getModel().getEntryRowEntity("entry", this.getModel().getEntryCurrentRowIndex("entry"));
        DynamicObject productType = entry.getDynamicObject("producttype");
        String productTypeNum = productType.getString("number");
        String formId = ProductTypeEnum.getEnumByValue((String)productTypeNum).getFormId();
        boolean isNeedMultiSelect = false;
        if (this.CDM_TYPESET.contains(formId)) {
            isNeedMultiSelect = true;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)formId, (boolean)isNeedMultiSelect, (int)2);
        lsp.setCustomParam("ismergerows", (Object)Boolean.FALSE);
        lsp.setCustomParam("isframework", (Object)Boolean.FALSE);
        List<QFilter> showBillF7QFilter = this.getShowBillF7Qfilter(formId);
        showBillF7QFilter.add(TmcBusinessBaseHelper.getOrgFilter((String)productTypeNum));
        if (ProductTypeEnum.LC_LETTER.getFormId().equals(formId)) {
            QFilter offFiliter = new QFilter("tradechannel", "!=", (Object)"online");
            QFilter onlineFiliter = new QFilter("tradechannel", "=", (Object)"online");
            onlineFiliter = onlineFiliter.and(new QFilter("bebankstatus", "=", (Object)BeBillStatusEnum.TS.getValue()));
            QFilter tradeChannelFilter = offFiliter.or(onlineFiliter);
            showBillF7QFilter.add(tradeChannelFilter);
        } else if (this.CDM_TYPESET.contains(formId) && EmptyUtil.isNoEmpty(hasSelectCdmDraftIdSet = (entryEntity = this.getModel().getEntryEntity("entry")).stream().filter(e -> null != e.getDynamicObject("producttype") && productTypeNum.equals(e.getDynamicObject("producttype").getString("number")) && EmptyUtil.isNoEmpty((Long)e.getLong("srcbillid"))).map(e -> e.getLong("srcbillid")).collect(Collectors.toSet()))) {
            showBillF7QFilter.add(new QFilter("id", "not in", hasSelectCdmDraftIdSet));
        }
        lsp.getListFilterParameter().getQFilters().addAll(showBillF7QFilter);
        logger.info("show\u7684\u5355\u636e\u5e03\u5c40\u662f" + formId + "\u8fc7\u6ee4\u6761\u4ef6\u662f:" + lsp.getListFilterParameter().getQFilters());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SELECTBILLNO_CLOSECALLBACK);
        lsp.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void clearOppInfo(String ... fields) {
        for (String field : fields) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)field, null);
        }
    }

    private void calAllRowRadioAndAmt(BigDecimal headAmt) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            if (EmptyUtil.isEmpty((BigDecimal)headAmt)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeratio", null, (int)i);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feedetailamt", null, (int)i);
                continue;
            }
            DynamicObject entry = (DynamicObject)entrys.get(i);
            BigDecimal feeRatio = entry.getBigDecimal("feeratio");
            BigDecimal feeDetailAmt = entry.getBigDecimal("feedetailamt");
            if (EmptyUtil.isNoEmpty((BigDecimal)feeRatio)) {
                this.calRowDetailAmt(feeRatio, i);
                continue;
            }
            if (!EmptyUtil.isNoEmpty((BigDecimal)feeDetailAmt)) continue;
            this.calRowRatio(feeDetailAmt, i);
        }
    }

    private void calRowRatio(BigDecimal detailAmt, int rowIndex) {
        DynamicObject currency;
        BigDecimal payAmt = (BigDecimal)this.getModel().getValue("payamt");
        if (this.isPassCalRowVolid(payAmt, currency = (DynamicObject)this.getModel().getValue("currency"), "feedetailamt")) {
            BigDecimal rowRatio = detailAmt.divide(payAmt, 6, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeratio", (Object)rowRatio, (int)rowIndex);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feedetailamt", null, (int)rowIndex);
        }
    }

    private void calRowDetailAmt(BigDecimal radio, int rowIndex) {
        DynamicObject currency;
        BigDecimal payAmt = (BigDecimal)this.getModel().getValue("payamt");
        if (this.isPassCalRowVolid(payAmt, currency = (DynamicObject)this.getModel().getValue("currency"), "feeratio")) {
            BigDecimal detailAmt = payAmt.multiply(radio.divide(BigDecimal.valueOf(100L), 6, RoundingMode.HALF_UP));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feedetailamt", (Object)detailAmt, (int)rowIndex);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"feeratio", null, (int)rowIndex);
        }
    }

    private boolean isPassCalRowVolid(BigDecimal payAmt, DynamicObject currency, String validFiled) {
        boolean isPassVolid = true;
        if (EmptyUtil.isEmpty((BigDecimal)payAmt)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailBillEdit_6", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            isPassVolid = false;
        }
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FeeDetailBillEdit_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            isPassVolid = false;
        }
        BigDecimal totalVal = this.getModel().getEntryEntity("entry").stream().map(o -> o.getBigDecimal(validFiled)).reduce(BigDecimal.ZERO, BigDecimal::add);
        if ("feeratio".equals(validFiled) && BigDecimal.valueOf(100L).compareTo(totalVal) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u627f\u62c5\u6bd4\u4f8b\u4e0d\u80fd\u8d85\u8fc7100%\u3002", (String)"FeeDetailBillEdit_7", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            isPassVolid = false;
        }
        return isPassVolid;
    }

    private List<QFilter> getShowBillF7Qfilter(String formId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
        Set srcIds = entryEntity.stream().map(o -> o.getLong("srcbillid")).collect(Collectors.toSet());
        DynamicObject currEntry = this.getModel().getEntryRowEntity("entry", this.getModel().getEntryCurrentRowIndex("entry"));
        if (EmptyUtil.isNoEmpty(srcIds)) {
            srcIds.remove(currEntry.getLong("srcbillid"));
            qFilters.add(new QFilter("id", "not in", srcIds));
        }
        String bizType = this.getBizType();
        if (Arrays.asList("bdim", "cfm").contains(bizType)) {
            return this.getLoanFeeQFilters(qFilters, formId);
        }
        String billFormId = this.getView().getFormShowParameter().getFormId();
        if ("gm".equals(bizType) && billFormId != null && billFormId.endsWith("_feebill")) {
            qFilters.add(new QFilter("bizstatus", "!=", (Object)"cancelled"));
        }
        return qFilters;
    }

    private List<QFilter> getLoanFeeQFilters(List<QFilter> qFilters, String formId) {
        qFilters.add(FeeDetailBillEdit.getLoanTypesFilterByFormId(formId));
        return qFilters;
    }

    private static QFilter getLoanTypesFilterByFormId(String formId) {
        switch (formId) {
            case "cfm_loancontract_bl_l": 
            case "cfm_loanbill_b_l": {
                return new QFilter("loantype", "in", Arrays.asList("loan", "sl"));
            }
            case "cfm_loancontract_ic_l": 
            case "cfm_loanbill_e_l": {
                return new QFilter("loantype", "in", Arrays.asList("ec", "entrust"));
            }
            case "cfm_loancontract_bo": 
            case "cfm_loanbill_bond": {
                return new QFilter("loantype", "=", (Object)"bond");
            }
        }
        return QFilter.isNotNull((String)"loantype");
    }

    private List<Long> getProductTypeId(String bizType) {
        String shareType = (String)this.getModel().getValue("sharetype");
        if (!ShareTypeEnum.NOTSHARE.getValue().equals(shareType)) {
            if ("cfm".equals(bizType)) {
                return Collections.singletonList(Long.valueOf(ProductTypeEnum.LOANBILL_B_L.getId()));
            }
            if ("bdim".equals(bizType)) {
                return Collections.singletonList(Long.valueOf(ProductTypeEnum.LOANBILL_BOND.getId()));
            }
        }
        String billFormId = this.getView().getFormShowParameter().getFormId();
        return TmcBusinessBaseHelper.getProductTypeId((String)bizType, (String)billFormId);
    }

    private String getBizType() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("biztype")) {
            return (String)this.getView().getFormShowParameter().getCustomParam("biztype");
        }
        return this.getDefaultBizType();
    }

    private String getDefaultBizType() {
        String billFormId = this.getView().getFormShowParameter().getFormId();
        return TmcBusinessBaseHelper.getDefaultBizType((String)billFormId);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        String entryName = entryProp.getName();
        if ("entry".equals(entryName) && "gm".equals(this.getBizType())) {
            String billFormId = this.getView().getFormShowParameter().getFormId();
            for (RowDataEntity row : e.getRowDataEntities()) {
                int index = row.getRowIndex();
                if (index < 0) continue;
                if (billFormId != null && billFormId.endsWith("_feebill")) {
                    this.getModel().setValue("producttype", (Object)ProductTypeEnum.GM_LETTEROFGUARANTEE.getId(), index);
                    continue;
                }
                if (billFormId != null && billFormId.endsWith("_pledgefeebill")) {
                    this.getModel().setValue("producttype", (Object)ProductTypeEnum.GM_PLEDGEBILL.getId(), index);
                    continue;
                }
                if (billFormId == null || !billFormId.endsWith("_contractfeebill")) continue;
                this.getModel().setValue("producttype", (Object)ProductTypeEnum.GM_GUARANTEECONTRACT.getId(), index);
            }
        }
    }

    private void setExcRate(int rowIndex) {
        String srcBillNo = (String)this.getModel().getValue("srcbillno", rowIndex);
        if (EmptyUtil.isEmpty((String)srcBillNo)) {
            this.getModel().setValue("excrate", (Object)BigDecimal.ONE, rowIndex);
            return;
        }
        DynamicObject productType = (DynamicObject)this.getModel().getValue("producttype", rowIndex);
        String entity = ProductTypeEnum.getEnumById((String)productType.getPkValue().toString()).getEntity();
        String currency = (String)FeeInfoConstant.formIdCurrencyKeyMap.get(entity);
        DynamicObject srcBill = TmcDataServiceHelper.loadSingle((String)entity, (String)(currency + ",org"), (QFilter[])new QFilter[]{new QFilter("cfm_creditlimit".equals(entity) ? "number" : "billno", "=", (Object)srcBillNo)});
        DynamicObject org = srcBill.getDynamicObject("org");
        DynamicObject bizCur = srcBill.getDynamicObject(currency);
        DynamicObject feeCur = (DynamicObject)this.getModel().getValue("currency");
        if (EmptyUtil.isEmpty((DynamicObject)bizCur) || EmptyUtil.isEmpty((DynamicObject)feeCur) || bizCur.getPkValue().equals(feeCur.getPkValue())) {
            this.getModel().setValue("excrate", (Object)BigDecimal.ONE, rowIndex);
        } else {
            this.getModel().setValue("excrate", (Object)this.getExcRate(org, bizCur, feeCur), rowIndex);
        }
    }

    private BigDecimal getExcRate(DynamicObject org, DynamicObject bizCur, DynamicObject feeCur) {
        if (bizCur.getPkValue().toString().equals(feeCur.getPkValue().toString())) {
            return BigDecimal.ONE;
        }
        Long exchangeTableId = TmcBusinessBaseHelper.getExchageTableId((Long)org.getLong("id"));
        if (EmptyUtil.isEmpty((Long)exchangeTableId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s:\u6ca1\u6709\u5728\u51fa\u7eb3\u521d\u59cb\u5316\u91cc\u7ef4\u62a4\u6c47\u7387\u8868,\u8bf7\u7ef4\u62a4\u3002", (String)"BatchFeeInputPlugin_09", (String)"tmc-fbd-formplugin", (Object[])new Object[]{org.getString("name")}));
            return BigDecimal.ONE;
        }
        BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeTableId, (Long)feeCur.getLong("id"), (Long)bizCur.getLong("id"), null);
        if (EmptyUtil.isNoEmpty((BigDecimal)exchangeRate)) {
            return exchangeRate;
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s:\u6ca1\u6709\u7ef4\u62a4[%2$s]\u8f6c\u6362[%3$s]\u7684\u6c47\u7387\u3002", (String)"BatchFeeInputPlugin_10", (String)"tmc-fbd-formplugin", (Object[])new Object[0]), org.getString("name"), feeCur.getString("name"), bizCur.getString("name")));
        return BigDecimal.ONE;
    }

    private boolean checkFormId() {
        String billFormId = this.getView().getFormShowParameter().getFormId();
        return FeeDetailBillProp.FEEBIll_EXCRATE_FORMID.contains(billFormId);
    }
}

