/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.companyprop;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orgview.OrgViewTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbd.common.helper.ComapnyManagePropHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CompanyManagePropTreeList
extends OrgViewTreeListPlugin {
    private static final String ORG_FUNC_ID = "08";
    private static final Log logger = LogFactory.getLog(CompanyManagePropTreeList.class);

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void initializeOrgView() {
        this.setOrgViewType(ORG_FUNC_ID);
        this.setOrgViewNumber(ORG_FUNC_ID);
    }

    public TreeNode initRootNode() {
        long orgId = 0L;
        OrgTreeParam param = this.getOrgTreeParam(orgId);
        TreeNode root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        String rootId = root.getId();
        long rootOrgId = Long.parseLong(rootId.toString());
        List children = null;
        if (rootOrgId != 0L) {
            param = this.getOrgTreeParam(rootOrgId);
            children = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
            children = CollectionUtils.isEmpty((Collection)children) ? null : children;
        }
        root.setChildren(children);
        this.treeListView.getTreeView().deleteAllNodes();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)rootId);
        return root;
    }

    private OrgTreeParam getOrgTreeParam(long orgId) {
        boolean buildRootNodeInRange;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        OrgTreeParam param = new OrgTreeParam();
        param.setId(orgId);
        String orgViewNumber = this.getOrgViewNumber();
        param.setOrgViewNumber(orgViewNumber);
        param.setIncludeFreeze(true);
        param.setIncludeDisable(true);
        param.getCustomFilterList().add(new QFilter("structure.view.number", "=", (Object)ORG_FUNC_ID));
        QFilter otherFilter = this.addTreeNodeFilter();
        if (otherFilter != null) {
            param.getCustomFilterList().add(otherFilter);
        }
        boolean bl = buildRootNodeInRange = !listShowParameter.isLookUp() || 0 == listShowParameter.getF7Style() || 3 == listShowParameter.getF7Style();
        if (buildRootNodeInRange) {
            param.getCustomFilterList().addAll(listShowParameter.getListFilterParameter().getQFilters());
        }
        param.setBuildRootNodeInRange(buildRootNodeInRange);
        return param;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        long orgId = Long.parseLong(e.getNodeId().toString());
        List subOrgIds = TmcOrgDataHelper.getAllSubordinateOrgs((Long)Long.parseLong(ORG_FUNC_ID), Collections.singletonList(orgId), (boolean)true, (boolean)true);
        logger.info("\u67e5\u8be2\u6240\u9009\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u6570\u636esize\uff1a{}", (Object)subOrgIds.size());
        String appId = this.getView().getFormShowParameter().getAppId();
        List id = ComapnyManagePropHelper.getAuthorizedBankOrgFromCache((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)"fbd_company_manageprop", (String)"47150e89000000ac").stream().map(s -> s.getLong("id")).collect(Collectors.toList());
        subOrgIds.retainAll(id);
        logger.info("\u5b9e\u9645\u67e5\u8be2\u7ec4\u7ec7\u6570\u636esize\uff1a{}", (Object)subOrgIds.size());
        QFilter orgFilter = new QFilter("org", "in", (Object)subOrgIds);
        e.addQFilter(orgFilter);
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        OrgTreeParam param = this.getOrgTreeParam(Long.parseLong(nodeId));
        e.setChildNodes(OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param));
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        String orgId = e.getNodeId().toString();
        this.getPageCache().put("orgid", orgId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String oprateKey = op.getOperateKey();
        if ("new".equals(oprateKey)) {
            String appId;
            String selectedOrgId = this.getPageCache().get("orgid");
            if (EmptyUtil.isEmpty((String)selectedOrgId)) {
                TreeNode root = this.getTreeModel().getRoot();
                selectedOrgId = root.getId();
                this.getPageCache().put("orgid", selectedOrgId);
            }
            if (!TmcOrgDataHelper.hasPermission((String)(appId = this.getView().getFormShowParameter().getAppId()), (long)RequestContext.get().getCurrUserId(), (long)Long.parseLong(selectedOrgId), (String)"fbd_company_manageprop", (String)"47156aff000000ac")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u7ec4\u7ec7\u7684\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CompanyManagePropTreeList_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        e.setOrderBys("");
    }

    public boolean isUseDefaultClickEvent() {
        return true;
    }
}

