/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.companysys;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbd.common.helper.CompanySysViewHelper;
import kd.tmc.fbp.common.enums.CompanySysAuthScopeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class CompanySysViewList
extends AbstractTmcListPlugin {
    private static final String ADDNEW = "addnew";
    private static final String BTN_DEL = "tbldel";
    private static final String KEY_AUTHAPPEND = "authappend";
    private static final String KEY_DISAUTH = "disauth";
    private static final String COMPANY_VIEW_DIS_AUTH = "fbd_companysysviewdisauth";
    private static final String COMPANY_VIEW_AUTH_APPEND = "fbd_companyviewauthappend";
    private static final String CALL_BACK_DELETE_AUTH = "callBackDeleteAuth";

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        FormShowParameter showParameter = e.getParameter().getShowParameter();
        if ("fbd_companysysviewsch".equals(showParameter.getFormId())) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDNEW));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (ADDNEW.equals(actionId)) {
            if (this.isReturnTrue(closedCallBackEvent)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CompanySysViewList_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                this.billListRefresh();
            } else if (this.isReturnFalse(closedCallBackEvent)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"CompanySysViewList_6", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
        } else if (COMPANY_VIEW_DIS_AUTH.equals(actionId)) {
            if (this.isReturnTrue(closedCallBackEvent)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5206\u914d\u6210\u529f\u3002", (String)"CompanySysViewList_3", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                this.billListRefresh();
            }
        } else if (COMPANY_VIEW_AUTH_APPEND.equals(actionId) && Objects.nonNull(closedCallBackEvent.getReturnData())) {
            Object returnData = closedCallBackEvent.getReturnData();
            Object[] data = (Object[])returnData;
            List userIds = (List)data[0];
            List roleIds = (List)data[1];
            List selectedIdList = this.getSelectedIdList();
            CompanySysViewHelper.appendCompanySysViewAuth((List)selectedIdList, (List)userIds, (List)roleIds);
            CompanySysViewHelper.modifyCompanyView((List)selectedIdList, (Long)RequestContext.get().getCurrUserId());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CompanySysViewList_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            this.billListRefresh();
        }
    }

    private boolean isReturnTrue(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        return returnData != null && (Boolean)returnData != false;
    }

    private boolean isReturnFalse(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        return returnData != null && (Boolean)returnData == false;
    }

    private void billListRefresh() {
        BillList billlist = (BillList)this.getView().getControl("billlistap");
        billlist.refreshData();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (BTN_DEL.equals(evt.getItemKey())) {
            BillList billList = (BillList)this.getControl("billlistap");
            List selectedIdList = billList.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            boolean hasEnable = TmcDataServiceHelper.exists((String)"fbd_companysysviewsch", (QFilter[])new QFilter[]{new QFilter("id", "in", selectedIdList), new QFilter("enable", "=", (Object)"1")});
            if (hasEnable) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u542f\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"CompanySysViewList_11", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            boolean exists = TmcDataServiceHelper.exists((String)"fbd_companysysauth", (QFilter[])new QFilter[]{new QFilter("companysysview", "in", selectedIdList)});
            if (exists) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CALL_BACK_DELETE_AUTH, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u8d44\u91d1\u7ec4\u7ec7\u89c6\u56fe\u4e0b\u5b58\u5728\u6388\u6743\u8bb0\u5f55\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"CompanySysViewList_4", (String)"tmc-fbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
                evt.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if (Objects.nonNull(e.getOperationResult()) && e.getOperationResult().isSuccess()) {
            String operateKey;
            switch (operateKey = e.getOperateKey()) {
                case "disauth": {
                    this.showDisAuthForm(this.getSelectedIdList());
                    break;
                }
                case "authappend": {
                    this.showAppendAuthForm(this.getSelectedIdList());
                    break;
                }
            }
        }
    }

    private void showAppendAuthForm(List<Long> authList) {
        if (CollectionUtils.isEmpty(authList) || this.checkViewAuthScope(authList)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(COMPANY_VIEW_AUTH_APPEND);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, COMPANY_VIEW_AUTH_APPEND));
        this.getView().showForm(showParameter);
    }

    private void showDisAuthForm(List<Long> disList) {
        if (CollectionUtils.isEmpty(disList) || this.checkViewAuthScope(disList)) {
            return;
        }
        QFilter selectFilter = new QFilter("companysysview", "in", disList);
        QFilter normalFilter = new QFilter("defaultuser", "=", (Object)"N");
        ListShowParameter listParameter = ShowFormHelper.createShowListForm((String)COMPANY_VIEW_DIS_AUTH, (boolean)true);
        listParameter.setShowTitle(true);
        listParameter.setListFilterParameter(new ListFilterParameter(Arrays.asList(selectFilter, normalFilter), "companysysview"));
        listParameter.setCaption(ResManager.loadKDString((String)"\u53cd\u5206\u914d", (String)"CompanySysViewList_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
        listParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, COMPANY_VIEW_DIS_AUTH));
        this.getView().showForm((FormShowParameter)listParameter);
    }

    private boolean checkViewAuthScope(List<Long> selectedIdList) {
        boolean exists = TmcDataServiceHelper.exists((String)"fbd_companysysviewsch", (QFilter[])new QFilter[]{new QFilter("id", "in", selectedIdList), new QFilter("scope", "!=", (Object)CompanySysAuthScopeEnum.AUTH.getValue())});
        if (exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6743\u9650\u8303\u56f4\u4e3a\u201c\u6743\u9650\u5206\u914d\u201d\u7684\u8d44\u91d1\u7ec4\u7ec7\u89c6\u56fe\u5141\u8bb8\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CompanySysViewList_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
        }
        return exists;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        int result;
        if (e.getCallBackId().equals(CALL_BACK_DELETE_AUTH) && (result = e.getResult().getValue()) == MessageBoxResult.Yes.getValue()) {
            List selectedIdList = this.getSelectedIdList();
            DeleteServiceHelper.delete((String)"fbd_companysysauth", (QFilter[])new QFilter[]{new QFilter("companysysview", "in", (Object)selectedIdList)});
            OperationResult res = TmcOperateServiceHelper.execOperate((String)"delete", (String)"fbd_companysysviewsch", (Object[])selectedIdList.toArray(), (OperateOption)OperateOption.create(), (boolean)false);
            if (res.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"CompanySysViewList_5", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        }
    }
}

