/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.companysysauth;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CompanySysAuthEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit userControl = (BasedataEdit)this.getControl("user");
        userControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit roleControl = (BasedataEdit)this.getControl("rolename");
        roleControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("user".equals(name)) {
            this.userPropChange(e);
        } else if ("rolename".equals(name)) {
            this.rolePropChange(e);
        }
        super.propertyChanged(e);
    }

    private void userPropChange(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        long userId = newValue.getLong("id");
        List maps = UserServiceHelper.get(Collections.singletonList(userId), (String[])new String[]{"id", "picturefield", "number", "gender", "isforbidden", "islocked"}, null);
        if (CollectionUtils.isNotEmpty((Collection)maps)) {
            Map userMap = (Map)maps.get(0);
            this.getModel().setValue("headimg", userMap.get("picturefield"), rowIndex);
            this.getModel().setValue("worknumber", userMap.get("number"), rowIndex);
            this.getModel().setValue("gender", userMap.get("gender"), rowIndex);
            this.getModel().setValue("userforbidden", userMap.get("isforbidden"), rowIndex);
            this.getModel().setValue("lock", userMap.get("islocked"), rowIndex);
            this.getModel().setValue("defaultuser", (Object)"N", rowIndex);
        }
        long orgId = UserServiceHelper.getUserMainOrgId((long)userId);
        String jobName = UserServiceHelper.getUserMainJob((long)userId);
        this.getModel().setValue("mainorg", (Object)orgId, rowIndex);
        this.getModel().setValue("position", (Object)jobName, rowIndex);
    }

    private void rolePropChange(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        String roleId = newValue.getString("id");
        String selFields = "id,number,remark,createtime,disabledate";
        DynamicObject roleObj = BusinessDataServiceHelper.loadSingleFromCache((String)"perm_role", (String)selFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)roleId)});
        this.getModel().setValue("rolecode", (Object)roleObj.getString("number"), rowIndex);
        this.getModel().setValue("roledesc", (Object)roleObj.getString("remark"), rowIndex);
        this.getModel().setValue("effectdate", (Object)roleObj.getDate("createtime"), rowIndex);
        this.getModel().setValue("disabledate", (Object)roleObj.getDate("disabledate"), rowIndex);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "user": {
                this.bosUserF7(evt);
                break;
            }
            case "rolename": {
                this.permRoleF7(evt);
                break;
            }
        }
    }

    private void bosUserF7(BeforeF7SelectEvent evt) {
        List hasUserIds = this.getModel().getEntryEntity("userentity").stream().filter(t -> Objects.nonNull(t.getDynamicObject("user"))).map(t -> t.getDynamicObject("user").getLong("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(hasUserIds)) {
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter().getShowParameter();
            parameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", hasUserIds));
        }
    }

    private void permRoleF7(BeforeF7SelectEvent evt) {
        List hasRoleIds = this.getModel().getEntryEntity("roleentity").stream().filter(t -> Objects.nonNull(t.getDynamicObject("rolename"))).map(t -> t.getDynamicObject("rolename").getString("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(hasRoleIds)) {
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter().getShowParameter();
            parameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", hasRoleIds));
        }
    }
}

