/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.compare;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.compare.api.bean.CompareRuleConfigBean;
import kd.tmc.fbp.common.compare.config.CompareRuleEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CompareRuleConfigPlugin
extends AbstractFormPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter sp = e.getFormShowParameter();
        String srcEntityType = (String)sp.getCustomParam("key_entity_type_src");
        String tarEntityType = (String)sp.getCustomParam("key_entity_type_tar");
        if (srcEntityType == null || tarEntityType == null) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u6e90\u5355\u7c7b\u578b\u548c\u76ee\u6807\u5355\u7c7b\u578b\u4e3a\u7a7a\uff0c\u6253\u5f00\u8868\u5355\u5931\u8d25\u3002", (String)"CompareRuleConfigPlugin_0", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter sp = this.getView().getFormShowParameter();
        String srcEntityType = (String)sp.getCustomParam("key_entity_type_src");
        String tarEntityType = (String)sp.getCustomParam("key_entity_type_tar");
        this.fillEntityFieldCombo(srcEntityType, "srcfields");
        this.fillEntityFieldCombo(tarEntityType, "targetfield");
        this.fillRelationCombo();
        this.fillOriginData();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        if ("relation".equals(propName)) {
            ChangeData changeSet = e.getChangeSet()[0];
            String val = (String)changeSet.getNewValue();
            int rowIdx = changeSet.getRowIndex();
            this.refreshRowConfig(CompareRuleEnum.fromVal((String)val), rowIdx);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        if (evt.getSource() instanceof Control && "btnok".equals(key = ((Control)evt.getSource()).getKey())) {
            DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
            if (entryList.size() > 0) {
                this.returnDataToParent();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u884c\u6570\u636e\u3002", (String)"CompareRuleConfigPlugin_1", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] entityArr = e.getRowDataEntities();
        if (entityArr != null) {
            for (RowDataEntity entity : entityArr) {
                this.refreshRowConfig(null, entity.getRowIndex());
            }
        }
    }

    private void refreshRowConfig(CompareRuleEnum compareRule, int row) {
        boolean extraValEnable = false;
        if (compareRule != null) {
            switch (compareRule) {
                case EQUALS: {
                    break;
                }
                case LIKE: {
                    break;
                }
                case DIFF: {
                    extraValEnable = true;
                    break;
                }
            }
        }
        if (!extraValEnable) {
            this.getModel().setValue("extval", null, row);
        }
        this.getView().setEnable(Boolean.valueOf(extraValEnable), row, new String[]{"extval"});
    }

    private void fillRelationCombo() {
        ComboEdit combo = (ComboEdit)this.getControl("relation");
        List comboItems = CompareRuleEnum.transToComboItems();
        combo.setComboItems(comboItems);
    }

    private void fillEntityFieldCombo(String entityName, String comboPropName) {
        ComboEdit combo = (ComboEdit)this.getControl(comboPropName);
        List<FilterField> fields = this.getEntityFields(entityName);
        List items = fields.stream().map(o -> new ComboItem(o.getCaption(), o.getFullFieldName())).collect(Collectors.toList());
        combo.setComboItems(items);
    }

    private List<FilterField> getEntityFields(String entityName) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
        return filterFields.stream().filter(o -> !o.isFieldPropAliasEmpty()).collect(Collectors.toList());
    }

    private void fillOriginData() {
        FormShowParameter sp = this.getView().getFormShowParameter();
        String configVal = (String)sp.getCustomParam("key_rule_config_val");
        List configList = null;
        if (EmptyUtil.isNotEmpty((CharSequence)configVal)) {
            configList = JSON.parseArray((String)configVal, CompareRuleConfigBean.class);
        }
        if (configList != null && configList.size() > 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            TableValueSetter tv = new TableValueSetter(new String[0]);
            tv.addField("srcfields", new Object[0]);
            tv.addField("relation", new Object[0]);
            tv.addField("targetfield", new Object[0]);
            tv.addField("extval", new Object[0]);
            tv.addField("isnullmatch", new Object[0]);
            tv.addField("isallnullmatch", new Object[0]);
            for (CompareRuleConfigBean configBean : configList) {
                tv.addRow(new Object[]{configBean.getSrcProp(), configBean.getRelation(), configBean.getTarProp(), configBean.getExtraVal(), configBean.isNullMatch(), configBean.isAllNullMatch() != null ? configBean.isAllNullMatch().booleanValue() : configBean.isNullMatch()});
            }
            model.batchCreateNewEntryRow("entryentity", tv);
            for (int i = 0; i < configList.size(); ++i) {
                this.refreshRowConfig(CompareRuleEnum.fromVal((String)((CompareRuleConfigBean)configList.get(i)).getRelation()), i);
            }
        }
    }

    private void returnDataToParent() {
        FormShowParameter sp = this.getView().getFormShowParameter();
        DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
        ArrayList<CompareRuleConfigBean> configList = new ArrayList<CompareRuleConfigBean>(entryList.size());
        List<FilterField> srcEntityFieldList = this.getEntityFields((String)sp.getCustomParam("key_entity_type_src"));
        List<FilterField> tarEntityFieldList = this.getEntityFields((String)sp.getCustomParam("key_entity_type_tar"));
        for (int i = 0; i < entryList.size(); ++i) {
            CompareRuleConfigBean configBean = new CompareRuleConfigBean();
            String srcProp = (String)this.getModel().getValue("srcfields", i);
            String tarProp = (String)this.getModel().getValue("targetfield", i);
            String relation = (String)this.getModel().getValue("relation", i);
            String extraVal = (String)this.getModel().getValue("extval", i);
            boolean nullMatch = (Boolean)this.getModel().getValue("isnullmatch", i);
            boolean allNullMatch = (Boolean)this.getModel().getValue("isallnullmatch", i);
            configBean.setSrcProp(srcProp);
            configBean.setSrcPropName(this.findFieldPropName(srcEntityFieldList, srcProp));
            configBean.setTarProp(tarProp);
            configBean.setTarPropName(this.findFieldPropName(tarEntityFieldList, tarProp));
            configBean.setRelation(relation);
            configBean.setExtraVal(extraVal);
            configBean.setNullMatch(nullMatch);
            configBean.setAllNullMatch(Boolean.valueOf(allNullMatch));
            configBean.validate();
            configList.add(configBean);
        }
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("key_extradata", sp.getCustomParam("key_extradata"));
        configMap.put("key_rule_config_val", configList);
        this.getView().returnDataToParent(configMap);
        this.getView().close();
    }

    private String findFieldPropName(List<FilterField> filedList, String fullName) {
        return filedList.stream().filter(o -> o.getFullFieldName().equals(fullName)).map(o -> o.getCaption().getLocaleValue()).findFirst().orElseGet(() -> null);
    }
}

