/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.counterparty;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbd.common.enums.PartyTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CounterpartyImportEdit
extends AbstractFormPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("confirm".equals(operateKey) && opResult.isSuccess()) {
            IDataModel model = this.getModel();
            ArrayList<DynamicObject> lst = new ArrayList<DynamicObject>();
            DynamicObjectCollection customerColl = (DynamicObjectCollection)model.getValue("customer");
            this.setCounterPartyDataInfo(lst, customerColl, PartyTypeEnum.bd_customer.getValue());
            DynamicObjectCollection supplierColl = (DynamicObjectCollection)model.getValue("supplier");
            this.setCounterPartyDataInfo(lst, supplierColl, PartyTypeEnum.bd_supplier.getValue());
            DynamicObjectCollection finorginfoColl = (DynamicObjectCollection)model.getValue("finorginfo");
            this.setCounterPartyDataInfo(lst, finorginfoColl, PartyTypeEnum.bd_finorginfo.getValue());
            this.getView().returnDataToParent(lst);
            this.getView().close();
        }
    }

    private void setCounterPartyDataInfo(List<DynamicObject> lst, DynamicObjectCollection collection, String partyType) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)collection)) {
            return;
        }
        List ids = collection.stream().map(e -> e.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("party", "in", ids);
        qFilter.and("partytype", "=", (Object)partyType);
        DynamicObject[] countParties = TmcDataServiceHelper.load((String)"tbd_counterparty", (String)"id", (QFilter[])qFilter.toArray());
        Map<Object, Object> map = new HashMap();
        if (countParties != null && countParties.length > 0) {
            Object[] counterPartyIds = Arrays.stream(countParties).map(e -> e.getLong("id")).toArray();
            DynamicObject[] counterPartys = TmcDataServiceHelper.load((Object[])counterPartyIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tbd_counterparty"));
            map = Arrays.stream(counterPartys).collect(Collectors.groupingBy(k -> k.getDynamicObject("party").getString("id")));
        }
        for (DynamicObject collectionRow : collection) {
            DynamicObject info = collectionRow.getDynamicObject("fbasedataid");
            if (map.containsKey(info.getString("id"))) {
                List counterPartys = (List)map.get(info.getString("id"));
                for (DynamicObject party : counterPartys) {
                    party.set("number", (Object)info.getString("number"));
                    party.set("name", (Object)info.getString("name"));
                    lst.add(party);
                }
                continue;
            }
            DynamicObject counterParty = TmcDataServiceHelper.newDynamicObject((String)"tbd_counterparty");
            counterParty.set("number", (Object)info.getString("number"));
            counterParty.set("name", (Object)info.getString("name"));
            counterParty.set("partytype", (Object)partyType);
            counterParty.set("status", (Object)"C");
            counterParty.set("creator", (Object)RequestContext.get().getCurrUserId());
            counterParty.set("enable", (Object)1);
            counterParty.set("createtime", (Object)DateUtils.getCurrentTime());
            if (PartyTypeEnum.bd_finorginfo.getValue().equals(partyType)) {
                long userOrgId = RequestContext.get().getOrgId();
                DynamicObject orgInfo = TmcDataServiceHelper.loadSingleFromCache((Object)userOrgId, (String)"bos_org");
                counterParty.set("org", (Object)orgInfo);
            } else {
                counterParty.set("org", (Object)info.getDynamicObject("org"));
            }
            counterParty.set("party", (Object)info.getLong("id"));
            counterParty.set("source", (Object)"import");
            lst.add(counterParty);
        }
    }
}

