/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.counterparty;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CounterpartyList
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof AbstractOperate) {
            AbstractOperate op = (AbstractOperate)source;
            switch (op.getOperateKey()) {
                case "showform": {
                    this.showFormOperate();
                    break;
                }
                case "copy": {
                    this.checkCanCopy(args);
                }
            }
        }
    }

    private void showFormOperate() {
        String formId = "tbd_counterparty_imp";
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
        this.getView().showForm(showParameter);
    }

    private void checkCanCopy(BeforeDoOperationEventArgs args) {
        Long selPkID = this.getSelectedId();
        if (selPkID == null) {
            args.setCancel(true);
            return;
        }
        DynamicObject counterParty = BusinessDataServiceHelper.loadSingleFromCache((Object)selPkID, (String)"tbd_counterparty", (String)"source");
        if ("import".equals(counterParty.getString("source"))) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6765\u6e90\u4e3a\u6570\u636e\u540c\u6b65\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u590d\u5236\u64cd\u4f5c\u3002", (String)"CounterpartyList_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        List lst;
        super.closedCallBack(event);
        String action = event.getActionId();
        if (StringUtils.equals((CharSequence)action, (CharSequence)"tbd_counterparty_imp") && (lst = (List)event.getReturnData()) != null && lst.size() > 0) {
            Object[] dataEntities = new DynamicObject[lst.size()];
            for (int i = 0; i < lst.size(); ++i) {
                DynamicObject info = (DynamicObject)lst.get(i);
                dataEntities[i] = info;
            }
            if (EmptyUtil.isNoEmpty((Object[])dataEntities)) {
                TmcDataServiceHelper.save((DynamicObject[])dataEntities);
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u4ea4\u6613\u5bf9\u624b\u6210\u529f\u3002", (String)"CounterpartyList_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected Long getSelectedId() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CounterpartyList_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return null;
        }
        HashSet<Long> idSet = new HashSet<Long>(selectedRows.size());
        for (int i = 0; i < selectedRows.size(); ++i) {
            idSet.add((Long)selectedRows.get(i).getPrimaryKeyValue());
        }
        if (idSet.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8fdb\u884c\u5904\u7406\u3002", (String)"CounterpartyList_3", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return null;
        }
        return (Long)selectedRows.get(0).getPrimaryKeyValue();
    }
}

