/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.currencypair;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CurrencyPairEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter param = this.getView().getParentView().getFormShowParameter();
        this.getModel().setValue("pid", (Object)((Long)param.getCustomParams().get("pid")));
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit quotemarket = (BasedataEdit)this.getView().getControl("quotemarket");
        quotemarket.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basismarket = (BasedataEdit)this.getView().getControl("basismarket");
        basismarket.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit quoteyieldcurve = (BasedataEdit)this.getView().getControl("quoteyieldcurve");
        quoteyieldcurve.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basisyieldcurve = (BasedataEdit)this.getView().getControl("basisyieldcurve");
        basisyieldcurve.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey;
        switch (fieldKey = arg0.getProperty().getName()) {
            case "quotemarket": 
            case "quoteyieldcurve": {
                this.setMarketFilter(arg0, "quotecurrency");
                break;
            }
            case "basismarket": 
            case "basisyieldcurve": {
                this.setMarketFilter(arg0, "basiscurrency");
            }
        }
    }

    private void setMarketFilter(BeforeF7SelectEvent arg0, String currencyName) {
        String calculateFunction;
        DynamicObject currency = (DynamicObject)this.getModel().getValue(currencyName);
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            QFilter filter = new QFilter("currency.id", "=", currency.getPkValue());
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            List filterList = showParameter.getListFilterParameter().getQFilters();
            for (QFilter qFilter : filterList) {
                filter = filter.and(qFilter);
            }
            showParameter.getListFilterParameter().setFilter(filter);
        }
        if ((calculateFunction = (String)this.getModel().getValue("calculatefunction")).equals("ratepairty") && EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            QFilter qFilter = new QFilter("currency.id", "=", currency.getPkValue());
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            List filterList = showParameter.getListFilterParameter().getQFilters();
            for (QFilter filter : filterList) {
                qFilter = qFilter.and(filter);
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "calculatefunction": {
                this.calculatefunctionChange(e);
                this.setYieldCurve("quotemarket", "quoteyieldcurve");
                this.setYieldCurve("basismarket", "basisyieldcurve");
                break;
            }
            case "quotecurrency": {
                this.initMarketValue(this.getModel(), this.getView(), "quotemarket", "quotecurrency");
                this.setNumberAndName();
                this.getModel().setValue("quotemarket", null);
                break;
            }
            case "basiscurrency": {
                this.initMarketValue(this.getModel(), this.getView(), "basismarket", "basiscurrency");
                this.setNumberAndName();
                this.getModel().setValue("basismarket", null);
                break;
            }
            case "quotemarket": {
                this.setYieldCurve("quotemarket", "quoteyieldcurve");
                break;
            }
            case "basismarket": {
                this.setYieldCurve("basismarket", "basisyieldcurve");
            }
        }
    }

    private void setYieldCurve(String marketName, String yieldCurveName) {
        String calculateFunction = (String)this.getModel().getValue("calculatefunction");
        DynamicObject market = this.getModel().getDataEntity().getDynamicObject(marketName);
        if (calculateFunction.equals("ratepairty") && EmptyUtil.isNoEmpty((DynamicObject)market)) {
            FormShowParameter param = this.getView().getParentView().getFormShowParameter();
            Long priceruleId = (Long)param.getCustomParams().get("pricerule");
            Long yieldCurveID = this.yieldCurve(priceruleId, (Long)market.getPkValue());
            this.getModel().setValue(yieldCurveName, (Object)yieldCurveID);
        }
    }

    private void setNumberAndName() {
        DynamicObject quotecurrency = this.getModel().getDataEntity().getDynamicObject("quotecurrency");
        DynamicObject basiscurrency = this.getModel().getDataEntity().getDynamicObject("basiscurrency");
        if (EmptyUtil.isNoEmpty((DynamicObject)quotecurrency) && EmptyUtil.isNoEmpty((DynamicObject)basiscurrency)) {
            this.getModel().setValue("number", (Object)(basiscurrency.getString("number") + "/" + quotecurrency.getString("number")));
            this.getModel().setValue("name", (Object)(basiscurrency.getString("name") + "/" + quotecurrency.getString("name")));
        }
    }

    private void calculatefunctionChange(PropertyChangedArgs e) {
        String key;
        switch (key = this.getModel().getValue("calculatefunction").toString()) {
            case "forwardrate": {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"derivemethod"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"viacurrency", "quotemarket", "basismarket", "quoteyieldcurve", "basisyieldcurve"});
                break;
            }
            case "forexpairty": {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"viacurrency"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"derivemethod", "quotemarket", "basismarket", "quoteyieldcurve", "basisyieldcurve"});
                break;
            }
            case "ratepairty": {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"quotemarket", "basismarket", "quoteyieldcurve", "basisyieldcurve"});
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"derivemethod", "viacurrency"});
            }
        }
    }

    private void initMarketValue(IDataModel model, IFormView view, String marketField, String currencyField) {
        Row row;
        Iterator it;
        String sSQL;
        DataSet ds;
        String protecttype;
        DynamicObject currency = (DynamicObject)model.getValue(currencyField);
        if (EmptyUtil.isNoEmpty((DynamicObject)currency) && !EmptyUtil.isEmpty((String)(protecttype = (String)view.getFormShowParameter().getCustomParam("protecttype"))) && !(ds = DB.queryDataSet((String)"default", (DBRoute)DBRouteConst.TMC, (String)(sSQL = "Select FMarketId From T_Tbd_Default def left join T_Tbd_Default_Entrys entry on def.FId = entry.FId left join T_Tbd_Default_SubEntrys sub on entry.FEntryId = sub.FEntryId Where FTradeTypeId = ? and FCurrencyId = ?"), (Object[])new Object[]{Long.valueOf(protecttype), currency.getLong("id")})).isEmpty() && (it = ds.iterator()).hasNext() && EmptyUtil.isNoEmpty((Long)(row = (Row)it.next()).getLong("FMarketId"))) {
            model.setValue(marketField, (Object)row.getLong("FMarketId"));
        }
    }

    private Long yieldCurve(Long priceRuleId, Long marketId) {
        Long id = null;
        String sSQL = "Select FYieldsId From t_tbd_pricerule_yield Where Fid = ? and FMarketId = ? and FType = ?";
        DataSet ds = DB.queryDataSet((String)"queryYieldCurve", (DBRoute)DBRouteConst.TMC, (String)sSQL, (Object[])new Object[]{priceRuleId, marketId, "disc"});
        if (ds.hasNext()) {
            Row row = ds.next();
            id = row.getLong("FYieldsId");
        }
        return id;
    }
}

