/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.entitymap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BizRangeTypeEnum;
import kd.tmc.fbp.common.enums.EntityPropTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.selectprop.SelectEntityPropHelper;
import kd.tmc.fbp.formplugin.common.selectprop.SelectEntityPropParam;

public class EntityMapModelEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit srcField = (TextEdit)this.getControl("srcfieldname");
        srcField.addButtonClickListener((ClickListener)this);
        TextEdit targetField = (TextEdit)this.getControl("targetfieldname");
        targetField.addButtonClickListener((ClickListener)this);
        TextEdit entrySrcField = (TextEdit)this.getControl("entrysrcfield");
        entrySrcField.addButtonClickListener((ClickListener)this);
        TextEdit entryTagField = (TextEdit)this.getControl("entrytagfield");
        entryTagField.addButtonClickListener((ClickListener)this);
        TextEdit fbTagfield = (TextEdit)this.getControl("fbtagfieldname");
        fbTagfield.addButtonClickListener((ClickListener)this);
        TextEdit matchSrcfield = (TextEdit)this.getControl("matchsrcfield");
        matchSrcfield.addButtonClickListener((ClickListener)this);
        TextEdit matchTagfield = (TextEdit)this.getControl("matchtagfield");
        matchTagfield.addButtonClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.reBuildFilterGrid();
        this.reBulildAttachInfo();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.autoSetNameAndNum();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "ishasentry": {
                if (newValue == null || ((Boolean)newValue).booleanValue() || newValue.equals(oldValue)) break;
                this.getModel().deleteEntryData("entryentity");
                this.getModel().deleteEntryData("entryrelation");
                break;
            }
            case "proptype": {
                if (newValue != null && newValue.equals(oldValue)) break;
                this.getModel().setValue("srcfield", (Object)" ", rowIndex);
                this.getModel().setValue("srcfieldname", (Object)" ", rowIndex);
                this.getModel().setValue("targetfield", (Object)" ", rowIndex);
                this.getModel().setValue("targetfieldname", (Object)" ", rowIndex);
                break;
            }
            case "srcentity": {
                if (newValue == null || !newValue.equals(oldValue)) {
                    if (BizRangeTypeEnum.isAttachment((String)((String)this.getModel().getValue("biztype")))) {
                        this.setDefaultAttachEnum(newValue == null ? null : (DynamicObject)newValue, "srcattach");
                    }
                    this.getModel().setValue("matchsrcfield", (Object)" ");
                    this.getModel().setValue("matchsrcfieldval", (Object)" ");
                    this.getModel().deleteEntryData("entryrelation");
                    DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
                    for (int i = 0; i < entrys.size(); ++i) {
                        this.getModel().setValue("srcfield", (Object)" ", i);
                        this.getModel().setValue("srcfieldname", (Object)" ", i);
                    }
                }
                this.autoSetNameAndNum();
                break;
            }
            case "tagentity": {
                if (newValue == null || !newValue.equals(oldValue)) {
                    if (BizRangeTypeEnum.isAttachment((String)((String)this.getModel().getValue("biztype")))) {
                        this.setDefaultAttachEnum(newValue == null ? null : (DynamicObject)newValue, "tagattach");
                    }
                    this.clearFilterGrid();
                    this.reBuildFilterGrid();
                    this.getModel().setValue("matchtagfield", (Object)" ");
                    this.getModel().setValue("matchtagfieldval", (Object)" ");
                    this.getModel().deleteEntryData("entryrelation");
                    DynamicObjectCollection nentrys = this.getModel().getEntryEntity("entryentity");
                    for (int i = 0; i < nentrys.size(); ++i) {
                        this.getModel().setValue("targetfield", (Object)" ", i);
                        this.getModel().setValue("targetfieldname", (Object)" ", i);
                    }
                    this.getModel().deleteEntryData("allowentryentity");
                }
                this.autoSetNameAndNum();
                break;
            }
            case "biztype": {
                this.autoSetNameAndNum();
                this.reBulildAttachInfo();
                break;
            }
            case "relationtype": {
                if (newValue != null && newValue.equals(oldValue)) break;
                this.getModel().setValue("entrysrcfield", (Object)" ", rowIndex);
                this.getModel().setValue("entrysrcfieldval", (Object)" ", rowIndex);
                this.getModel().setValue("entrytagfield", (Object)" ", rowIndex);
                this.getModel().setValue("entrytagfieldval", (Object)" ", rowIndex);
                break;
            }
            case "billrelationtype": {
                if (newValue != null && newValue.equals(oldValue)) break;
                this.getModel().setValue("matchsrcfield", (Object)" ");
                this.getModel().setValue("matchsrcfieldval", (Object)" ");
                this.getModel().setValue("matchtagfield", (Object)" ");
                this.getModel().setValue("matchtagfieldval", (Object)" ");
                this.getModel().deleteEntryData("entryrelation");
                this.getModel().deleteEntryData("entryentity");
                break;
            }
            case "matchsrcfieldval": 
            case "matchtagfieldval": {
                String[] srcMatchEntry;
                if (!EmptyUtil.isEmpty((Object)newValue) && newValue.equals(oldValue) || !EmptyUtil.isNoEmpty((Object)oldValue) || (srcMatchEntry = ((String)oldValue).split("\\.")).length <= 1) break;
                this.delEntityMapEntry("matchsrcfieldval".equals(key) ? "srcfield" : "targetfield");
                break;
            }
            case "fbtagfield": {
                if (!EmptyUtil.isEmpty((Object)newValue) && newValue.equals(oldValue) || !EmptyUtil.isNoEmpty((Object)oldValue)) break;
                DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("entryentity");
                for (int i = 0; i < entryEntitys.size(); ++i) {
                    DynamicObject entryDo = (DynamicObject)entryEntitys.get(i);
                    String fieldPropVal = entryDo.getString("targetfield");
                    if (!oldValue.equals(fieldPropVal)) continue;
                    this.getModel().setValue("targetfield", (Object)" ", i);
                    this.getModel().setValue("targetfieldname", (Object)" ", i);
                }
                break;
            }
        }
    }

    void delEntityMapEntry(String fieldProp) {
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntitys.size(); ++i) {
            String[] fieldPropValArr;
            DynamicObject entryDo = (DynamicObject)entryEntitys.get(i);
            String fieldPropVal = entryDo.getString(fieldProp);
            if (EmptyUtil.isEmpty((String)fieldPropVal) || (fieldPropValArr = fieldPropVal.split("\\.")).length <= 1) continue;
            this.getModel().setValue(fieldProp, (Object)" ", i);
            this.getModel().setValue(fieldProp + "name", (Object)" ", i);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("save".equals(op.getOperateKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            FilterCondition filterCondition = filterGridState.getFilterCondition();
            if (EmptyUtil.isEmpty((Collection)filterCondition.getFilterRow())) {
                this.getModel().setValue("datafilter_tag", null);
            } else {
                CRCondition conditionObj = new CRCondition();
                conditionObj.setFilterCondition(filterCondition);
                String formulaStr = SerializationUtils.toJsonString((Object)conditionObj);
                this.getModel().setValue("datafilter_TAG", (Object)(EmptyUtil.isEmpty((String)formulaStr) ? " " : formulaStr));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("checkbizrule".equals(operateKey) && null != opResult && opResult.isSuccess()) {
            String opKeyStr = (String)this.getModel().getValue("checkop");
            DynamicObject bizbill = (DynamicObject)this.getModel().getValue("tagentity");
            Set opkeys = Arrays.stream(opKeyStr.replaceFirst(",", "").split(",")).collect(Collectors.toSet());
            QFilter ruleQfilter = new QFilter("opbizrule", "=", (Object)"EntityMap_NoneBotp").and("objecttype", "=", bizbill.getPkValue()).and("entryentity.operationkey", "in", opkeys);
            DynamicObject[] targetBills = BusinessDataServiceHelper.load((String)"bos_opbizruleset", (String)"id", (QFilter[])ruleQfilter.toArray());
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setIsolationOrg(false);
            showParameter.setBillFormId("bos_opbizruleset");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
            HashSet<Object> pks = new HashSet<Object>(targetBills.length);
            for (DynamicObject targetBill : targetBills) {
                pks.add(targetBill.get("id"));
            }
            qFilters.add(new QFilter("id", "in", pks));
            showParameter.getListFilterParameter().setQFilters(qFilters);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("srcfieldname".equals(key) || "entrysrcfield".equals(key) || "matchsrcfield".equals(key)) {
            DynamicObject bizEntity = (DynamicObject)this.getModel().getValue("srcentity");
            if (EmptyUtil.isEmpty((DynamicObject)bizEntity)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u5355\u5b9e\u4f53\u3002", (String)"EntityMapModelProp_01", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
            this.showProps(key, bizEntity);
        } else if ("targetfieldname".equals(key) || "entrytagfield".equals(key) || "matchtagfield".equals(key)) {
            DynamicObject bizEntity = (DynamicObject)this.getModel().getValue("tagentity");
            if (EmptyUtil.isEmpty((DynamicObject)bizEntity)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u5b9e\u4f53\u3002", (String)"EntityMapModelProp_03", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
            this.showProps(key, bizEntity);
        } else if ("fbtagfieldname".equals(key)) {
            DynamicObject bizEntity = (DynamicObject)this.getModel().getValue("tagentity");
            if (EmptyUtil.isEmpty((DynamicObject)bizEntity)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u5b9e\u4f53\u3002", (String)"EntityMapModelProp_03", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
            this.showProps(key, bizEntity);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String returnData = (String)e.getReturnData();
        switch (e.getActionId()) {
            case "matchsrcfield": {
                if (returnData == null || !returnData.contains(",")) break;
                this.getModel().setValue("matchsrcfieldval", (Object)returnData.split(",")[0]);
                this.getModel().setValue("matchsrcfield", (Object)returnData.split(",")[1]);
                break;
            }
            case "matchtagfield": {
                if (returnData == null || !returnData.contains(",")) break;
                this.getModel().setValue("matchtagfieldval", (Object)returnData.split(",")[0]);
                this.getModel().setValue("matchtagfield", (Object)returnData.split(",")[1]);
                break;
            }
            case "entrysrcfield": {
                if (returnData == null || !returnData.contains(",")) break;
                int curIndex = this.getModel().getEntryCurrentRowIndex("entryrelation");
                this.getModel().setValue("entrysrcfieldval", (Object)returnData.split(",")[0], curIndex);
                this.getModel().setValue("entrysrcfield", (Object)returnData.split(",")[1], curIndex);
                break;
            }
            case "entrytagfield": {
                if (returnData == null || !returnData.contains(",")) break;
                int curIndex = this.getModel().getEntryCurrentRowIndex("entryrelation");
                this.getModel().setValue("entrytagfieldval", (Object)returnData.split(",")[0], curIndex);
                this.getModel().setValue("entrytagfield", (Object)returnData.split(",")[1], curIndex);
                break;
            }
            case "srcfieldname": {
                if (returnData == null || !returnData.contains(",")) break;
                int curIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getModel().setValue("srcfield", (Object)returnData.split(",")[0], curIndex);
                this.getModel().setValue("srcfieldname", (Object)returnData.split(",")[1], curIndex);
                break;
            }
            case "targetfieldname": {
                if (returnData == null || !returnData.contains(",")) break;
                int curIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getModel().setValue("targetfield", (Object)returnData.split(",")[0], curIndex);
                this.getModel().setValue("targetfieldname", (Object)returnData.split(",")[1], curIndex);
                break;
            }
            case "fbtagfieldname": {
                if (returnData == null || !returnData.contains(",")) break;
                int curIndexFd = this.getModel().getEntryCurrentRowIndex("allowentryentity");
                this.getModel().setValue("fbtagfield", (Object)returnData.split(",")[0], curIndexFd);
                this.getModel().setValue("fbtagfieldname", (Object)returnData.split(",")[1], curIndexFd);
            }
        }
    }

    void autoSetNameAndNum() {
        DynamicObject srcEntity = (DynamicObject)this.getModel().getValue("srcentity");
        DynamicObject tagEntity = (DynamicObject)this.getModel().getValue("tagentity");
        String bizType = (String)this.getModel().getValue("biztype");
        if (EmptyUtil.isNoEmpty((DynamicObject)srcEntity) && EmptyUtil.isNoEmpty((DynamicObject)tagEntity) && EmptyUtil.isNoEmpty((String)bizType)) {
            String name = String.format("%1$s->%2$s(%3$s)", srcEntity.getString("name"), tagEntity.getString("name"), BizRangeTypeEnum.getNameByVal((String)bizType));
            String number = String.format("%1$s->%2$s(%3$s)", srcEntity.getString("number"), tagEntity.getString("number"), bizType);
            this.getModel().setValue("name", (Object)name);
            this.getModel().setValue("number", (Object)number);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if ("allowentryentity".equals(entryName)) {
            int[] idxs = e.getRowIndexs();
            ArrayList<String> needDelFiledList = new ArrayList<String>(10);
            for (int idx : idxs) {
                DynamicObject entryentity_sel = this.getModel().getEntryRowEntity(entryName, idx);
                needDelFiledList.add(entryentity_sel.getString("fbtagfield"));
            }
            if (needDelFiledList.size() <= 0) {
                return;
            }
            DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entryEntitys.size(); ++i) {
                DynamicObject entryDo = (DynamicObject)entryEntitys.get(i);
                String fieldPropVal = entryDo.getString("targetfield");
                if (!needDelFiledList.contains(fieldPropVal)) continue;
                this.getModel().setValue("targetfield", (Object)" ", i);
                this.getModel().setValue("targetfieldname", (Object)" ", i);
            }
        }
    }

    private void reBuildFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
        DynamicObject tagEntity = (DynamicObject)this.getModel().getValue("tagentity");
        if (tagEntity == null) {
            return;
        }
        String entityNumber = tagEntity.getString("number");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterFieldBuildOption option = new FilterFieldBuildOption();
        option.setCompatibleProductMode(true);
        List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)entityType, (FilterFieldBuildOption)option);
        filterGrid.setFilterColumns(cols);
        filterGrid.setEntityNumber(entityNumber);
        String conditionJson = (String)this.getModel().getValue("datafilter_TAG");
        if (EmptyUtil.isNoEmpty((String)conditionJson)) {
            CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            FilterCondition filterCondition = conditionObj.getFilterCondition();
            if (filterCondition != null) {
                filterGrid.SetValue(filterCondition);
            }
        } else {
            filterGrid.SetValue(new FilterCondition());
        }
        this.getView().updateView("ffiltergrid");
    }

    private void reBulildAttachInfo() {
        if (BizRangeTypeEnum.isAttachment((String)((String)this.getModel().getValue("biztype")))) {
            this.setDefaultAttachEnum((DynamicObject)this.getModel().getValue("srcentity"), "srcattach");
            this.setDefaultAttachEnum((DynamicObject)this.getModel().getValue("tagentity"), "tagattach");
        }
    }

    private void clearFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
        filterGrid.SetValue(new FilterCondition());
        this.getModel().setValue("datafilter_TAG", (Object)" ");
        this.getView().updateView("ffiltergrid");
    }

    private void showProps(String key, DynamicObject bizEntity) {
        SelectEntityPropParam param = SelectEntityPropParam.build((String)bizEntity.getString("number"), (IFormView)this.getView(), (IFormPlugin)this, (String)key).setMultiSelect(false).setIncludeRefProp(false).setIncludeEntryEntityAsKeyPrefix(true).setSelectNodeType("leafNode").setIncludePKField(false);
        String billrelationtype = (String)this.getModel().getValue("billrelationtype");
        if ("matchsrcfield".equals(key) || "matchtagfield".equals(key)) {
            EntityMapModelEdit.headMatchSet(key, param, billrelationtype);
        } else if ("srcfieldname".equals(key) || "targetfieldname".equals(key)) {
            this.fieldMapSet(key, bizEntity, param, billrelationtype);
        } else if ("entrysrcfield".equals(key) || "entrytagfield".equals(key)) {
            this.entryMatchSet(param);
        } else if ("fbtagfieldname".equals(key)) {
            HashMap forbdProps = new HashMap();
            ArrayList<String> fbFieldList = new ArrayList<String>(10);
            fbFieldList.addAll(Arrays.asList("org,company,currency,amount,locamt,exchangerate,sourcebillid,sourcebilltype,sourcebillnumber,isinit,isvoucher".split(",")));
            fbFieldList.addAll(Arrays.asList("disabler,disabledate,enabler,enabledate,creator,modifier,auditor,auditdate,modifytime,createtime".split(",")));
            fbFieldList.addAll(Arrays.asList("id", "billno", "billstatus", "status"));
            forbdProps.put(Boolean.FALSE, fbFieldList);
            param.setDefProps(forbdProps);
            param.setIncludeEntity(true);
            param.setIncludePKField(false);
        }
        SelectEntityPropHelper.showSelectProps((SelectEntityPropParam)param);
    }

    private EntityMetadata getEntityMetadata(String entity) {
        MetadataReader reader = new MetadataReader();
        String formId = reader.loadIdByNumber(entity, MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
        return (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMetadata.getEntityId(), (MetaCategory)MetaCategory.Entity);
    }

    private void setDefaultAttachEnum(DynamicObject entityDo, String attachProp) {
        if (null != entityDo) {
            String entity = entityDo.getString("number");
            ComboEdit attachPropEdit = (ComboEdit)this.getControl(attachProp);
            MetadataReader reader = new MetadataReader();
            String formId = reader.loadIdByNumber(entity, MetaCategory.Form);
            FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
            Map<String, String> attachMentKeys = formMetadata.getItems().stream().filter(o -> o instanceof AttachmentPanelAp).filter(EmptyUtil::isNoEmpty).map(o -> (AttachmentPanelAp)o).collect(Collectors.toMap(AbstractElement::getKey, o -> o.getName().getLocaleValue()));
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(attachMentKeys.size());
            for (Map.Entry<String, String> entryMap : attachMentKeys.entrySet()) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(String.format("%1$s(%2$s)", entryMap.getValue(), entryMap.getKey())));
                comboItem.setValue(entryMap.getKey());
                comboItems.add(comboItem);
            }
            attachPropEdit.setComboItems(comboItems);
            if (EmptyUtil.isNoEmpty(comboItems)) {
                this.getModel().setValue(attachProp, (Object)((ComboItem)comboItems.get(0)).getValue());
            } else {
                this.getModel().setValue(attachProp, (Object)"attachmentpanel");
            }
        }
    }

    private void entryMatchSet(SelectEntityPropParam param) {
        param.setIncludeHead(false);
        param.setIncludeEntity(true);
        int entryRowCount = this.getModel().getEntryCurrentRowIndex("entryrelation");
        String relationType = (String)this.getModel().getValue("relationtype", entryRowCount);
        if ("byone".equals(relationType)) {
            param.setSelectNodeType("noLeafNode");
        }
        param.setPropTypes(new EntityPropTypeEnum[]{EntityPropTypeEnum.BASEDATA, EntityPropTypeEnum.LONG, EntityPropTypeEnum.STRING});
    }

    private void fieldMapSet(String key, DynamicObject bizEntity, SelectEntityPropParam param, String billrelationtype) {
        int entryRowCount = this.getModel().getEntryCurrentRowIndex("entryentity");
        String proptype = (String)this.getModel().getValue("proptype", entryRowCount);
        if (EmptyUtil.isEmpty((String)proptype)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5c5e\u6027\u7c7b\u578b\u3002", (String)"EntityMapModelProp_02", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
        }
        if (!"all".equals(proptype)) {
            param.setPropTypes(new EntityPropTypeEnum[]{EntityPropTypeEnum.getEnum((String)proptype)});
        }
        String matchSrcFieldVal = (String)this.getModel().getValue("matchsrcfieldval");
        String matchTagFieldVal = (String)this.getModel().getValue("matchtagfieldval");
        param.setIncludeEntity(true);
        ArrayList<String> srcEntryProps = new ArrayList<String>(10);
        ArrayList<String> tagEntryProps = new ArrayList<String>(10);
        if (((Boolean)this.getModel().getValue("ishasentry")).booleanValue()) {
            DynamicObjectCollection entryRelations = this.getModel().getEntryEntity("entryrelation");
            for (DynamicObject entryRelation : entryRelations) {
                String relationType = entryRelation.getString("relationtype");
                String entrySrcfieldVal = entryRelation.getString("entrysrcfieldval");
                String entryTagfieldVal = entryRelation.getString("entrytagfieldval");
                if ("byone".equals(relationType)) {
                    srcEntryProps.add(entrySrcfieldVal);
                    tagEntryProps.add(entryTagfieldVal);
                    continue;
                }
                srcEntryProps.add(entrySrcfieldVal.split("\\.")[0]);
                tagEntryProps.add(entryTagfieldVal.split("\\.")[0]);
            }
        } else {
            String[] splitTag;
            String[] splitSrc = matchSrcFieldVal.split("\\.");
            if (splitSrc.length > 1) {
                srcEntryProps.add(splitSrc[0]);
            }
            if ((splitTag = matchTagFieldVal.split("\\.")).length > 1) {
                tagEntryProps.add(splitTag[0]);
            }
        }
        if ("srcfieldname".equals(key)) {
            if (EmptyUtil.isEmpty((String)matchSrcFieldVal)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u5b9e\u4f53\u5339\u914d\u5c5e\u6027\u3002", (String)"EntityMapModelProp_05", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
            if ("h2e_sid".equals(billrelationtype)) {
                param.setIncludeEntity(false);
            }
            param.setDefEntryProps(srcEntryProps);
        } else {
            List fbFieldList;
            if (EmptyUtil.isEmpty((String)matchTagFieldVal)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u5b9e\u4f53\u5339\u914d\u5c5e\u6027\u3002", (String)"EntityMapModelProp_04", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
            if ("e2h_tid".equals(billrelationtype)) {
                param.setIncludeEntity(false);
            }
            param.setDefEntryProps(tagEntryProps);
            HashMap defProps = new HashMap(16);
            EntityMetadata entityMetadata = this.getEntityMetadata(bizEntity.getString("number"));
            ArrayList extFileds = new ArrayList(10);
            List entitys = entityMetadata.getEntitys();
            for (Entity entity : entitys) {
                String headProp = entity.getKey();
                List fields = entity.getItems().stream().filter(AbstractElement::isExt).map(AbstractElement::getKey).filter(EmptyUtil::isNoEmpty).map(o -> entity instanceof EntryEntity ? String.format("%s.%s", headProp, o) : o).collect(Collectors.toList());
                extFileds.addAll(fields);
            }
            DynamicObjectCollection allowEntryEntity = this.getModel().getEntryEntity("allowentryentity");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)allowEntryEntity) && EmptyUtil.isNoEmpty(fbFieldList = allowEntryEntity.stream().map(o -> o.getString("fbtagfield")).collect(Collectors.toList()))) {
                extFileds.addAll(fbFieldList);
            }
            defProps.put(Boolean.TRUE, extFileds);
            param.setDefProps(defProps);
        }
    }

    private static void headMatchSet(String key, SelectEntityPropParam param, String billrelationtype) {
        HashMap<Boolean, List<String>> idBillnoProps = new HashMap<Boolean, List<String>>();
        idBillnoProps.put(Boolean.TRUE, Arrays.asList("id", "billno"));
        param.setIncludePKField(true);
        if ("matchsrcfield".equals(key) && ("h2h_sid".equals(billrelationtype) || "h2e_sid".equals(billrelationtype))) {
            param.setDefProps(idBillnoProps);
        } else if ("matchtagfield".equals(key) && ("h2h_tid".equals(billrelationtype) || "e2h_tid".equals(billrelationtype))) {
            param.setDefProps(idBillnoProps);
            param.setIncludeEntity(false);
        } else if ("matchsrcfield".equals(key) && "h2h_tid".equals(billrelationtype)) {
            EntityMapModelEdit.setDefautParm(param, idBillnoProps);
            param.setIncludeEntity(false);
        } else if ("matchtagfield".equals(key) && "h2h_sid".equals(billrelationtype)) {
            EntityMapModelEdit.setDefautParm(param, idBillnoProps);
            param.setIncludeEntity(false);
        } else if ("matchsrcfield".equals(key) && "e2h_tid".equals(billrelationtype)) {
            EntityMapModelEdit.setDefautParm(param, idBillnoProps);
            param.setIncludeEntity(true);
            param.setIncludeHead(false);
        } else if ("matchtagfield".equals(key) && "h2e_sid".equals(billrelationtype)) {
            EntityMapModelEdit.setDefautParm(param, idBillnoProps);
            param.setIncludeEntity(true);
            param.setIncludeHead(false);
        }
    }

    private static void setDefautParm(SelectEntityPropParam param, HashMap<Boolean, List<String>> idBillnoProps) {
        param.setPropTypes(new EntityPropTypeEnum[]{EntityPropTypeEnum.BASEDATA, EntityPropTypeEnum.LONG, EntityPropTypeEnum.STRING, EntityPropTypeEnum.BILL});
        idBillnoProps.put(Boolean.FALSE, Arrays.asList("disabler,disabledate,enabler,enabledate,creator,modifier,auditor,auditdate,modifytime,createtime".split(",")));
    }
}

