/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.investmodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.tmc.fbd.common.enums.CurrencyRuleEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.IntCalMethodEnum;
import kd.tmc.fbp.common.enums.IntHTRuleEnum;
import kd.tmc.fbp.common.enums.InterestTypeEnum;
import kd.tmc.fbp.common.enums.InvestTypeEnum;
import kd.tmc.fbp.common.enums.RoundRuleEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.helper.IntcalMethodChgHelper;

public class InvestModelEdit
extends AbstractBasePlugIn {
    private static final String[] EFFECTPROPS = new String[]{"basis", "intheadtailrule", "intcalmethod", "introundrule", "ratetype", "rateadjustmethod", "effectrule"};

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.interestTypeChgEvt();
        this.currencyRuleChgEvt();
        this.profitTypeChgEvt();
        this.intcalMethodChgEvt();
        this.initInterestTypeEnum();
        this.investvarietiesChgEvt();
    }

    public void afterLoadData(EventObject e) {
        this.checkBaseDateRefrence();
    }

    private void checkBaseDateRefrence() {
        DynamicObject inverstModel = this.getModel().getDataEntity();
        boolean refrenced = BaseDataRefrenceHelper.isRefrenced((String)this.getModel().getDataEntity().getDataEntityType().getName(), (Object)inverstModel.getPkValue());
        if (refrenced) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_delete", "bar_save"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "currencyrule": {
                this.currencyRuleChgEvt();
                break;
            }
            case "ratetype": {
                this.interestTypeChgEvt();
                break;
            }
            case "profittype": {
                this.profitTypeChgEvt();
                break;
            }
            case "intcalmethod": {
                this.intcalMethodChgEvt();
                break;
            }
            case "investvarieties": {
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"intcalmethod", "basis"});
                this.investvarietiesChgEvt();
                this.initInterestTypeEnum();
                break;
            }
        }
    }

    private void currencyRuleChgEvt() {
        String currencyRule = (String)this.getModel().getValue("currencyrule");
        if (StringUtils.equals((CharSequence)CurrencyRuleEnum.ASSIGNCURRENCY.getValue(), (CharSequence)currencyRule)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"currency"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"currency"});
            this.getModel().setValue("currency", null);
        }
    }

    private void interestTypeChgEvt() {
        String interestType = (String)this.getModel().getValue("ratetype");
        if (StringUtils.equals((CharSequence)InterestTypeEnum.FLOAT.getValue(), (CharSequence)interestType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"rateadjustmethod"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"rateresetdays"});
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"rateadjustmethod"});
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"rateadjustmethod", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"rateresetdays"});
            this.getModel().setValue("rateresetdays", null);
        }
    }

    private void profitTypeChgEvt() {
        IDataModel model = this.getModel();
        String profitType = (String)model.getValue("profittype");
        boolean isEffective = StringUtils.equals((CharSequence)profitType, (CharSequence)"share");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!isEffective ? 1 : 0) != 0, (String[])EFFECTPROPS);
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])EFFECTPROPS, (!isEffective ? 1 : 0) != 0);
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"rateresetdays"}, (!isEffective ? 1 : 0) != 0);
        if (isEffective) {
            for (String propName : EFFECTPROPS) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)propName, null);
            }
        } else {
            this.setIfAbsent("basis", BasisEnum.Actual_actual.getValue());
            this.setIfAbsent("intheadtailrule", IntHTRuleEnum.headnotail.getValue());
            this.setIfAbsent("intcalmethod", IntCalMethodEnum.totalcallint.getValue());
            this.setIfAbsent("introundrule", RoundRuleEnum.rounded.getValue());
            this.setIfAbsent("ratetype", "fixed");
            this.setIfAbsent("effectrule", "iousintdate");
        }
    }

    private void intcalMethodChgEvt() {
        DynamicObject inverstModel = this.getModel().getDataEntity();
        Long pkValue = (Long)inverstModel.getPkValue();
        boolean refrenced = BaseDataRefrenceHelper.isRefrenced((String)this.getModel().getDataEntity().getDataEntityType().getName(), (Object)pkValue);
        if (refrenced && pkValue != 0L) {
            return;
        }
        String intcalMethod = (String)this.getModel().getValue("intcalmethod");
        String billStatus = (String)this.getModel().getValue("status");
        ComboEdit basis = (ComboEdit)this.getControl("basis");
        if (basis == null || EmptyUtil.isEmpty((String)intcalMethod)) {
            return;
        }
        List comboItems = IntcalMethodChgHelper.getBasisComboItem((String)intcalMethod, (String)billStatus);
        basis.setComboItems(comboItems);
        if (EmptyUtil.isNoEmpty((Object)comboItems)) {
            this.getModel().setValue("basis", (Object)((ComboItem)comboItems.get(0)).getValue());
        }
    }

    private void investvarietiesChgEvt() {
        boolean isNoEmpty = EmptyUtil.isNoEmpty((Object)this.getModel().getValue("investvarieties"));
        TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"intcalmethod", "basis"}, (boolean)isNoEmpty);
    }

    private void setIfAbsent(String propName, Object value) {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue(propName))) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)propName, (Object)value);
        }
    }

    private void initInterestTypeEnum() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        ComboItem item1 = new ComboItem();
        item1.setValue(InterestTypeEnum.FIXED.getValue());
        item1.setCaption(new LocaleString(ResManager.loadKDString((String)"\u56fa\u5b9a\u6536\u76ca", (String)"InvestModelEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0])));
        comboItems.add(item1);
        ComboItem item2 = new ComboItem();
        item2.setValue(InterestTypeEnum.FLOAT.getValue());
        item2.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6d6e\u52a8\u6536\u76ca", (String)"InvestModelEdit_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0])));
        comboItems.add(item2);
        String investVar = Optional.ofNullable((DynamicObject)this.getModel().getValue("investvarieties")).map(r -> r.getString("investtype")).orElse("");
        if (InvestTypeEnum.isStructure((String)investVar)) {
            ComboItem item3 = new ComboItem();
            item3.setValue(InterestTypeEnum.RANGE.getValue());
            item3.setCaption(new LocaleString(ResManager.loadKDString((String)"\u533a\u95f4\u6536\u76ca", (String)"InvestModelEdit_3", (String)"tmc-fbd-formplugin", (Object[])new Object[0])));
            comboItems.add(item3);
        }
        ComboEdit rateType = (ComboEdit)this.getControl("ratetype");
        rateType.setComboItems(comboItems);
    }
}

