/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.pandamenu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbd.common.enums.PandaPropEnum;
import kd.tmc.fbd.common.enums.PandaSchemeControlEnum;
import kd.tmc.fbd.common.enums.PandaTypeEnum;
import kd.tmc.fbd.common.helper.PandaHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PandaEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final List<String> PANDA_OP_LIST = Arrays.asList("save", "submit", "audit", "donothing", "committobe");
    private static final String BILL_CHECK_FIELD_CACHE = "billCheckFieldCache";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billcondition", "billmatchidfield", "billmatchfield", "billmatchfieldzw", "billmatchidfieldzw", "billnotifyfieldzw", "billnotifyfield", "billcheckname", "materialname"});
        BasedataEdit materialControl = (BasedataEdit)this.getControl("material");
        materialControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObjectCollection menuEntity = this.getModel().getEntryEntity("menuentry");
        for (DynamicObject object : menuEntity) {
            if (Objects.isNull(object)) continue;
            String name = object.getString("menuname");
            object.set("materialname", (Object)name);
        }
        Object bizType = this.getModel().getValue("biztype");
        if (Objects.nonNull(bizType)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!PandaTypeEnum.OTHER.getValue().equals(bizType) ? 1 : 0) != 0, (String[])new String[]{"materialname"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("schemeentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject object = (DynamicObject)((DynamicObject)entryEntity.get(i)).get("bizbill");
            if (Objects.isNull(object)) continue;
            String entityType = object.getString("number");
            this.setComboEditOppItemList(i, entityType);
        }
        this.setSchemeControl(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("material".equals(name)) {
            this.setMaterialName(e);
        } else if ("bizbill".equals(name)) {
            this.setSchemaComboList(e);
        } else if ("biztype".equals(name)) {
            this.setBizTypeChange(e);
        } else if ("billcondition".equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            String newValue = (String)changeData.getNewValue();
            if (StringUtils.isBlank((CharSequence)newValue)) {
                this.getModel().setValue("billconditionval_tag", (Object)"", rowIndex);
            }
        } else if ("menuprop".equals(name)) {
            this.setSchemeControl(true);
        }
        super.propertyChanged(e);
    }

    private void setMaterialName(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        if (Objects.isNull(newValue)) {
            return;
        }
        Object val = newValue.get("name");
        this.getModel().setValue("menuno", newValue.get("number"), rowIndex);
        this.getModel().setValue("menuname", val, rowIndex);
        this.getModel().setValue("materialname", val, rowIndex);
        this.getModel().setValue("menucusname", val, rowIndex);
    }

    private void setSchemaComboList(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        if (Objects.isNull(newValue)) {
            return;
        }
        String entityType = newValue.getString("number");
        this.setComboEditOppItemList(rowIndex, entityType);
    }

    private void setBizTypeChange(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        String type = (String)changeData.getNewValue();
        if (EmptyUtil.isEmpty((String)type)) {
            return;
        }
        TextEdit control = (TextEdit)this.getView().getControl("materialname");
        control.setMustInput(!PandaTypeEnum.OTHER.getValue().equals(type));
        this.getModel().deleteEntryData("menuentry");
        this.getModel().createNewEntryRow("menuentry");
    }

    private void setComboEditOppItemList(int rowIndex, String entityType) {
        List billList = EntityMetadataCache.getDataEntityOperate((String)entityType).stream().filter(t -> PANDA_OP_LIST.contains(t.get("type"))).map(t -> Pair.of((Object)t.get("key").toString(), (Object)((Map)t.get("name")).getOrDefault(Lang.get().toString(), t.get("key")).toString())).collect(Collectors.toList());
        Map<String, String> map = billList.stream().collect(Collectors.toMap(Pair::getKey, Pair::getValue, (p, q) -> p));
        String comboJson = SerializationUtils.toJsonString(map);
        this.getPageCache().put("billcheck" + rowIndex, comboJson);
    }

    private void setSchemeControl(boolean cleanEntry) {
        String menuProp = (String)this.getModel().getValue("menuprop");
        if (EmptyUtil.isBlank((CharSequence)menuProp)) {
            return;
        }
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        items.add(new ComboItem(new LocaleString(PandaSchemeControlEnum.NO.getName()), PandaSchemeControlEnum.NO.getValue()));
        if (PandaPropEnum.WHITE.getValue().equals(menuProp)) {
            items.add(new ComboItem(new LocaleString(PandaSchemeControlEnum.REVERT.getName()), PandaSchemeControlEnum.REVERT.getValue()));
            items.add(new ComboItem(new LocaleString(PandaSchemeControlEnum.WARNREVERT.getName()), PandaSchemeControlEnum.WARNREVERT.getValue()));
        } else if (PandaPropEnum.BLACK.getValue().equals(menuProp)) {
            items.add(new ComboItem(new LocaleString(PandaSchemeControlEnum.YES.getName()), PandaSchemeControlEnum.YES.getValue()));
            items.add(new ComboItem(new LocaleString(PandaSchemeControlEnum.WARNYES.getName()), PandaSchemeControlEnum.WARNYES.getValue()));
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("scheme");
        comboEdit.setComboItems(items);
        if (cleanEntry) {
            this.getModel().deleteEntryData("schemeentry");
            this.getModel().createNewEntryRow("schemeentry");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "billcondition": {
                    this.showBillConditionForm();
                    break;
                }
                case "billmatchidfieldzw": {
                    this.showRowSelectFieldForm(key, BooleanProp.class, false, false);
                    break;
                }
                case "billmatchfieldzw": {
                    this.showRowSelectFieldForm(key, TextProp.class, true, true);
                    break;
                }
                case "billnotifyfieldzw": {
                    this.showRowSelectFieldForm(key, TextProp.class, false, false);
                    break;
                }
                case "billcheckname": {
                    this.showBillCheckForm();
                    break;
                }
                case "materialname": {
                    ItemClassEdit control = (ItemClassEdit)this.getView().getControl("material");
                    control.click();
                    break;
                }
            }
        }
    }

    private void showBillConditionForm() {
        if (TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"bizbill")) {
            int row = this.getModel().getEntryCurrentRowIndex("schemeentry");
            String value = (String)this.getModel().getValue("billconditionval_tag", row);
            DynamicObject entityObj = (DynamicObject)this.getModel().getValue("bizbill", row);
            this.openFilter(entityObj.getString("number"), value);
        }
    }

    private void openFilter(String billEntity, String conditionJson) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billEntity);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setCurrentEntity(billEntity);
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
        String fieldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        this.showConditionForm(conditionJson, mainType.getName(), fieldNodes);
    }

    private void showConditionForm(String conditionJson, String entityName, String fieldNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fcs_ctrlcondition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityName);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "billcondition"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showRowSelectFieldForm(String key, Class<? extends FieldProp> fieldClassType, boolean includeBaseField, boolean isLeaveCheck) {
        TreeNode headTreeNode;
        String rowEntity = "schemeentry";
        String entityTypeKey = "bizbill";
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)entityTypeKey)) {
            return;
        }
        int row = this.getModel().getEntryCurrentRowIndex(rowEntity);
        DynamicObject entityObj = (DynamicObject)this.getModel().getValue(entityTypeKey, row);
        String entityType = entityObj.getString("number");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tmc_selectfield");
        MainEntityType sourceMainType = EntityMetadataCache.getDataEntityType((String)entityType);
        PropTreeBuildOption option = new PropTreeBuildOption(null, fieldClassType);
        option.setCurrentEntity(entityType);
        option.setIncludeChildEntity(false);
        option.setIncludeBDPropPK(false);
        option.setIncludeEntryEntityAsKeyPrefix(true);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceMainType, (PropTreeBuildOption)option);
        if (!includeBaseField && CollectionUtils.isNotEmpty((Collection)treeNode.getChildren()) && CollectionUtils.isNotEmpty((Collection)(headTreeNode = (TreeNode)treeNode.getChildren().get(0)).getChildren())) {
            List headFields = headTreeNode.getChildren().stream().filter(t -> CollectionUtils.isEmpty((Collection)t.getChildren())).collect(Collectors.toList());
            headTreeNode.setChildren(headFields);
        }
        if (CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u65e0\u53ef\u9009\u62e9\u5b57\u6bb5\u3002", (String)"PandaEdit_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (isLeaveCheck) {
            ArrayList<String> leafNode = new ArrayList<String>(16);
            this.setNoLeafDisCheckable(treeNode, leafNode);
            String leafCache = StringUtils.wrap((String)StringUtils.join(leafNode, (String)","), (String)",");
            this.getPageCache().put(BILL_CHECK_FIELD_CACHE, leafCache);
        }
        String toJson = SerializationUtils.toJsonString((Object)treeNode);
        showParameter.getCustomParams().put("treenodes", toJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void setNoLeafDisCheckable(TreeNode headTreeNode, List<String> leafNode) {
        if (CollectionUtils.isNotEmpty((Collection)headTreeNode.getChildren())) {
            headTreeNode.getChildren().forEach(t -> this.setNoLeafDisCheckable((TreeNode)t, leafNode));
        } else {
            leafNode.add(headTreeNode.getId());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (Objects.nonNull(returnData)) {
            String actionId = e.getActionId();
            if ("billcondition".equals(actionId)) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("schemeentry");
                this.getModel().setValue("billconditionval_tag", returnData, rowIndex);
                this.setFilterDescribe(returnData, rowIndex);
            } else if ("billmatchidfieldzw".equals(actionId)) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("schemeentry");
                String val = returnData.toString().split(",")[0];
                if (StringUtils.isNotEmpty((CharSequence)val)) {
                    String valZW = returnData.toString().split(",")[1];
                    if (valZW.contains(".")) {
                        String[] splitStr = valZW.split("\\.");
                        valZW = splitStr.length == 2 ? splitStr[1] : splitStr[1] + "." + splitStr[2];
                        this.getModel().setValue(actionId, (Object)valZW, rowIndex);
                        this.getModel().setValue("billmatchidfield", (Object)val, rowIndex);
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f6\u5b50\u7ed3\u70b9\u5b57\u6bb5\u3002", (String)"PandaEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                    }
                }
            } else if ("billnotifyfieldzw".equals(actionId)) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("schemeentry");
                String val = returnData.toString().split(",")[0];
                if (StringUtils.isNotEmpty((CharSequence)val)) {
                    String valZW = returnData.toString().split(",")[1];
                    if (valZW.contains(".")) {
                        String[] splitStr = valZW.split("\\.");
                        valZW = splitStr.length == 2 ? splitStr[1] : splitStr[1] + "." + splitStr[2];
                        this.getModel().setValue(actionId, (Object)valZW, rowIndex);
                        this.getModel().setValue("billnotifyfield", (Object)val, rowIndex);
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f6\u5b50\u7ed3\u70b9\u5b57\u6bb5\u3002", (String)"PandaEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                    }
                }
            } else if ("billmatchfieldzw".equals(actionId)) {
                String val = returnData.toString().split(",")[0];
                if (StringUtils.isNotBlank((CharSequence)val)) {
                    String valZW = returnData.toString().split(",")[1];
                    String[] splitStr = valZW.split("\\.");
                    String fieldStr = this.getPageCache().get(BILL_CHECK_FIELD_CACHE);
                    if (fieldStr.contains("," + val + ",")) {
                        valZW = splitStr.length == 2 ? splitStr[1] : splitStr[1] + "." + splitStr[2];
                        int rowIndex = this.getModel().getEntryCurrentRowIndex("schemeentry");
                        this.getModel().setValue(actionId, (Object)valZW, rowIndex);
                        this.getModel().setValue("billmatchfield", (Object)val, rowIndex);
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53f6\u5b50\u7ed3\u70b9\u5b57\u6bb5\u3002", (String)"PandaEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                    }
                }
            } else if ("billcheck".equals(actionId)) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("schemeentry");
                List data = (List)returnData;
                ArrayList nums = new ArrayList(data.size());
                ArrayList names = new ArrayList(data.size());
                for (Map map : data) {
                    nums.add(map.get("operationNumber"));
                    names.add(map.get("operationName"));
                }
                String billCheck = StringUtils.join(nums, (String)",");
                billCheck = StringUtils.wrap((String)billCheck, (String)",");
                String billCheckName = StringUtils.join(names, (String)",");
                this.getModel().setValue("billcheck", (Object)billCheck, rowIndex);
                this.getModel().setValue("billcheckname", (Object)billCheckName, rowIndex);
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObject entity = this.getModel().getDataEntity();
        DynamicObjectCollection schemeEntry = entity.getDynamicObjectCollection("schemeentry");
        int rowIndex = 0;
        for (DynamicObject dynamicObject : schemeEntry) {
            DynamicObject bizBill = dynamicObject.getDynamicObject("bizbill");
            String entityNumber = (String)bizBill.get("number");
            String billMatchField = dynamicObject.getString("billmatchfield");
            String billMatchIdField = dynamicObject.getString("billmatchidfield");
            String billNotifyField = dynamicObject.getString("billnotifyfield");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            DataEntityPropertyCollection properties = entityType.getProperties();
            String billMatchFieldConvert = billMatchField.contains(".") ? billMatchField.split("\\.")[0] : billMatchField;
            String billMatchIdFieldConvert = billMatchIdField.contains(".") ? billMatchIdField.split("\\.")[0] : billMatchIdField;
            String billNotifyFieldConvert = billNotifyField.contains(".") ? billNotifyField.split("\\.")[0] : billNotifyField;
            StringBuilder billMatchFieldStr = new StringBuilder();
            StringBuilder billMatchIdFieldStr = new StringBuilder();
            StringBuilder billNotifyFieldStr = new StringBuilder();
            List existBillMatchFieldProp = properties.stream().filter(t -> t.getName().equals(billMatchFieldConvert)).collect(Collectors.toList());
            List existBillMatchIdFieldProp = properties.stream().filter(t -> t.getName().equals(billMatchIdFieldConvert)).collect(Collectors.toList());
            List existBillNotifyFieldProp = properties.stream().filter(t -> t.getName().equals(billNotifyFieldConvert)).collect(Collectors.toList());
            if (existBillMatchFieldProp.size() > 0) {
                PandaHelper.dealFieldZw((String)billMatchField, existBillMatchFieldProp, (StringBuilder)billMatchFieldStr);
                this.getModel().setValue("billmatchfieldzw", (Object)billMatchFieldStr.toString(), rowIndex);
            }
            if (existBillMatchIdFieldProp.size() > 0) {
                PandaHelper.dealFieldZw((String)billMatchIdField, existBillMatchIdFieldProp, (StringBuilder)billMatchIdFieldStr);
                this.getModel().setValue("billmatchidfieldzw", (Object)billMatchIdFieldStr.toString(), rowIndex);
            }
            if (existBillNotifyFieldProp.size() > 0) {
                PandaHelper.dealFieldZw((String)billNotifyField, existBillNotifyFieldProp, (StringBuilder)billNotifyFieldStr);
                this.getModel().setValue("billnotifyfieldzw", (Object)billNotifyFieldStr.toString(), rowIndex);
            }
            ++rowIndex;
        }
    }

    private void setFilterDescribe(Object returnData, int rowIndex) {
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData.toString(), CRCondition.class);
        String desc = condition.getExprDesc();
        if (desc.length() > 50) {
            desc = desc.substring(0, 40) + "......";
        }
        this.getModel().setValue("billcondition", (Object)desc, rowIndex);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("material".equals(key)) {
            this.materialF7(evt);
        }
    }

    private void materialF7(BeforeF7SelectEvent evt) {
        ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter().getShowParameter();
        List hasIds = this.getModel().getEntryEntity("menuentry").stream().filter(t -> Objects.nonNull(t.getDynamicObject("material"))).map(t -> t.getDynamicObject("material").getLong("id")).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(hasIds)) {
            parameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", hasIds));
        }
        parameter.setMultiSelect(true);
    }

    private void showBillCheckForm() {
        if (!TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"bizbill")) {
            return;
        }
        int row = this.getModel().getEntryCurrentRowIndex("schemeentry");
        String json = this.getPageCache().get("billcheck" + row);
        this.getPageCache().put("billcheck", json);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("fbd_panda_prop_list");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("billcheckAll", (Object)json);
        parameter.setCustomParam("billcheck", this.getModel().getValue("billcheck"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "billcheck"));
        this.getView().showForm(parameter);
    }
}

