/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.ratederivative;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbd.formplugin.ratederivative.AbstractRateDericativeEdit;
import kd.tmc.fbp.common.enums.RateTermEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RateDerivativeBatchEdit
extends AbstractRateDericativeEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit inneracct = (BasedataEdit)this.getControl("referrate");
        inneracct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object referRateId = customParams.getOrDefault("referrate", null);
        if (EmptyUtil.isNoEmpty(referRateId)) {
            Object type;
            DynamicObject referRate = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(referRateId.toString()), (String)"tbd_referrate");
            if (EmptyUtil.isNoEmpty((Object)referRateId)) {
                this.getModel().setValue("referrate", referRateId);
                this.getModel().setValue("currency", (Object)referRate.getDynamicObject("currency"));
            }
            if (EmptyUtil.isNoEmpty(type = customParams.getOrDefault("type", null))) {
                this.getModel().setValue("type", type);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (key.equals("referrate")) {
            String type = this.getModel().getDataEntity().getString("type");
            if (EmptyUtil.isEmpty((String)type)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7c7b\u578b\u3002", (String)"RateDerivativeBatchEdit_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            sp.getListFilterParameter().getQFilters().add(this.getreferrateFilter(type));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        String type = this.getModel().getDataEntity().getString("type");
        DynamicObject referRate = this.getModel().getDataEntity().getDynamicObject("referrate");
        switch (key) {
            case "type": {
                this.setMustInput(type);
                if (!EmptyUtil.isNoEmpty((DynamicObject)referRate) || !"forward,futures".contains(type) || !"day,week,twoWeek,threeWeek".contains(referRate.getString("term"))) break;
                this.getModel().setValue("referrate", null);
                break;
            }
            case "referrate": {
                if (EmptyUtil.isNoEmpty((DynamicObject)referRate)) {
                    DynamicObject currency = referRate.getDynamicObject("currency");
                    this.getModel().setValue("currency", (Object)currency);
                } else {
                    this.getModel().setValue("currency", null);
                }
                this.updateNumberForReferRate(referRate);
                break;
            }
            case "term": {
                this.updateNumberForTerm();
            }
        }
    }

    private void updateNumberForReferRate(DynamicObject referRate) {
        String type = this.getModel().getDataEntity().getString("type");
        if (type.equals("swap")) {
            DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
            String referRateNum = referRate.getString("number");
            for (int i = 0; i < entry.getRowCount(); ++i) {
                String term = ((DynamicObject)entry.get(i)).getString("term");
                String termName = "";
                if (EmptyUtil.isNoEmpty((String)term)) {
                    termName = RateTermEnum.getName((String)term).toUpperCase();
                }
                this.getModel().setValue("number", (Object)(referRateNum + "-Swap" + termName), i);
            }
        }
    }

    private void updateNumberForTerm() {
        int index = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        String oldNumber = ((DynamicObject)entry.get(index)).getString("number");
        String str = oldNumber.substring(0, oldNumber.indexOf("Swap") + 4);
        String term = ((DynamicObject)entry.get(index)).getString("term");
        String termName = RateTermEnum.getName((String)term).toUpperCase();
        this.getModel().setValue("number", (Object)(str + termName), index);
    }
}

