/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.referdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.RateTermEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.property.TmcTreeNodeProp;
import kd.tmc.fbp.common.property.TmcTreeNodeRefProp;
import kd.tmc.fbp.common.property.TmcTreeNodeTypeProp;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.tree.AbstractTmcTreeList;

public class ReferDataTreeList
extends AbstractTmcTreeList {
    private static final TmcTreeNodeTypeProp NODE_MARKET = new TmcTreeNodeTypeProp("market", TmcTreeNodeTypeProp.ROOT, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    private static final TmcTreeNodeTypeProp NODE_CURRENCY = new TmcTreeNodeTypeProp("currency", NODE_MARKET, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    private static final TmcTreeNodeTypeProp NODE_TERM = new TmcTreeNodeTypeProp("term", NODE_CURRENCY, TmcTreeNodeTypeProp.LeafMode.LEAF);
    private static final String ADDTREE_ACTIONID = "ADDTREE_ACTIONID";
    private static final String EDITTREE_ACTIONID = "EDITTREE_ACTIONID";
    private static final String CONFIRM_BTNDEL = "CONFIRM_BTNDEL";

    public void createTreeListView(CreateTreeListViewEvent e) {
    }

    public void treeToolbarClick(EventObject e) {
        String btnKey;
        Control ctl = (Control)e.getSource();
        switch (btnKey = ctl.getKey()) {
            case "btnnew": {
                this.addReferRateTree();
                break;
            }
            case "btnedit": {
                this.editReferRateTree();
                break;
            }
            case "btndel": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u7f16\u7801\uff1f", (String)"ReferDataTreeList_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_BTNDEL));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getActionId().equals(ADDTREE_ACTIONID) || evt.getActionId().equals(EDITTREE_ACTIONID)) {
            this.refreshTree(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (StringUtils.equals((CharSequence)event.getCallBackId(), (CharSequence)CONFIRM_BTNDEL) && event.getResult() == MessageBoxResult.Yes) {
            this.delReferRateTree();
        }
    }

    protected List<TmcTreeNodeTypeProp> getTreeNodeTypeList() {
        return Arrays.asList(NODE_MARKET, NODE_CURRENCY, NODE_TERM);
    }

    protected List<TmcTreeNodeRefProp> loadTreeNodeList(TmcTreeNodeProp currNode) {
        List<Object> nodeList = new ArrayList();
        TmcTreeNodeTypeProp nodeType = currNode.getNodeType();
        if (nodeType.equals((Object)TmcTreeNodeTypeProp.ROOT)) {
            nodeList = this.loadmarketNodeList(currNode);
        } else if (nodeType.equals((Object)NODE_MARKET)) {
            nodeList = this.loadCurrencyNodeList(currNode);
        } else if (nodeType.equals((Object)NODE_CURRENCY)) {
            nodeList = this.loadTermNodeList(currNode);
        }
        return nodeList;
    }

    protected QFilter getBillListFilter(TmcTreeNodeProp currNode) {
        Object qfilter;
        TmcTreeNodeTypeProp nodeType = currNode.getNodeType();
        if (NODE_MARKET.equals((Object)nodeType)) {
            qfilter = new QFilter("referrate.market.id", "in", (Object)Long.valueOf(currNode.getRefEntityPkValue().toString()));
        } else if (NODE_CURRENCY.equals((Object)nodeType)) {
            Object marketId = currNode.getParentRefEntityPkValue(NODE_MARKET);
            qfilter = new QFilter("referrate.currency.id", "=", (Object)Long.valueOf(currNode.getRefEntityPkValue().toString())).and("referrate.market.id", "=", (Object)Long.valueOf(marketId.toString()));
        } else {
            qfilter = NODE_TERM.equals((Object)nodeType) ? new QFilter("referrate", "=", (Object)Long.valueOf(currNode.getRefEntityPkValue().toString())) : null;
        }
        return qfilter;
    }

    private List<TmcTreeNodeRefProp> loadmarketNodeList(TmcTreeNodeProp currNode) {
        DynamicObject[] referRates = BusinessDataServiceHelper.load((String)"tbd_referrate", (String)"market", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)});
        Set markets = Arrays.stream(referRates).map(v -> v.getDynamicObject("market")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        ArrayList<TmcTreeNodeRefProp> nodeList = new ArrayList<TmcTreeNodeRefProp>(markets.size());
        for (DynamicObject market : markets) {
            TmcTreeNodeRefProp node = new TmcTreeNodeRefProp();
            node.setNodeName(market.getString("number") + "-" + market.getString("name"));
            node.setNodeType(NODE_MARKET);
            node.setRefEntityPkValue((Object)market.getString("id"));
            nodeList.add(node);
        }
        return nodeList;
    }

    private List<TmcTreeNodeRefProp> loadCurrencyNodeList(TmcTreeNodeProp currNode) {
        Object marketId = currNode.getRefEntityPkValue();
        DynamicObject[] referRates = BusinessDataServiceHelper.load((String)"tbd_referrate", (String)"currency", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true), new QFilter("market", "=", (Object)Long.valueOf(marketId.toString()))});
        Set currencys = Arrays.stream(referRates).map(v -> v.getDynamicObject("currency")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        ArrayList<TmcTreeNodeRefProp> nodeList = new ArrayList<TmcTreeNodeRefProp>(currencys.size());
        for (DynamicObject currency : currencys) {
            TmcTreeNodeRefProp node = new TmcTreeNodeRefProp();
            node.setNodeName(currency.getString("number"));
            node.setNodeType(NODE_CURRENCY);
            node.setRefEntityPkValue((Object)currency.getString("id"));
            nodeList.add(node);
        }
        return nodeList;
    }

    private List<TmcTreeNodeRefProp> loadTermNodeList(TmcTreeNodeProp currNode) {
        Object currencyId = currNode.getRefEntityPkValue();
        Object marketId = currNode.getParentRefEntityPkValue(NODE_MARKET);
        DynamicObject[] referRates = BusinessDataServiceHelper.load((String)"tbd_referrate", (String)"term,number,description", (QFilter[])new QFilter[]{new QFilter("market", "=", (Object)Long.valueOf(marketId.toString())), new QFilter("enable", "=", (Object)true), new QFilter("currency", "=", (Object)Long.valueOf(currencyId.toString()))});
        ArrayList<TmcTreeNodeRefProp> nodeList = new ArrayList<TmcTreeNodeRefProp>(referRates.length);
        for (DynamicObject referRate : referRates) {
            TmcTreeNodeRefProp node = new TmcTreeNodeRefProp();
            StringBuilder sb = new StringBuilder();
            if (EmptyUtil.isNoEmpty((String)referRate.getString("term"))) {
                sb.append(RateTermEnum.getName((String)referRate.getString("term"))).append("-");
            }
            sb.append(referRate.getString("number"));
            String desc = referRate.getString("description");
            if (EmptyUtil.isNoEmpty((String)desc)) {
                sb.append("-").append(desc);
            }
            node.setNodeName(sb.toString());
            node.setNodeType(NODE_TERM);
            node.setRefEntityPkValue((Object)referRate.getString("id"));
            nodeList.add(node);
        }
        return nodeList;
    }

    private void addReferRateTree() {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("tbd_referrate_batch");
        this.initShowParam(showParam);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDTREE_ACTIONID));
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParam);
    }

    private void initShowParam(FormShowParameter showParam) {
        String nodeId = this.getCurrentNodeModel().getNodeId();
        List<TmcTreeNodeTypeProp> parentNode = Arrays.asList(NODE_MARKET, NODE_CURRENCY);
        for (TmcTreeNodeTypeProp typeProp : parentNode) {
            int pTypeIndex;
            String pTypeName = typeProp.getName() + '#';
            boolean containParent = nodeId.contains(pTypeName);
            if (!containParent || (pTypeIndex = nodeId.lastIndexOf(pTypeName)) == -1) continue;
            String substring = nodeId.substring(pTypeIndex);
            int endIndex = substring.contains(String.valueOf('/')) ? substring.indexOf(47) : substring.length();
            showParam.getCustomParams().put(typeProp.getName(), substring.substring(pTypeName.length(), endIndex));
        }
    }

    private void editReferRateTree() {
        TmcTreeNodeTypeProp nodeType = this.getCurrentNodeModel().getNodeType();
        if (nodeType == TmcTreeNodeTypeProp.ROOT) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7f16\u8f91\u6839\u8282\u70b9\u3002", (String)"ReferDataTreeList_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
        } else if (nodeType == NODE_MARKET || nodeType == NODE_CURRENCY) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7f16\u8f91\u975e\u53f6\u5b50\u8282\u70b9\u3002", (String)"ReferDataTreeList_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
        } else {
            Object referDataId = this.getCurrentNodeModel().getRefEntityPkValue();
            BaseShowParameter showParam = new BaseShowParameter();
            showParam.setStatusValue(OperationStatus.EDIT.getValue());
            showParam.setFormId("tbd_referrate");
            showParam.setPkId(referDataId);
            showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDITTREE_ACTIONID));
            showParam.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)showParam);
        }
    }

    private void delReferRateTree() {
        TmcTreeNodeTypeProp nodeType = this.getCurrentNodeModel().getNodeType();
        if (nodeType == TmcTreeNodeTypeProp.ROOT) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"ReferDataTreeList_3", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
        } else if (nodeType == NODE_MARKET || nodeType == NODE_CURRENCY) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u975e\u53f6\u5b50\u8282\u70b9\u3002", (String)"ReferDataTreeList_4", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
        } else {
            Long referDataId = Long.valueOf((String)this.getCurrentNodeModel().getRefEntityPkValue());
            boolean exists = TmcDataServiceHelper.exists((String)"md_datarate", (QFilter[])new QFilter[]{new QFilter("referrate", "=", (Object)referDataId)});
            if (exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9a\u4e49\u7f16\u7801\u4e2d\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ReferDataTreeList_5", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                return;
            }
            OperationResult result = TmcOperateServiceHelper.execOperate((String)"delete", (String)"tbd_referrate", (Object[])new Object[]{referDataId}, (OperateOption)OperateOption.create());
            if (result != null && result.isSuccess()) {
                this.refreshTree(true);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ReferDataTreeList_6", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void refreshTree(boolean isRefreshAll) {
        if (isRefreshAll) {
            this.getTreeModel().setCurrentNodeId((Object)this.getTreeModel().getRoot().getId());
        }
        this.getCurrentNode().setChildren(null);
        this.getTreeListView().refreshTreeView();
    }
}

