/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.release;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyReleaseBill2PayBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String descEntity = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(descEntity)) {
            DynamicObject payBill = dataEntity.getDataEntity();
            String sourceBillType = payBill.getString("sourcebilltype");
            if ("lc_arrival".equals(sourceBillType)) {
                QFilter qFilter = new QFilter("number", "=", (Object)"JSFS08");
                qFilter.and("enable", "=", (Object)"1");
                DynamicObject settleMentType = TmcDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (QFilter[])qFilter.toArray());
                if (EmptyUtil.isNoEmpty((DynamicObject)settleMentType)) {
                    payBill.set("settletype", (Object)settleMentType);
                }
            }
            this.fillData(e, dataEntity, payBill);
        }
    }

    private void fillData(AfterFieldMappingEventArgs e, ExtendedDataEntity dataEntity, DynamicObject payBill) {
        List srcRows = (List)dataEntity.getValue("ConvertSource");
        Object srcId = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
        DynamicObject release = QueryServiceHelper.queryOne((String)"fbd_suretyreleasebill", (String)String.join((CharSequence)",", "repaybillid", "repaybilltype", "suretybill", "currency"), (QFilter[])new QFilter[]{new QFilter("id", "=", srcId)});
        DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (String)String.join((CharSequence)",", "finaccount", "isfinaccountfrozen", "settleaccount"), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)release.getLong("suretybill"))});
        if (!suretyBill.getBoolean("isfinaccountfrozen")) {
            if (EmptyUtil.isNoEmpty((DynamicObject)suretyBill.getDynamicObject("settleaccount"))) {
                this.fillPayeeInfo(payBill, release);
            }
        } else {
            payBill.set("payeracctbank", (Object)suretyBill.getDynamicObject("finaccount"));
            this.fillPayeeInfo(payBill, release);
        }
    }

    private void fillPayeeInfo(DynamicObject payBill, DynamicObject release) {
        String repayBillType;
        switch (repayBillType = release.getString("repaybilltype")) {
            case "lc_arrival": {
                SuretyReleaseBill2PayBillConvertPlugin.dealLcArrivalBill(payBill, release);
                break;
            }
            case "cfm_repaymentbill": {
                break;
            }
            default: {
                SuretyReleaseBill2PayBillConvertPlugin.dealCdmPayableBill(payBill, release);
            }
        }
    }

    private static void dealCdmPayableBill(DynamicObject payBill, DynamicObject release) {
        DynamicObject cdmPayableBill = QueryServiceHelper.queryOne((String)"cdm_payablebill", (String)"receiveraccount,receivername,receiverbank.name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)release.getLong("repaybillid"))});
        if (EmptyUtil.isNoEmpty((DynamicObject)cdmPayableBill)) {
            payBill.set("payeebanknum", (Object)cdmPayableBill.getString("receiveraccount"));
            payBill.set("payeename", (Object)cdmPayableBill.getString("receivername"));
            payBill.set("payeebankname", (Object)cdmPayableBill.getString("receiverbank.name"));
        }
    }

    private static void dealLcArrivalBill(DynamicObject payBill, DynamicObject release) {
        DynamicObject lcArrival = QueryServiceHelper.queryOne((String)"lc_arrival", (String)"benefiter,benefiterother", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)release.getLong("repaybillid"))});
        if (EmptyUtil.isNoEmpty((DynamicObject)lcArrival)) {
            payBill.set("payeebanknum", null);
            payBill.set("payeename", (Object)lcArrival.getString("benefiterother"));
            payBill.set("payeebankname", null);
        }
    }
}

