/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.release;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.tmc.fbd.common.enums.DebtBillTypeEnum;
import kd.tmc.fbd.common.enums.IntDataSource;
import kd.tmc.fbd.common.enums.RevenueWayEnum;
import kd.tmc.fbd.common.helper.SuretyHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.ReleaseSourceEnum;
import kd.tmc.fbp.common.enums.SuretyReleaseTypeEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillDetailInfo;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SuretyReleaseBillEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(SuretyReleaseBillEdit.class);
    private static final String[] repayProps = new String[]{"predictpreinstamt", "entrys", "entrys.inststartdate", "entrys.instenddate", "entrys.instdays", "entrys.instprincipalamt", "entrys.rate", "entrys.ratetrandays", "entrys.instamt"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit finAccount = (BasedataEdit)this.getControl("finaccount");
        finAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entry = (EntryGrid)this.getControl("entry");
        if (entry != null) {
            entry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("org", null);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.disableRevenue(false);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (!StringUtils.equals((CharSequence)BillStatusEnum.SAVE.getValue(), (CharSequence)billStatus)) {
            this.loadRevenuePlanInfo();
        } else {
            this.calRevenuePlanInfo(false);
        }
        this.getModel().setDataChanged(false);
        SuretyHelper.showEntry((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "amount": {
                this.validateReleaseAmount(e, key);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newVal = changeData.getNewValue();
        switch (fieldName) {
            case "releasedate": {
                this.setTypeByDate((Date)newVal);
                this.disableRevenue(true);
                this.calRevenuePlanInfo(false);
                break;
            }
            case "amount": 
            case "isrevenue": {
                this.calRevenuePlanInfo(false);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "entrypush2pay": {
                this.validateDebtEntry(args);
                break;
            }
            case "submit": {
                this.beforeDoSubmit(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "entrypush2pay": {
                OperationResult operationResult = args.getOperationResult();
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.doEntryPush2Pay();
                break;
            }
            case "save": 
            case "submit": {
                this.calRevenuePlanInfo(true);
                break;
            }
            case "beforesubmit": {
                OperationResult result = args.getOperationResult();
                if (result == null || !result.isSuccess()) break;
                result.setShowMessage(false);
                break;
            }
        }
    }

    private void validateDebtEntry(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u503a\u52a1\u4fe1\u606f\u5206\u5f55\u6570\u636e\u3002", (String)"SuretyReleaseBillEdit_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        for (int selectRow : selectRows) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entry", selectRow);
            if (!rowEntity.getBoolean("repaydebt")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c[%s]\u884c,\u672a\u6253\u5f00\u507f\u8fd8\u503a\u52a1\u6309\u94ae,\u4e0d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"SuretyReleaseBillEdit_6", (String)"tmc-fbd-formplugin", (Object[])new Object[]{selectRow + 1}));
                args.setCancel(true);
                return;
            }
            if (rowEntity.getBoolean("repaydebt") && !EmptyUtil.isEmpty((BigDecimal)rowEntity.getBigDecimal("repaydebtamt"))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c[%s]\u884c,\u507f\u8fd8\u91d1\u989d\u4e3a0,\u4e0d\u80fd\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"SuretyReleaseBillEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[]{selectRow + 1}));
            args.setCancel(true);
            return;
        }
    }

    private void doEntryPush2Pay() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entry");
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList<Pair> pushBillIds = new ArrayList<Pair>(selectRows.length);
        for (int selectRow : selectRows) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entry", selectRow);
            if (!rowEntity.getBoolean("repaydebt") || !EmptyUtil.isNoEmpty((BigDecimal)rowEntity.getBigDecimal("repaydebtamt"))) continue;
            Pair pair = Pair.of((Object)rowEntity.getString("debttype"), (Object)rowEntity.getLong("debtbillid"));
            pushBillIds.add(pair);
        }
        if (EmptyUtil.isNoEmpty(pushBillIds)) {
            HashMap<Long, String> opIdErrors = new HashMap<Long, String>(pushBillIds.size());
            for (Pair pushBillId : pushBillIds) {
                Long debtId = (Long)pushBillId.getRight();
                try {
                    OperationResult result = TmcOperateServiceHelper.execOperateWithoutThrow((String)"push2pay", (String)this.getEntityName((Pair<String, Long>)pushBillId), (Object[])this.getEntityId((Pair<String, Long>)pushBillId), (OperateOption)OperateOption.create());
                    if (!EmptyUtil.isEmpty((Object)result) && result.isSuccess()) continue;
                    opIdErrors.put(debtId, this.getErrorMessage(result));
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    opIdErrors.put(debtId, e.getMessage());
                }
            }
            if (EmptyUtil.isNoEmpty(opIdErrors) && opIdErrors.size() > 0) {
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
                HashMap<Long, Pair> idRowMap = new HashMap<Long, Pair>(entrys.size());
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    idRowMap.put(entry.getLong("debtbillid"), Pair.of((Object)i, (Object)entry.getString("debtbillno")));
                }
                StringBuilder sb = new StringBuilder();
                for (Map.Entry entry : opIdErrors.entrySet()) {
                    Long opErrorId = (Long)entry.getKey();
                    String errorInfo = (String)entry.getValue();
                    Integer rowIndo = (Integer)((Pair)idRowMap.get(opErrorId)).getLeft();
                    String debtBillNo = (String)((Pair)idRowMap.get(opErrorId)).getRight();
                    sb.append(String.format(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u503a\u52a1\u4fe1\u606f\u5206\u5f55\u884c\u53f7[%1$s],\u503a\u52a1\u5355\u636e\u7f16\u53f7\u4e3a[%2$s],\u751f\u6210\u4ed8\u6b3e\u5355\u5931\u8d25,\u5931\u8d25\u539f\u56e0\u4e3a\uff1a%3$s,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u751f\u6210\u3002", (String)"SuretyReleaseBillEdit_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0]), rowIndo + 1, debtBillNo, errorInfo));
                    sb.append("\n");
                }
                this.getView().showErrorNotification(sb.toString());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u503a\u52a1\u4fe1\u606f\u5206\u5f55,\u751f\u6210\u4ed8\u6b3e\u5355\u6210\u529f\u3002", (String)"SuretyReleaseBillEdit_3", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private String getErrorMessage(OperationResult result) {
        StringBuilder sb = new StringBuilder();
        List errors = result.getAllErrorInfo();
        for (OperateErrorInfo errorInfo : errors) {
            sb.append(errorInfo.getMessage()).append(";");
        }
        return sb.toString();
    }

    private Long[] getEntityId(Pair<String, Long> pushBillId) {
        Long entityId = (Long)pushBillId.getRight();
        String entityName = (String)pushBillId.getKey();
        if (DebtBillTypeEnum.LC_LETTERCREDIT.getValue().equals(entityName)) {
            return TmcBotpHelper.getTargetBillIds((String)DebtBillTypeEnum.LC_LETTERCREDIT.getValue(), (Object)entityId, (String)"lc_arrival");
        }
        return new Long[]{entityId};
    }

    private String getEntityName(Pair<String, Long> pushBillId) {
        String entityName = (String)pushBillId.getKey();
        if (DebtBillTypeEnum.LC_LETTERCREDIT.getValue().equals(entityName)) {
            return "lc_arrival";
        }
        return entityName;
    }

    private void setTypeByDate(Date releaseDate) {
        String releasetype = SuretyReleaseTypeEnum.EXPIRE.getValue();
        DynamicObject suretyBillF7 = (DynamicObject)this.getModel().getValue("suretybill");
        if (EmptyUtil.isEmpty((DynamicObject)suretyBillF7) || EmptyUtil.isEmpty((Object)releaseDate)) {
            return;
        }
        Date expireDate = suretyBillF7.getDate("expiredate");
        if (EmptyUtil.isEmpty((Object)expireDate)) {
            releasetype = SuretyReleaseTypeEnum.CURRENT.getValue();
        } else if (releaseDate.compareTo(expireDate) < 0) {
            releasetype = SuretyReleaseTypeEnum.INADVANCE.getValue();
            BigDecimal demandRate = (BigDecimal)this.getModel().getValue("demandrate");
            if (EmptyUtil.isEmpty((BigDecimal)demandRate)) {
                this.getModel().setValue("realrevenue", null);
            }
        }
        this.getModel().setValue("releasetype", (Object)releasetype);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("debtbillno".equals(fieldName)) {
            int rowIndex = evt.getRowIndex();
            if (rowIndex <= -1) {
                return;
            }
            DynamicObject entry = this.getModel().getEntryRowEntity("entry", rowIndex);
            Long srcBillId = entry.getLong("debtbillid");
            if (EmptyUtil.isNoEmpty((Long)srcBillId)) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(entry.getString("debttype"));
                parameter.setPkId((Object)srcBillId);
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SuretyReleaseBillEdit_4", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName;
        switch (fieldName = evt.getProperty().getName()) {
            case "finaccount": {
                this.finAccountF7Filter(evt);
                break;
            }
        }
    }

    private void finAccountF7Filter(BeforeF7SelectEvent e) {
        QFilter qFilter = this.getOrgFilter(e);
        if (qFilter == null) {
            return;
        }
        ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qFilter);
    }

    private QFilter getOrgFilter(BeforeF7SelectEvent e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5b58\u6b3e\u7ec4\u7ec7\u201d\u3002", (String)"SuretyReleaseBillEdit_5", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return null;
        }
        return TmcAccountHelper.getAccountBankFilterByOrg((Long)org.getLong("id"));
    }

    private void loadRevenuePlanInfo() {
        boolean isRevenue = (Boolean)this.getModel().getValue("isrevenue");
        if (isRevenue) {
            this.getModel().deleteEntryData("entrys");
            Long id = (Long)this.getModel().getValue("id");
            QFilter qFilter = new QFilter("sourcebillid", "=", (Object)id);
            qFilter.and("datasource", "=", (Object)IntDataSource.SETTLEINT.getValue());
            DynamicObject revenueBill = TmcDataServiceHelper.loadSingle((String)"fbd_surety_settleint", (String)String.join((CharSequence)",", repayProps), (QFilter[])qFilter.toArray());
            if (EmptyUtil.isNoEmpty((DynamicObject)revenueBill)) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"predictinstamt", (Object)revenueBill.getBigDecimal("predictpreinstamt"));
                TableValueSetter vs = this.buildReleaseEntryVs();
                DynamicObjectCollection interestCals = revenueBill.getDynamicObjectCollection("entrys");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)interestCals)) {
                    for (DynamicObject interestCal : interestCals) {
                        vs.addRow(new Object[]{interestCal.getDate("inststartdate"), interestCal.getDate("instenddate"), interestCal.getInt("instdays"), interestCal.getBigDecimal("instprincipalamt"), interestCal.getBigDecimal("rate"), interestCal.getInt("ratetrandays"), interestCal.getBigDecimal("instamt")});
                    }
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.beginInit();
                model.batchCreateNewEntryRow("entrys", vs);
                model.endInit();
                this.getView().updateView("entrys");
            }
        }
    }

    private void validateReleaseAmount(BeforeFieldPostBackEvent e, String key) {
        BigDecimal surplusAmount = (BigDecimal)this.getModel().getValue("surplusamount");
        Object newValue = e.getValue();
        if (EmptyUtil.isEmpty((Object)newValue)) {
            return;
        }
        BigDecimal amount = new BigDecimal((String)newValue);
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amount, surplusAmount}) && amount.compareTo(surplusAmount) > 0) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u51fa\u91d1\u989d\u4e0d\u5141\u8bb8\u8d85\u8fc7\u53ef\u5b58\u51fa\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SuretyReleaseBillEdit_8", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            this.getView().updateView(key);
        }
    }

    private void calRevenuePlanInfo(boolean isSubmit) {
        boolean isRevenue = (Boolean)this.getModel().getValue("isrevenue");
        if (isRevenue) {
            if (!this.vailMustInput()) {
                this.getModel().setValue("isrevenue", (Object)Boolean.FALSE);
                return;
            }
            String releaseType = (String)this.getModel().getValue("releasetype");
            BigDecimal demandRate = (BigDecimal)this.getModel().getValue("demandrate");
            this.getView().setVisible(Boolean.valueOf(!SuretyReleaseTypeEnum.INADVANCE.getValue().equals(releaseType) || !EmptyUtil.isEmpty((BigDecimal)demandRate)), new String[]{"advconap"});
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"predictinstamt", (Object)BigDecimal.ZERO);
            this.getModel().deleteEntryData("entrys");
            DynamicObject suretyBill = (DynamicObject)this.getModel().getValue("suretybill");
            Date lastEndIntDate = suretyBill.getDate("endinstdate");
            Date releaseDate = (Date)this.getModel().getValue("releasedate");
            if (lastEndIntDate != null && !releaseDate.after(lastEndIntDate)) {
                String billStatus = (String)this.getModel().getValue("billstatus");
                if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u51fa\u5355\u7684\u5b58\u51fa\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u5b58\u5165\u5355\u7684\u4e0a\u6b21\u6536\u76ca\u65e5%s\u3002", (String)"SuretyReleaseBillEdit_7", (String)"tmc-fbd-formplugin", (Object[])new Object[]{DateUtils.formatString((Date)DateUtils.getNextDay((Date)lastEndIntDate, (int)1), (String)"yyyy-MM-dd")}));
                }
                return;
            }
            IntBillInfo intBill = SuretyHelper.calcReleaseIntNew((DynamicObject)this.getModel().getDataEntity(true));
            if (intBill != null && intBill.getDetails() != null) {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"predictinstamt", (Object)intBill.getAmount());
                if (!isSubmit && EmptyUtil.isEmpty((Object)this.getModel().getValue("realrevenue"))) {
                    TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"realrevenue", (Object)intBill.getAmount());
                }
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                TableValueSetter vs = this.buildReleaseEntryVs();
                for (IntBillDetailInfo detail : intBill.getDetails()) {
                    vs.addRow(new Object[]{detail.getBeginDate(), detail.getEndDate(), detail.getDays(), detail.getPrinciple(), detail.getRate(), detail.getBasisDay(), detail.getAmount()});
                }
                model.batchCreateNewEntryRow("entrys", vs);
                this.getModel().setDataChanged(false);
            } else {
                this.clearPredictData();
            }
        } else {
            this.clearPredictData();
        }
        this.getView().updateView("entrys");
    }

    private void clearPredictData() {
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"predictinstamt", (Object)BigDecimal.ZERO);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"realrevenue", (Object)BigDecimal.ZERO);
        this.getModel().deleteEntryData("entrys");
    }

    private boolean vailMustInput() {
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"suretybill", "amount", "releasedate"});
    }

    private TableValueSetter buildReleaseEntryVs() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("estartdate", new Object[0]);
        vs.addField("eenddate", new Object[0]);
        vs.addField("edays", new Object[0]);
        vs.addField("efinamount", new Object[0]);
        vs.addField("eplanrevenue", new Object[0]);
        vs.addField("econvertdays", new Object[0]);
        vs.addField("erevenueamount", new Object[0]);
        return vs;
    }

    private void disableRevenue(boolean isChange) {
        DynamicObject suretyBillF7 = (DynamicObject)this.getModel().getValue("suretybill");
        if (EmptyUtil.isNoEmpty((DynamicObject)suretyBillF7)) {
            Boolean isNoRevenue = RevenueWayEnum.NOREVENUE.getValue().equals(suretyBillF7.getString("revenueway"));
            Date releaseDate = (Date)this.getModel().getValue("releasedate");
            Boolean isDateEquals = ReleaseSourceEnum.isSurety((String)((String)this.getModel().getValue("releasesource"))) && releaseDate.compareTo(suretyBillF7.getDate("intdate")) == 0;
            if ((isNoRevenue.booleanValue() || isDateEquals.booleanValue()) && ((Boolean)this.getModel().getValue("isrevenue")).booleanValue()) {
                this.getModel().setValue("isrevenue", (Object)Boolean.FALSE);
            } else if (isChange && !isNoRevenue.booleanValue() && !isDateEquals.booleanValue() && !((Boolean)this.getModel().getValue("isrevenue")).booleanValue()) {
                this.getModel().setValue("isrevenue", (Object)Boolean.TRUE);
            }
            boolean isRevenue = isNoRevenue == false;
            this.getView().setEnable(Boolean.valueOf(isRevenue && isDateEquals == false), new String[]{"isrevenue"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isRevenue, (String[])new String[]{"interesttype"});
            TmcViewInputHelper.registerVisibleStatus((IFormView)this.getView(), (String[])new String[]{"interestrate", "interesttype"}, (boolean)isRevenue);
        }
    }

    private void beforeDoSubmit(BeforeDoOperationEventArgs args) {
        Object pkId;
        boolean isRevenue = (Boolean)this.getModel().getValue("isrevenue");
        if (isRevenue && !TmcDataServiceHelper.exists((Object)(pkId = this.getModel().getValue("id")), (String)"fbd_suretyreleasebill")) {
            args.setCancel(true);
            String newNumber = CodeRuleServiceHelper.getNumber((String)"fbd_suretyreleasebill", (DynamicObject)this.getModel().getDataEntity(), null);
            this.getModel().setValue("billno", (Object)newNumber);
            OperationResult invokeSave = this.getView().invokeOperation("beforesubmit");
            if (invokeSave.isSuccess()) {
                this.getView().invokeOperation("submit");
            }
        }
    }
}

