/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.subscribe;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.tmc.fbd.common.helper.SubscribeHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UserSubscribeEdit
extends AbstractBasePlugIn
implements ClickListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit tplscen = (BasedataEdit)this.getView().getControl("subscribetpl");
        tplscen.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit recuser = (BasedataEdit)this.getView().getControl("recuser");
        recuser.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initSubFilter();
        this.controlValidate();
    }

    public void afterBindData(EventObject e) {
        FilterGrid grid = (FilterGrid)this.getControl("filtergrid");
        grid.setBtnStatus();
    }

    public void afterCopyData(EventObject e) {
        this.effectdayChgEvt((Integer)this.getModel().getValue("effectday"));
    }

    private void initSubFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrsubid");
        DynamicObject dataSource = (DynamicObject)this.getModel().getValue("datasource");
        if (EmptyUtil.isNoEmpty((DynamicObject)dataSource)) {
            filterGrid.setEntityNumber(dataSource.getString("number"));
            filterGrid.SetValue(new FilterCondition());
            this.getView().updateView("filtergrsubid");
            this.loadConditionByFilter("subfilter_tag", "filtergrsubid");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "subscribetpl": {
                this.subscribeTplChgEvt(e);
                break;
            }
            case "subscribedate": {
                this.subscribeDateChgEvt((Date)e.getChangeSet()[0].getNewValue());
                break;
            }
            case "effectday": {
                this.effectdayChgEvt((Integer)e.getChangeSet()[0].getNewValue());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("save".equals(op.getOperateKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrsubid");
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            this.getModel().setValue("subfilter_tag", (Object)SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition()));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "recuser": {
                DynamicObject subTpl = (DynamicObject)this.getModel().getValue("subscribetpl");
                if (EmptyUtil.isEmpty((DynamicObject)subTpl)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba2\u9605\u6a21\u677f\u3002", (String)"UserSubscribeEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                DynamicObject subScribeTpl = TmcDataServiceHelper.loadSingleFromCache((Object)subTpl.getLong("id"), (String)"fbd_subscribetpl");
                if (!EmptyUtil.isNoEmpty((DynamicObject)subScribeTpl)) break;
                DynamicObjectCollection orgEntrys = subScribeTpl.getDynamicObjectCollection("orgentry");
                if (EmptyUtil.isEmpty((DynamicObjectCollection)orgEntrys)) {
                    return;
                }
                List orgList = orgEntrys.stream().map(o -> o.getDynamicObject("org_number").getLong("id")).collect(Collectors.toList());
                Set allUsersIds = UserServiceHelper.getAllUsersOfOrg((int)0, orgList, (boolean)false, (boolean)false);
                FormShowParameter sp = evt.getFormShowParameter();
                ((ListShowParameter)sp).getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)allUsersIds));
            }
        }
    }

    private void effectdayChgEvt(int effectDay) {
        Object subscribeDate = this.getModel().getValue("subscribedate");
        if (EmptyUtil.isNoEmpty((Integer)effectDay) && EmptyUtil.isNoEmpty((Object)subscribeDate)) {
            Date endDate = DateUtils.getNextDay((Date)((Date)subscribeDate), (int)effectDay);
            this.getModel().setValue("validdate", (Object)endDate);
        }
        this.controlValidate();
    }

    private void subscribeDateChgEvt(Date subDate) {
        if (EmptyUtil.isNoEmpty((Object)subDate)) {
            Object validDate = this.getModel().getValue("validdate");
            Object temp = this.getModel().getValue("subscribetpl");
            if (EmptyUtil.isNoEmpty((Object)validDate) && EmptyUtil.isNoEmpty((Object)temp)) {
                int diffDays = DateUtils.getDiffDays((Date)subDate, (Date)((Date)validDate));
                int effectday = (Integer)this.getModel().getValue("effectday");
                Date endDay = DateUtils.getNextDay((Date)subDate, (int)effectday);
                if (diffDays > effectday) {
                    this.getModel().setValue("validdate", (Object)endDay);
                }
                DateEdit control = (DateEdit)this.getView().getControl("validdate");
                control.setMaxDate(endDay);
                control.setMinDate(subDate);
            }
        }
    }

    private void subscribeTplChgEvt(PropertyChangedArgs e) {
        DynamicObject template = (DynamicObject)e.getChangeSet()[0].getNewValue();
        TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"recuser"});
        if (EmptyUtil.isNoEmpty((DynamicObject)template)) {
            template = TmcDataServiceHelper.loadSingleFromCache((Object)template.getPkValue(), (String)"fbd_subscribetpl");
            this.loadItems(template);
            this.loadFilterItem();
            this.initFilterGrid();
        }
    }

    private void initFilterGrid() {
        DynamicObject dataSource = (DynamicObject)this.getModel().getValue("datasource");
        if (dataSource != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrsubid");
            filterGrid.setEntityNumber(dataSource.getString("number"));
            filterGrid.SetValue(new FilterCondition());
            this.getView().updateView("filtergrsubid");
        }
    }

    private void loadItems(DynamicObject template) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        this.getModel().setValue("filter_tag", (Object)template.getString("filter_tag"));
        this.getModel().setValue("fixfilter_tag", (Object)template.getString("fixfilter_tag"));
        this.getModel().setValue("datasource", (Object)template.getDynamicObject("datasource"));
        this.getModel().setValue("tplscen", (Object)template.getDynamicObject("tplscen"));
        this.getModel().setValue("effectday", (Object)0);
        this.getModel().setValue("effectday", (Object)template.getInt("effectday"));
        this.getModel().setValue("maxsubscribe", (Object)template.getInt("maxsubscribe"));
        this.setOperateItems();
        this.getModel().setValue("subscribeop", (Object)template.getString("subscribeop"));
        DynamicObjectCollection dataOrgEntrys = template.getDynamicObjectCollection("dataorgentry");
        model.deleteEntryData("dataorgentry");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("dorg_number", new Object[0]);
        dataOrgEntrys.forEach(o -> vs.addRow(new Object[]{o.getDynamicObject("dorg_number").getPkValue()}));
        model.batchCreateNewEntryRow("dataorgentry", vs);
        this.getView().updateView("dataorgentry");
    }

    private void loadFilterItem() {
        DynamicObject dataSource = (DynamicObject)this.getModel().getValue("datasource");
        if (EmptyUtil.isNoEmpty((DynamicObject)dataSource)) {
            this.loadConditionByFilter("filter_tag", "filtergrid");
            this.loadConditionByFilter("fixfilter_tag", "filtergrfixid");
            this.loadConditionByFilter("subfilter_tag", "filtergrsubid");
        }
    }

    private void loadConditionByFilter(String filterCon, String filterGrid) {
        FilterCondition filterCondition;
        String filter = (String)this.getModel().getValue(filterCon);
        if (EmptyUtil.isNoEmpty((String)filter) && (filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class)) != null) {
            FilterGrid filterControl = (FilterGrid)this.getView().getControl(filterGrid);
            filterControl.SetValue(filterCondition);
        }
    }

    private void controlValidate() {
        int effectDay = (Integer)this.getModel().getValue("effectday");
        Object subscribeDate = this.getModel().getValue("subscribedate");
        if (EmptyUtil.isNoEmpty((Integer)effectDay) && EmptyUtil.isNoEmpty((Object)subscribeDate)) {
            Date endDate = DateUtils.getNextDay((Date)((Date)subscribeDate), (int)effectDay);
            DateEdit control = (DateEdit)this.getView().getControl("validdate");
            control.setMaxDate(endDate);
            control.setMinDate((Date)subscribeDate);
        }
    }

    private void setOperateItems() {
        DynamicObject dataSource = (DynamicObject)this.getModel().getValue("datasource");
        if (EmptyUtil.isEmpty((DynamicObject)dataSource)) {
            return;
        }
        List items = SubscribeHelper.getOperateItems((String)dataSource.getString("number"));
        ComboEdit subscribeOps = (ComboEdit)this.getView().getControl("subscribeop");
        subscribeOps.setComboItems(items);
    }
}

