/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.surety;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbd.common.enums.IntDataSource;
import kd.tmc.fbp.common.helper.TmcBotpHelper;

public class ReleaseRevenueTabEdit
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus()) {
            BillList revenueBillList;
            BillList releaseBillList = (BillList)this.getControl("releasebilllistap");
            if (releaseBillList != null) {
                releaseBillList.addHyperClickListener((HyperLinkClickListener)this);
                QFilter qFilter = this.getReleaseQFilter();
                releaseBillList.addSetFilterListener(setFilterEvent -> setFilterEvent.getQFilters().add(qFilter));
            }
            if ((revenueBillList = (BillList)this.getControl("billlistap")) != null) {
                revenueBillList.addHyperClickListener((HyperLinkClickListener)this);
                QFilter qFilter = this.getRevenueQFilter();
                revenueBillList.addSetFilterListener(setFilterEvent -> setFilterEvent.getQFilters().add(qFilter));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTabListFilter();
    }

    private void initTabListFilter() {
        BillList releaseBillList = (BillList)this.getControl("releasebilllistap");
        this.setBillListFilter(releaseBillList, this.getReleaseQFilter());
        BillList revenueBillList = (BillList)this.getControl("billlistap");
        this.setBillListFilter(revenueBillList, this.getRevenueQFilter());
    }

    private void setBillListFilter(BillList billList, QFilter qFilter) {
        if (billList != null) {
            billList.getFilterParameter().getQFilters().add(qFilter);
            billList.refreshData();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "billno": {
                this.openBillPage(evt);
                break;
            }
            case "recbill_number": {
                BillList sourceBill = (BillList)evt.getSource();
                Long focusRowPkId = (Long)sourceBill.getFocusRowPkId();
                String formId = sourceBill.getEntityId();
                TmcBotpHelper.showBillParamter((String)formId, (Long)focusRowPkId, (IFormView)this.getView(), (String)"cas_recbill");
                break;
            }
            case "paybillid_number": {
                BillList sourceBill = (BillList)evt.getSource();
                Long focusRowPkId = (Long)sourceBill.getFocusRowPkId();
                String formId = sourceBill.getEntityId();
                TmcBotpHelper.showBillParamter((String)formId, (Long)focusRowPkId, (IFormView)this.getView(), (String)"cas_paybill");
                break;
            }
        }
    }

    private QFilter getReleaseQFilter() {
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            return QFilter.of((String)"1=2", (Object[])new Object[0]);
        }
        Long suretyBillId = (Long)this.getModel().getValue("id");
        return new QFilter("suretybill", "=", (Object)suretyBillId);
    }

    private QFilter getRevenueQFilter() {
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            return QFilter.of((String)"1=2", (Object[])new Object[0]);
        }
        Object suretyBillNo = this.getModel().getValue("billno");
        return new QFilter("loanbillno", "=", suretyBillNo).and("datasource", "=", (Object)IntDataSource.SETTLEINT.getValue());
    }

    private void openBillPage(HyperLinkClickEvent evt) {
        BillList sourceBill = (BillList)evt.getSource();
        String formId = sourceBill.getEntityId();
        Object pkId = sourceBill.getFocusRowPkId();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId(pkId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

