/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.surety;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbd.common.enums.DeductTypeEnum;
import kd.tmc.fbd.common.enums.RevenueWayEnum;
import kd.tmc.fbd.common.helper.SuretyIntCalcHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.SuretyBizStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class SuretyEntryEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String SURETY_PROPS = String.join((CharSequence)",", "id", "billno", "bizstatus", "finorginfo", "investorgtype", "finorgother", "currency", "amount", "surplusamount");

    public void registerListener(EventObject e) {
        EntryGrid entry = (EntryGrid)this.getControl("entry");
        if (entry != null) {
            entry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long srcId = (Long)this.getView().getFormShowParameter().getCustomParam("srcId");
        Object currencyId = this.getView().getFormShowParameter().getCustomParam("srcCurrencyId");
        QFilter idFilter = new QFilter("entry.debtbillid", "=", (Object)srcId);
        idFilter.and("bizstatus", "in", Arrays.asList(SuretyBizStatusEnum.SURETY_DONE.getValue(), SuretyBizStatusEnum.SURETY_PART.getValue()));
        idFilter.and("enable", "=", (Object)true);
        if (EmptyUtil.isNoEmpty((Object)currencyId)) {
            idFilter.and("currency.id", "=", currencyId);
        }
        DynamicObject[] suretyBills = TmcDataServiceHelper.load((String)"fbd_suretybill", (String)SURETY_PROPS, (QFilter[])new QFilter[]{idFilter});
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entry");
        for (DynamicObject suretyBill : suretyBills) {
            DynamicObject suretyEntry = entry.addNew();
            suretyEntry.set("deducttype", (Object)DeductTypeEnum.PRINCIPAL_REPAY.getValue());
            suretyEntry.set("suretybill", (Object)suretyBill);
            suretyEntry.set("bizstatus", (Object)suretyBill.getString("bizstatus"));
            suretyEntry.set("finorginfo", (Object)suretyBill.getDynamicObject("finorginfo"));
            suretyEntry.set("investorgtype", (Object)suretyBill.getString("investorgtype"));
            suretyEntry.set("finorgother", (Object)suretyBill.getString("finorgother"));
            suretyEntry.set("currency", (Object)suretyBill.getDynamicObject("currency"));
            suretyEntry.set("amount", (Object)suretyBill.getBigDecimal("amount"));
            suretyEntry.set("surplusamount", (Object)suretyBill.getBigDecimal("surplusamount"));
            suretyEntry.set("repaydate", (Object)new Date());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (property) {
            case "deducttype": 
            case "repaydate": 
            case "repayamount": {
                this.callInt(rowIndex);
                break;
            }
            case "repayintamount": {
                Object repayAmount = this.getModel().getValue("repayamount");
                if (EmptyUtil.isEmpty((Object)repayAmount)) {
                    return;
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repaytotalamount", (Object)((BigDecimal)repayAmount).add(EmptyUtil.isEmpty((Object)newValue) ? Constants.ZERO : (BigDecimal)newValue), (int)rowIndex);
                break;
            }
        }
    }

    private void callInt(int rowIndex) {
        String deductType = (String)this.getModel().getValue("deducttype", rowIndex);
        Date repayDate = (Date)this.getModel().getValue("repaydate", rowIndex);
        BigDecimal repayAmount = (BigDecimal)this.getModel().getValue("repayamount", rowIndex);
        if (EmptyUtil.isEmpty((Object)repayDate) || EmptyUtil.isEmpty((BigDecimal)repayAmount)) {
            return;
        }
        if (!DeductTypeEnum.INTEREST_REPAY.getValue().equals(deductType)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repaytotalamount", (Object)repayAmount, (int)rowIndex);
            return;
        }
        Long suretyBillId = ((DynamicObject)this.getModel().getValue("suretybill", rowIndex)).getLong("id");
        DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)suretyBillId)});
        IntBillInfo intBill = SuretyIntCalcHelper.callInt((DynamicObject)suretyBill, (Date)repayDate, (BigDecimal)repayAmount);
        BigDecimal repayIntAmt = intBill == null ? Constants.ZERO : intBill.getAmount();
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repayintamount", (Object)repayIntAmt, (int)rowIndex);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"repaytotalamount", (Object)repayAmount.add(repayIntAmt), (int)rowIndex);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String fieldName = source.getKey();
        Object value = e.getValue();
        int rowIndex = e.getRowIndex();
        if (StringUtils.equals((CharSequence)"deducttype", (CharSequence)fieldName) && DeductTypeEnum.INTEREST_REPAY.getValue().equals(value)) {
            Long suretyBillId = ((DynamicObject)this.getModel().getValue("suretybill", rowIndex)).getLong("id");
            DynamicObject suretyBill = QueryServiceHelper.queryOne((String)"fbd_suretybill", (String)"revenueway", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)suretyBillId)});
            if (EmptyUtil.isNoEmpty((DynamicObject)suretyBill) && !RevenueWayEnum.STAGE.getValue().equals(suretyBill.getString("revenueway"))) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u6536\u76ca\u7c7b\u578b\u4e3a\u65e0\u6536\u76ca\uff0c\u4e0d\u5141\u8bb8\u9009\u62e9\u672c\u606f\u62b5\u6263\u3002", (String)"SuretyEntryEdit_9", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                this.getView().updateView("deducttype", rowIndex);
            }
        } else if (StringUtils.equals((CharSequence)"repayintamount", (CharSequence)fieldName) && DeductTypeEnum.INTEREST_REPAY.getValue().equals(this.getModel().getValue("deducttype", rowIndex))) {
            Date repayDate = (Date)this.getModel().getValue("repaydate", rowIndex);
            BigDecimal repayAmount = (BigDecimal)this.getModel().getValue("repayamount", rowIndex);
            if (EmptyUtil.isNoEmpty((Object)repayDate) && EmptyUtil.isNoEmpty((BigDecimal)repayAmount)) {
                BigDecimal repayIntAmt;
                Long suretyBillId = ((DynamicObject)this.getModel().getValue("suretybill", rowIndex)).getLong("id");
                DynamicObject suretyBill = TmcDataServiceHelper.loadSingle((String)"fbd_suretybill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)suretyBillId)});
                IntBillInfo intBill = SuretyIntCalcHelper.callInt((DynamicObject)suretyBill, (Date)repayDate, (BigDecimal)repayAmount);
                BigDecimal bigDecimal = repayIntAmt = intBill == null ? Constants.ZERO : intBill.getAmount();
                if (EmptyUtil.isNoEmpty((Object)value) && EmptyUtil.isEmpty((BigDecimal)repayIntAmt)) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62b5\u6263\u65e5\u671f\uff0c\u5229\u606f\u6d4b\u7b97\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SuretyEntryEdit_10", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                    this.getView().updateView("repayintamount", rowIndex);
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)"confirm", (CharSequence)operateKey) && !this.checkValidate()) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evtArgs) {
        if (StringUtils.equals((CharSequence)"confirm", (CharSequence)evtArgs.getOperateKey()) && evtArgs.getOperationResult().isSuccess()) {
            Map<Long, DynamicObject> valMap = this.getReturnMap();
            HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
            returnMap.put("valueMap", valMap);
            returnMap.put("srcEntity", this.getView().getFormShowParameter().getCustomParam("srcEntity"));
            returnMap.put("bizno", this.getView().getFormShowParameter().getCustomParam("bizno"));
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        }
    }

    private Map<Long, DynamicObject> getReturnMap() {
        int[] rows;
        HashMap<Long, DynamicObject> valMap = new HashMap<Long, DynamicObject>(16);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        for (int index : rows = entryGrid.getSelectRows()) {
            DynamicObject entry = (DynamicObject)entrys.get(index);
            DynamicObject suretyBill = entry.getDynamicObject("suretybill");
            valMap.put((Long)suretyBill.getPkValue(), entry);
        }
        return valMap;
    }

    private boolean checkValidate() {
        BigDecimal toPayAmount;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry");
        int[] rows = entryGrid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"SuretyEntryEdit_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        BigDecimal totalAmount = Constants.ZERO;
        for (int index : rows) {
            DynamicObject entry = (DynamicObject)entrys.get(index);
            String bizStatus = entry.getString("bizstatus");
            if (!SuretyBizStatusEnum.SURETY_DONE.getValue().equals(bizStatus) && !SuretyBizStatusEnum.SURETY_PART.getValue().equals(bizStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u72b6\u6001\u4e3a\u201c\u5df2\u5b58\u5165\u201d\u6216\u201c\u90e8\u5206\u5b58\u51fa\u201d\u7684\u4fdd\u8bc1\u91d1\u3002", (String)"SuretyEntryEdit_1", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                return false;
            }
            DynamicObject suretyBill = entry.getDynamicObject("suretybill");
            Date lastReleaseDate = suretyBill.getDate("lastreleasedate");
            Date repayDate = entry.getDate("repaydate");
            if (EmptyUtil.isEmpty((Object)repayDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62b5\u6263\u65e5\u671f\u3002", (String)"SuretyEntryEdit_3", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (EmptyUtil.isNoEmpty((Object)lastReleaseDate) && repayDate.before(lastReleaseDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62b5\u6263\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4fdd\u8bc1\u91d1\u5355\u636e\u7684\u4e0a\u6b21\u5b58\u51fa\u65e5\u671f\u3002", (String)"SuretyEntryEdit_2", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                return false;
            }
            BigDecimal repayAmount = entry.getBigDecimal("repayamount");
            if (EmptyUtil.isEmpty((BigDecimal)repayAmount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u62b5\u6263\u91d1\u989d\u3002", (String)"SuretyEntryEdit_5", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                return false;
            }
            BigDecimal surplusAmount = entry.getBigDecimal("surplusamount");
            if (repayAmount.compareTo(surplusAmount) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62b5\u6263\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u4fdd\u8bc1\u91d1\u5269\u4f59\u91d1\u989d\u3002", (String)"SuretyEntryEdit_7", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                return false;
            }
            QFilter qFilter = new QFilter("suretybill", "=", suretyBill.getPkValue());
            qFilter.and("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue());
            boolean exists = TmcDataServiceHelper.exists((String)"fbd_suretyreleasebill", (QFilter[])qFilter.toArray());
            if (exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u5355\u4e0b\u5b58\u5728\u6d41\u7a0b\u4e2d\u7684\u5b58\u51fa\u5355\u8bb0\u5f55\u672a\u5904\u7406\u3002", (String)"SuretyEntryEdit_6", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
                return false;
            }
            totalAmount = totalAmount.add(repayAmount.add(entry.getBigDecimal("repayintamount")));
        }
        BigDecimal sumPayAmt = BigDecimal.ZERO;
        QFilter filter = new QFilter("billstatus", "not in", Arrays.asList("G", "F")).and("sourcebillid", "=", this.getView().getFormShowParameter().getCustomParam("bizId"));
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"cas_paybill", (String)"actpayamt", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)payBills)) {
            sumPayAmt = payBills.stream().map(d -> d.getBigDecimal("actpayamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (totalAmount.compareTo((toPayAmount = (BigDecimal)this.getView().getFormShowParameter().getCustomParam("todoamount")).subtract(sumPayAmt)) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u8d85\u51fa\u6700\u5927\u53ef\u62b5\u6263\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SuretyEntryEdit_4", (String)"tmc-fbd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        switch (fieldName = evt.getFieldName()) {
            case "suretybill": {
                int rowIndex = evt.getRowIndex();
                if (rowIndex <= -1) break;
                DynamicObject suretyBill = (DynamicObject)this.getModel().getValue("suretybill", rowIndex);
                if (EmptyUtil.isNoEmpty((DynamicObject)suretyBill)) {
                    BillShowParameter parameter = new BillShowParameter();
                    parameter.setFormId("fbd_suretybill");
                    parameter.setPkId((Object)suretyBill.getLong("id"));
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    parameter.setStatus(OperationStatus.VIEW);
                    this.getView().showForm((FormShowParameter)parameter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SuretyEntryEdit_8", (String)"tmc-fbp-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

