/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fbd.formplugin.suretypreint;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.tmc.fbd.common.helper.SuretyIntCalcHelper;
import kd.tmc.fbp.common.enums.SuretyBizStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.model.interest.IntBillInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.preint.AbstractTmcIntBillNavAddNewPlugin;
import kd.tmc.fbp.formplugin.list.preint.TmcNavAddNewBillParam;

public class SuretyBillPreIntNavAddNewPlugin
extends AbstractTmcIntBillNavAddNewPlugin {
    private static final String PROP_FBASEDATAID = "fbasedataid";
    private static final String PROP_ENDINTDATE = "bizdate";

    protected List<Object> beforeCalcInterest(TmcNavAddNewBillParam navAddNewBillParam) {
        List loanBillIds;
        String showBillPropName = navAddNewBillParam.getBillPropName();
        String selectBillIds = this.getPageCache().get(showBillPropName);
        if (EmptyUtil.isEmpty((String)selectBillIds)) {
            QFilter qFilter = this.buildSelectBillFilter();
            loanBillIds = QueryServiceHelper.queryPrimaryKeys((String)navAddNewBillParam.getBillEntityName(), (QFilter[])qFilter.toArray(), (String)"", (int)-1);
        } else {
            loanBillIds = (List)SerializationUtils.fromJsonString((String)selectBillIds, List.class);
        }
        return loanBillIds;
    }

    protected Map<Object, IntBillInfo> calcInterest(TmcNavAddNewBillParam navAddNewBillParam, List<Object> loanBillIds) {
        DynamicObject[] loanBillList;
        HashMap<Object, IntBillInfo> interestMap = new HashMap<Object, IntBillInfo>();
        for (DynamicObject loanBill : loanBillList = TmcDataServiceHelper.load((Object[])loanBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)navAddNewBillParam.getBillEntityName()))) {
            Date beginDate = this.getStartDate(loanBill);
            Date endDate = (Date)this.getModel().getValue(PROP_ENDINTDATE);
            IntBillInfo intBillInfo = SuretyIntCalcHelper.callInt((Long)loanBill.getLong("id"), (Date)beginDate, (Date)endDate);
            if (intBillInfo == null || !EmptyUtil.isNoEmpty((BigDecimal)intBillInfo.getAmount())) continue;
            interestMap.put(DynamicObjectSerializeUtil.serialize((Object[])new Object[]{loanBill}, (DynamicObjectType)loanBill.getDynamicObjectType()), intBillInfo);
        }
        return interestMap;
    }

    protected TmcNavAddNewBillParam getNavAddNewBillParam() {
        TmcNavAddNewBillParam param = new TmcNavAddNewBillParam();
        param.setBillPropName("loanbill").setBillEntityName("fbd_suretybill");
        return param;
    }

    protected Map<String, Object> getNavFilterMap() {
        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
        valMap.put("company", this.getModel().getValue("company"));
        valMap.put("currency", this.getModel().getValue("currency"));
        Date bizDate = (Date)this.getModel().getValue(PROP_ENDINTDATE);
        valMap.put(PROP_ENDINTDATE, DateUtils.formatString((Date)bizDate, (String)"yyyy-MM-dd"));
        valMap.put("calcIntResult", this.getPageCache().get("calcIntResult"));
        return valMap;
    }

    protected QFilter buildSelectBillFilter() {
        List<String> bizStatus = Arrays.asList(SuretyBizStatusEnum.SURETY_DONE.getValue(), SuretyBizStatusEnum.SURETY_PART.getValue());
        QFilter qFilter = new QFilter("bizstatus", "in", bizStatus);
        DynamicObjectCollection company = (DynamicObjectCollection)this.getModel().getValue("company");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)company)) {
            Set companyIds = company.stream().map(v -> v.getDynamicObject(PROP_FBASEDATAID).getPkValue()).collect(Collectors.toSet());
            qFilter.and("org", "in", companyIds);
        } else {
            qFilter.and("org", "in", this.getAuthOrgIds());
        }
        DynamicObjectCollection currency = (DynamicObjectCollection)this.getModel().getValue("currency");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)currency)) {
            Set ids = currency.stream().map(c -> c.getDynamicObject(PROP_FBASEDATAID).getLong("id")).collect(Collectors.toSet());
            qFilter.and("currency", "in", ids);
        }
        Date endIntDate = (Date)this.getModel().getValue(PROP_ENDINTDATE);
        QFilter beforePreIntDate = QFilter.isNotNull((String)"endpreinstdate").and("endpreinstdate", "<", (Object)endIntDate);
        QFilter afterIntDate = QFilter.isNull((String)"endpreinstdate").and("intdate", "<=", (Object)endIntDate);
        qFilter.and(beforePreIntDate.or(afterIntDate));
        Object loanIds = this.getView().getFormShowParameter().getCustomParams().get("loanIds");
        if (EmptyUtil.isNoEmpty(loanIds)) {
            qFilter.and("id", "not in", loanIds);
        }
        return qFilter;
    }

    private List<Long> getAuthOrgIds() {
        String appId = this.getView().getFormShowParameter().getAppId();
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entity, (String)"47150e89000000ac");
        return comIdList;
    }

    public String getNonIntDataTip() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u9884\u63d0\u7684\u6570\u636e\u3002", (String)"SuretyBillPreIntNavAddNewPlugin_0", (String)"tmc-fbd-formplugin", (Object[])new Object[0]);
    }

    public Date getStartDate(DynamicObject loanBill) {
        Date preBeginDate = loanBill.getDate("endpreinstdate");
        preBeginDate = EmptyUtil.isNoEmpty((Object)preBeginDate) ? DateUtils.getNextDay((Date)preBeginDate, (int)1) : loanBill.getDate("intdate");
        return preBeginDate;
    }
}

